/*
 * Decompiled with CFR 0.152.
 */
package mono.android.incrementaldeployment;

import android.util.Log;
import dalvik.system.BaseDexClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;

public class IncrementalClassLoader
extends ClassLoader {
    private final DelegateClassLoader delegateClassLoader;

    public IncrementalClassLoader(ClassLoader classLoader, String string, File file, String string2, List<String> list) {
        super(classLoader.getParent());
        this.delegateClassLoader = IncrementalClassLoader.createDelegateClassLoader(file, string2, list, classLoader);
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        return this.delegateClassLoader.findClass(string);
    }

    private static DelegateClassLoader createDelegateClassLoader(File file, String string, List<String> list, ClassLoader classLoader) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(string2);
        }
        Log.v((String)"IncrementalClassLoader", (String)("Incremental dex path is " + stringBuilder));
        Log.v((String)"IncrementalClassLoader", (String)("Native lib dir is " + string));
        return new DelegateClassLoader(stringBuilder.toString(), file, string, classLoader);
    }

    private static void setParent(ClassLoader classLoader, ClassLoader classLoader2) {
        try {
            Field field = ClassLoader.class.getDeclaredField("parent");
            field.setAccessible(true);
            field.set(classLoader, classLoader2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }

    public static void inject(ClassLoader classLoader, String string, File file, String string2, List<String> list) {
        IncrementalClassLoader incrementalClassLoader = new IncrementalClassLoader(classLoader, string, file, string2, list);
        IncrementalClassLoader.setParent(classLoader, incrementalClassLoader);
    }

    private static class DelegateClassLoader
    extends BaseDexClassLoader {
        private DelegateClassLoader(String string, File file, String string2, ClassLoader classLoader) {
            super(string, file, string2, classLoader);
        }

        public Class<?> findClass(String string) throws ClassNotFoundException {
            return super.findClass(string);
        }
    }
}

