/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android.ast;

import com.microsoft.android.ast.HasJavadocComment;
import com.microsoft.android.ast.JniMemberInfo;
import com.microsoft.android.ast.JniPackageInfo;
import com.microsoft.android.util.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class JniTypeInfo
implements HasJavadocComment {
    private final String name;
    private final JniPackageInfo declaringPackage;
    private final Collection<JniMemberInfo> members = new ArrayList<JniMemberInfo>();
    private final Collection<String> typeParameters = new ArrayList<String>();
    private final Map<String, String> jniTypes = new HashMap<String, String>();
    String javaDocComment = "";

    JniTypeInfo(JniPackageInfo declaringPackage, String name) {
        Parameter.requireNotNull("declaringPackage", declaringPackage);
        name = Parameter.requireNotEmpty("name", name);
        this.declaringPackage = declaringPackage;
        this.name = name;
    }

    public abstract String getTypeKind();

    public final JniPackageInfo getDeclaringPackage() {
        return this.declaringPackage;
    }

    public final String getName() {
        if (this.typeParameters.isEmpty()) {
            return this.name;
        }
        return this.name + "<" + String.join((CharSequence)",", this.typeParameters) + ">";
    }

    public final String getRawName() {
        return this.name;
    }

    public final void addTypeParameter(String typeParameter, String jniType) {
        typeParameter = Parameter.requireNotEmpty("typeParameter", typeParameter);
        jniType = Parameter.requireNotEmpty("jniType", jniType);
        if (this.typeParameters.contains(typeParameter)) {
            this.jniTypes.replace(typeParameter, jniType);
            return;
        }
        this.typeParameters.add(typeParameter);
        this.jniTypes.put(typeParameter, jniType);
    }

    public final Collection<String> getTypeParameters() {
        return this.typeParameters;
    }

    public final String getTypeParameterJniType(String typeParameter) {
        typeParameter = Parameter.requireNotEmpty("typeParameter", typeParameter);
        return this.jniTypes.get(typeParameter);
    }

    public final void add(JniMemberInfo member) {
        Parameter.requireNotNull("member", member);
        this.members.add(member);
    }

    public final Collection<JniMemberInfo> getMembers() {
        return this.members;
    }

    @Override
    public final String getJavadocComment() {
        return this.javaDocComment;
    }

    @Override
    public final void setJavadocComment(String javaDocComment) {
        this.javaDocComment = Parameter.normalize(javaDocComment, "");
    }

    public final Collection<JniMemberInfo> getSortedMembers() {
        List<JniMemberInfo> sortedMembers = this.members.stream().sorted((m1, m22) -> (m1.getName() + "." + m1.getJniSignature()).compareTo(m22.getName() + "." + m22.getJniSignature())).collect(Collectors.toList());
        return sortedMembers;
    }
}

