/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android.ast;

import com.microsoft.android.ast.JniPackageInfo;
import com.microsoft.android.util.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class JniPackagesInfo {
    private final Map<String, JniPackageInfo> packages = new HashMap<String, JniPackageInfo>();

    public JniPackageInfo getPackage(String packageName) {
        if (!this.packages.containsKey(packageName = Parameter.normalize(packageName, ""))) {
            JniPackageInfo newPackage = new JniPackageInfo(packageName);
            this.packages.put(packageName, newPackage);
            return newPackage;
        }
        return this.packages.get(packageName);
    }

    public final Collection<JniPackageInfo> getPackages() {
        return this.packages.values();
    }

    public final Collection<JniPackageInfo> getSortedPackages() {
        List<JniPackageInfo> sortedPackages = this.packages.values().stream().sorted((p1, p2) -> p1.getPackageName().compareTo(p2.getPackageName())).collect(Collectors.toList());
        return sortedPackages;
    }
}

