/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android.ast;

import com.microsoft.android.ast.JniTypeInfo;
import com.microsoft.android.util.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class JniPackageInfo {
    private final String packageName;
    private final Map<String, JniTypeInfo> types = new HashMap<String, JniTypeInfo>();

    public JniPackageInfo(String packageName) {
        this.packageName = packageName = Parameter.normalize(packageName, "");
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final JniTypeInfo getType(String typeName) {
        return this.types.getOrDefault(typeName, null);
    }

    public final void add(JniTypeInfo type) {
        if (this.types.containsKey(type.getName())) {
            throw new IllegalArgumentException("type");
        }
        this.types.put(type.getName(), type);
    }

    public final Collection<JniTypeInfo> getTypes() {
        return this.types.values();
    }

    public final Collection<JniTypeInfo> getSortedTypes() {
        List<JniTypeInfo> sortedTypes = this.types.values().stream().sorted((t1, t2) -> t1.getRawName().compareTo(t2.getRawName())).collect(Collectors.toList());
        return sortedTypes;
    }
}

