/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android.ast;

import com.microsoft.android.ast.JniMethodBaseInfo;
import com.microsoft.android.ast.JniTypeInfo;
import com.microsoft.android.util.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class JniMethodInfo
extends JniMethodBaseInfo {
    private String javaReturnType;
    private String jniReturnType;
    private final Collection<String> typeParameters = new ArrayList<String>();
    private final Map<String, String> jniTypes = new HashMap<String, String>();

    public JniMethodInfo(JniTypeInfo declaringType, String name) {
        super(declaringType, name);
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    public final void setReturnType(String javaType, String jniType) {
        this.javaReturnType = Parameter.normalize(javaType, "void");
        this.jniReturnType = Parameter.normalize(jniType, "V");
    }

    public final void addTypeParameter(String typeParameter, String jniType) {
        typeParameter = Parameter.requireNotEmpty("typeParameter", typeParameter);
        jniType = Parameter.requireNotEmpty("jniType", jniType);
        if (this.typeParameters.contains(typeParameter)) {
            throw new IllegalArgumentException("Already added Type Parameter `" + typeParameter + "`");
        }
        this.typeParameters.add(typeParameter);
        this.jniTypes.put(typeParameter, jniType);
    }

    public final Collection<String> getTypeParameters() {
        return this.typeParameters;
    }

    public final String getTypeParameterJniType(String typeParameter) {
        typeParameter = Parameter.requireNotEmpty("typeParameter", typeParameter);
        return this.jniTypes.get(typeParameter);
    }

    @Override
    public String getJniSignature() {
        return super.getJniSignature() + this.jniReturnType;
    }

    public final String getJavaReturnType() {
        return this.javaReturnType;
    }

    public final String getJniReturnType() {
        return this.jniReturnType;
    }
}

