/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android;

import com.microsoft.android.ast.JniMethodBaseInfo;
import com.microsoft.android.ast.JniMethodInfo;
import com.microsoft.android.ast.JniPackageInfo;
import com.microsoft.android.ast.JniPackagesInfo;
import com.microsoft.android.ast.JniParameterInfo;
import com.microsoft.android.ast.JniTypeInfo;
import com.microsoft.android.util.Parameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ParameterNameGenerator
implements AutoCloseable {
    final PrintStream output;

    public ParameterNameGenerator(String output) throws FileNotFoundException, UnsupportedEncodingException {
        if (output == null) {
            this.output = System.out;
        } else {
            File file = new File(output);
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            this.output = new PrintStream(file, "UTF-8");
        }
    }

    public ParameterNameGenerator(PrintStream output) {
        Parameter.requireNotNull("output", output);
        this.output = output;
    }

    @Override
    public void close() {
        if (this.output != System.out) {
            this.output.flush();
            this.output.close();
        }
    }

    public final void writePackages(JniPackagesInfo packages) {
        Parameter.requireNotNull("packages", packages);
        boolean first = true;
        for (JniPackageInfo packageInfo : packages.getSortedPackages()) {
            if (!first) {
                this.output.println();
            }
            first = false;
            this.writePackage(packageInfo);
        }
    }

    private final void writePackage(JniPackageInfo packageInfo) {
        if (packageInfo.getPackageName().length() > 0) {
            this.output.println("package " + packageInfo.getPackageName());
        }
        this.output.println(";---------------------------------------");
        for (JniTypeInfo type : packageInfo.getSortedTypes()) {
            this.writeType(type);
        }
    }

    private final void writeType(JniTypeInfo type) {
        this.output.println("  " + type.getTypeKind() + " " + type.getName());
        List sortedMethods = type.getSortedMembers().stream().filter(member -> member.isMethod() || member.isConstructor()).map(member -> (JniMethodBaseInfo)member).filter(method -> method.getParameters().size() > 0).collect(Collectors.toList());
        for (JniMethodBaseInfo method2 : sortedMethods) {
            JniMethodInfo m3;
            Collection<String> typeParameters;
            this.output.print("    ");
            if (method2.isMethod() && (typeParameters = (m3 = (JniMethodInfo)method2).getTypeParameters()).size() > 0) {
                this.output.print("<");
                this.output.print(String.join((CharSequence)", ", typeParameters));
                this.output.print("> ");
            }
            this.output.print(method2.getName());
            this.output.print("(");
            boolean first = true;
            for (JniParameterInfo parameter : method2.getParameters()) {
                if (!first) {
                    this.output.print(", ");
                }
                first = false;
                this.output.print(parameter.javaType);
                this.output.print(" ");
                this.output.print(parameter.name);
            }
            this.output.print(")");
            this.output.println();
        }
    }
}

