/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.Position;
import com.github.javaparser.Problem;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.microsoft.android.JavaSourceUtilsOptions;
import com.microsoft.android.ast.HasJavadocComment;
import com.microsoft.android.ast.JniClassInfo;
import com.microsoft.android.ast.JniConstructorInfo;
import com.microsoft.android.ast.JniFieldInfo;
import com.microsoft.android.ast.JniInterfaceInfo;
import com.microsoft.android.ast.JniMethodBaseInfo;
import com.microsoft.android.ast.JniMethodInfo;
import com.microsoft.android.ast.JniPackageInfo;
import com.microsoft.android.ast.JniPackagesInfo;
import com.microsoft.android.ast.JniParameterInfo;
import com.microsoft.android.ast.JniTypeInfo;
import com.microsoft.android.util.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class JniPackagesInfoFactory {
    final JavaParser parser;

    public JniPackagesInfoFactory(JavaParser parser) {
        Parameter.requireNotNull("parser", parser);
        this.parser = parser;
    }

    public JniPackagesInfo parse(Collection<File> files) throws Throwable {
        Parameter.requireNotNull("files", files);
        JniPackagesInfo packages = new JniPackagesInfo();
        for (File file : files) {
            ParseResult<CompilationUnit> result = this.parser.parse(file);
            Optional<CompilationUnit> unit = result.getResult();
            if (!unit.isPresent()) {
                JniPackagesInfoFactory.logParseErrors(file, result.getProblems());
                continue;
            }
            this.parse(packages, unit.get());
        }
        return packages;
    }

    private static void logParseErrors(File file, List<Problem> problems) {
        System.err.println("java-source-utils: could not parse file `" + file.getName() + "`:");
        for (Problem p : problems) {
            System.err.print("\t");
            Optional<TokenRange> location = p.getLocation();
            if (location.isPresent()) {
                System.err.print(location.get());
                System.err.print(": ");
            }
            System.err.println(p.getVerboseMessage());
            if (!JavaSourceUtilsOptions.verboseOutput || !p.getCause().isPresent()) continue;
            p.getCause().get().printStackTrace(System.err);
        }
    }

    private void parse(JniPackagesInfo packages, CompilationUnit unit) throws Throwable {
        String packageName = unit.getPackageDeclaration().isPresent() ? unit.getPackageDeclaration().get().getNameAsString() : "";
        JniPackageInfo packageInfo = packages.getPackage(packageName);
        this.fixJavadocComments(unit, unit.getTypes());
        for (TypeDeclaration<?> type : unit.getTypes()) {
            if (JavaSourceUtilsOptions.verboseOutput && type.getFullyQualifiedName().isPresent()) {
                System.out.println("Processing: " + type.getFullyQualifiedName().get());
            }
            if (type.isAnnotationDeclaration()) {
                AnnotationDeclaration annoDecl = type.asAnnotationDeclaration();
                JniTypeInfo annoInfo = JniPackagesInfoFactory.createAnnotationInfo(packageInfo, annoDecl, null);
                this.parseType(packageInfo, annoInfo, annoDecl);
                continue;
            }
            if (type.isClassOrInterfaceDeclaration()) {
                ClassOrInterfaceDeclaration typeDecl = type.asClassOrInterfaceDeclaration();
                JniTypeInfo typeInfo = JniPackagesInfoFactory.createTypeInfo(packageInfo, typeDecl, null);
                this.parseType(packageInfo, typeInfo, typeDecl);
                continue;
            }
            if (type.isEnumDeclaration()) {
                EnumDeclaration enumDecl = type.asEnumDeclaration();
                JniTypeInfo nestedEnum = JniPackagesInfoFactory.createEnumInfo(packageInfo, enumDecl, null);
                this.parseType(packageInfo, nestedEnum, enumDecl);
                continue;
            }
            System.out.println("# TODO: unknown type decl " + type.getClass().getName());
            System.out.println(type.toString());
        }
    }

    static JniTypeInfo createAnnotationInfo(JniPackageInfo packageInfo, AnnotationDeclaration annotationDecl, JniTypeInfo declInfo) {
        String declName = declInfo == null ? "" : declInfo.getRawName() + ".";
        JniInterfaceInfo annotationInfo = new JniInterfaceInfo(packageInfo, declName + annotationDecl.getNameAsString());
        packageInfo.add(annotationInfo);
        JniPackagesInfoFactory.fillJavadoc(annotationInfo, annotationDecl);
        if (declInfo != null) {
            for (String typeParameter : declInfo.getTypeParameters()) {
                annotationInfo.addTypeParameter(typeParameter, declInfo.getTypeParameterJniType(typeParameter));
            }
        }
        return annotationInfo;
    }

    static JniTypeInfo createEnumInfo(JniPackageInfo packageInfo, EnumDeclaration enumDecl, JniTypeInfo declInfo) {
        String declName = declInfo == null ? "" : declInfo.getRawName() + ".";
        JniClassInfo enumInfo = new JniClassInfo(packageInfo, declName + enumDecl.getNameAsString());
        packageInfo.add(enumInfo);
        JniPackagesInfoFactory.fillJavadoc(enumInfo, enumDecl);
        if (declInfo != null) {
            for (String typeParameter : declInfo.getTypeParameters()) {
                enumInfo.addTypeParameter(typeParameter, declInfo.getTypeParameterJniType(typeParameter));
            }
        }
        return enumInfo;
    }

    static JniTypeInfo createTypeInfo(JniPackageInfo packageInfo, ClassOrInterfaceDeclaration typeDecl, JniTypeInfo declInfo) {
        String declName = declInfo == null ? "" : declInfo.getRawName() + ".";
        JniTypeInfo typeInfo = typeDecl.isInterface() ? new JniInterfaceInfo(packageInfo, declName + typeDecl.getNameAsString()) : new JniClassInfo(packageInfo, declName + typeDecl.getNameAsString());
        packageInfo.add(typeInfo);
        JniPackagesInfoFactory.fillJavadoc(typeInfo, typeDecl);
        if (declInfo != null) {
            for (String string : declInfo.getTypeParameters()) {
                typeInfo.addTypeParameter(string, declInfo.getTypeParameterJniType(string));
            }
        }
        for (TypeParameter typeParameter : typeDecl.getTypeParameters()) {
            typeInfo.addTypeParameter(typeParameter.getNameAsString(), JniPackagesInfoFactory.getJniType(typeInfo, null, JniPackagesInfoFactory.getTypeParameterBound(typeParameter)));
        }
        return typeInfo;
    }

    static ClassOrInterfaceType getTypeParameterBound(TypeParameter typeParameter) {
        Iterator<ClassOrInterfaceType> iterator = typeParameter.getTypeBound().iterator();
        if (iterator.hasNext()) {
            ClassOrInterfaceType boundType = iterator.next();
            return boundType;
        }
        return null;
    }

    private final void parseType(JniPackageInfo packageInfo, JniTypeInfo typeInfo, TypeDeclaration<?> typeDecl) {
        this.fixJavadocComments(typeDecl, this.getUndocumentedBodyMembers(typeDecl.getMembers()));
        for (BodyDeclaration<?> body : typeDecl.getMembers()) {
            if (body.isAnnotationDeclaration()) {
                AnnotationDeclaration annoDecl = body.asAnnotationDeclaration();
                JniTypeInfo annoInfo = JniPackagesInfoFactory.createAnnotationInfo(packageInfo, annoDecl, typeInfo);
                this.parseType(packageInfo, annoInfo, annoDecl);
                continue;
            }
            if (body.isClassOrInterfaceDeclaration()) {
                ClassOrInterfaceDeclaration nestedDecl = body.asClassOrInterfaceDeclaration();
                JniTypeInfo nestedType = JniPackagesInfoFactory.createTypeInfo(packageInfo, nestedDecl, typeInfo);
                this.parseType(packageInfo, nestedType, nestedDecl);
                continue;
            }
            if (body.isEnumDeclaration()) {
                EnumDeclaration enumDecl = body.asEnumDeclaration();
                JniTypeInfo nestedEnum = JniPackagesInfoFactory.createEnumInfo(packageInfo, enumDecl, typeInfo);
                this.parseType(packageInfo, nestedEnum, enumDecl);
                continue;
            }
            if (body.isAnnotationMemberDeclaration()) {
                this.parseAnnotationMemberDecl(typeInfo, body.asAnnotationMemberDeclaration());
                continue;
            }
            if (body.isConstructorDeclaration()) {
                this.parseConstructorDecl(typeInfo, body.asConstructorDeclaration());
                continue;
            }
            if (body.isFieldDeclaration()) {
                this.parseFieldDecl(typeInfo, body.asFieldDeclaration());
                continue;
            }
            if (body.isMethodDeclaration()) {
                this.parseMethodDecl(typeInfo, body.asMethodDeclaration());
                continue;
            }
            if (body.isInitializerDeclaration()) continue;
            System.out.println("# TODO: unknown body member " + body.getClass().getName());
            System.out.println(body.toString());
        }
    }

    private final void fixJavadocComments(Node decl, Iterable<? extends BodyDeclaration<?>> bodyMembers) {
        List<BodyDeclaration<?>> members = this.getUndocumentedBodyMembers(bodyMembers);
        List<JavadocComment> orphanedComments = this.getOrphanComments(decl);
        if (members.size() == 0) {
            return;
        }
        BodyDeclaration<?> firstMember = members.get(0);
        JavadocComment comment = orphanedComments.stream().filter(c -> c.getBegin().get().isBefore(firstMember.getBegin().get())).reduce((a, b) -> b).orElse(null);
        if (comment != null) {
            ((NodeWithJavadoc)((Object)firstMember)).setJavadocComment(comment);
        }
        for (int i = 1; i < members.size(); ++i) {
            BodyDeclaration<?> prevMember = members.get(i - 1);
            BodyDeclaration<?> member = members.get(i);
            Optional<JavadocComment> commentOpt = orphanedComments.stream().filter(c -> c.getBegin().get().isAfter(prevMember.getEnd().get()) && c.getEnd().get().isBefore(member.getBegin().get())).findFirst();
            if (!commentOpt.isPresent()) continue;
            ((NodeWithJavadoc)((Object)member)).setJavadocComment(commentOpt.get());
        }
    }

    private final List<BodyDeclaration<?>> getUndocumentedBodyMembers(Iterable<? extends BodyDeclaration<?>> bodyMembers) {
        ArrayList members = new ArrayList();
        for (BodyDeclaration<?> member : bodyMembers) {
            Optional<Position> memberBeginOpt;
            NodeWithJavadoc memberJavadoc;
            if (!(member instanceof NodeWithJavadoc) || (memberJavadoc = (NodeWithJavadoc)((Object)member)).getJavadocComment().isPresent() || !(memberBeginOpt = member.getBegin()).isPresent()) continue;
            members.add(member);
        }
        members.sort((a, b) -> a.getBegin().get().compareTo(b.getBegin().get()));
        return members;
    }

    private final List<JavadocComment> getOrphanComments(Node decl) {
        ArrayList<JavadocComment> orphanedComments = new ArrayList<JavadocComment>(decl.getOrphanComments().size());
        for (Comment c : decl.getOrphanComments()) {
            Optional<Position> commentBeginOpt;
            if (!c.isJavadocComment() || !(commentBeginOpt = c.getBegin()).isPresent()) continue;
            orphanedComments.add(c.asJavadocComment());
        }
        orphanedComments.sort((a, b) -> a.getBegin().get().compareTo(b.getBegin().get()));
        return orphanedComments;
    }

    private final void parseAnnotationMemberDecl(JniTypeInfo typeInfo, AnnotationMemberDeclaration memberDecl) {
        JniMethodInfo methodInfo = new JniMethodInfo(typeInfo, memberDecl.getNameAsString());
        typeInfo.add(methodInfo);
        methodInfo.setReturnType(JniPackagesInfoFactory.getJavaType(typeInfo, methodInfo, memberDecl.getType()), JniPackagesInfoFactory.getJniType(typeInfo, methodInfo, memberDecl.getType()));
        JniPackagesInfoFactory.fillJavadoc(methodInfo, memberDecl);
    }

    private final void parseFieldDecl(JniTypeInfo typeInfo, FieldDeclaration fieldDecl) {
        for (VariableDeclarator f : fieldDecl.getVariables()) {
            JniFieldInfo fieldInfo = new JniFieldInfo(typeInfo, f.getNameAsString());
            fieldInfo.setJniType(JniPackagesInfoFactory.getJniType(typeInfo, null, f.getType()));
            typeInfo.add(fieldInfo);
            JniPackagesInfoFactory.fillJavadoc(fieldInfo, fieldDecl);
        }
    }

    private final void parseConstructorDecl(JniTypeInfo typeInfo, ConstructorDeclaration ctorDecl) {
        JniConstructorInfo ctorInfo = new JniConstructorInfo(typeInfo);
        typeInfo.add(ctorInfo);
        this.fillMethodBase(ctorInfo, ctorDecl);
        JniPackagesInfoFactory.fillJavadoc(ctorInfo, ctorDecl);
    }

    private final void parseMethodDecl(JniTypeInfo typeInfo, MethodDeclaration methodDecl) {
        JniMethodInfo methodInfo = new JniMethodInfo(typeInfo, methodDecl.getNameAsString());
        typeInfo.add(methodInfo);
        for (TypeParameter typeParameter : methodDecl.getTypeParameters()) {
            methodInfo.addTypeParameter(typeParameter.getNameAsString(), JniPackagesInfoFactory.getJniType(typeInfo, methodInfo, JniPackagesInfoFactory.getTypeParameterBound(typeParameter)));
        }
        methodInfo.setReturnType(JniPackagesInfoFactory.getJavaType(typeInfo, methodInfo, methodDecl.getType()), JniPackagesInfoFactory.getJniType(typeInfo, methodInfo, methodDecl.getType()));
        this.fillMethodBase(methodInfo, methodDecl);
        JniPackagesInfoFactory.fillJavadoc(methodInfo, methodDecl);
    }

    private static final void fillJavadoc(HasJavadocComment member, NodeWithJavadoc<?> nodeWithJavadoc) {
        JavadocComment javadoc = null;
        if (nodeWithJavadoc.getJavadocComment().isPresent()) {
            javadoc = nodeWithJavadoc.getJavadocComment().get();
        }
        if (javadoc != null) {
            member.setJavadocComment(javadoc.parse().toText());
        }
    }

    private final void fillMethodBase(JniMethodBaseInfo methodBaseInfo, CallableDeclaration<?> callableDecl) {
        JniMethodInfo methodInfo = null;
        if (methodBaseInfo instanceof JniMethodInfo) {
            methodInfo = (JniMethodInfo)methodBaseInfo;
        }
        CallableDeclaration<?> params = callableDecl;
        for (com.github.javaparser.ast.body.Parameter p : params.getParameters()) {
            String name = p.getNameAsString();
            String javaType = JniPackagesInfoFactory.getJavaType(methodBaseInfo.getDeclaringType(), methodInfo, p.getType());
            String jniType = JniPackagesInfoFactory.getJniType(methodBaseInfo.getDeclaringType(), methodInfo, p.getType());
            methodBaseInfo.addParameter(new JniParameterInfo(name, javaType, jniType));
        }
    }

    static String getJavaType(JniTypeInfo typeInfo, JniMethodInfo methodInfo, Type type) {
        String typeName = type.asString();
        if (methodInfo != null && methodInfo.getTypeParameters().contains(typeName)) {
            return typeName;
        }
        if (typeInfo.getTypeParameters().contains(typeName)) {
            return typeName;
        }
        try {
            ResolvedType rt = type.resolve();
            return rt.describe();
        }
        catch (Throwable thr) {
            return JniPackagesInfoFactory.getUnresolvedJavaType(type);
        }
    }

    static String getJniType(JniTypeInfo typeInfo, JniMethodInfo methodInfo, Type type) {
        if (type == null) {
            return "Ljava/lang/Object;";
        }
        if (type.isArrayType()) {
            return JniPackagesInfoFactory.getJniType(typeInfo, methodInfo, type.asArrayType());
        }
        if (type.isPrimitiveType()) {
            return JniPackagesInfoFactory.getPrimitiveJniType(type.asString());
        }
        if (methodInfo != null && methodInfo.getTypeParameters().contains(type.asString())) {
            return methodInfo.getTypeParameterJniType(type.asString());
        }
        if (typeInfo.getTypeParameters().contains(type.asString())) {
            return typeInfo.getTypeParameterJniType(type.asString());
        }
        try {
            return JniPackagesInfoFactory.getJniType(type.resolve());
        }
        catch (Exception exception) {
            return JniPackagesInfoFactory.getUnresolvedJniType(type);
        }
    }

    static String getJniType(JniTypeInfo typeInfo, JniMethodInfo methodInfo, ArrayType type) {
        int level = type.getArrayLevel();
        StringBuilder depth = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            depth.append("[");
        }
        return depth.toString() + JniPackagesInfoFactory.getJniType(typeInfo, methodInfo, type.getElementType());
    }

    static String getPrimitiveJniType(String javaType) {
        switch (javaType) {
            case "boolean": {
                return "Z";
            }
            case "byte": {
                return "B";
            }
            case "char": {
                return "C";
            }
            case "double": {
                return "D";
            }
            case "float": {
                return "F";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "short": {
                return "S";
            }
            case "void": {
                return "V";
            }
        }
        throw new Error("Don't know JNI type for primitive type `" + javaType + "`!");
    }

    static String getJniType(ResolvedType type) {
        if (type.isPrimitive()) {
            return JniPackagesInfoFactory.getPrimitiveJniType(type.asPrimitive().describe());
        }
        if (type.isReferenceType()) {
            return JniPackagesInfoFactory.getJniType(type.asReferenceType());
        }
        if (type.isVoid()) {
            return "V";
        }
        return "-" + type.getClass().getName() + "-";
    }

    static String getJniType(ResolvedReferenceType type) {
        Optional<ResolvedReferenceTypeDeclaration> typeDeclOpt = type.getTypeDeclaration();
        if (!typeDeclOpt.isPresent()) {
            throw new Error("Can't get `ResolvedReferenceTypeDeclaration` for type `" + type.toString() + "`!");
        }
        ResolvedReferenceTypeDeclaration typeDecl = typeDeclOpt.get();
        if (!type.hasName()) {
            throw new Error("Type `" + type.toString() + "` has no name!");
        }
        StringBuilder name = new StringBuilder();
        name.append("L");
        name.append(typeDecl.getPackageName());
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            if (name.charAt(i) != '.') continue;
            name.setCharAt(i, '/');
        }
        if (len > 1) {
            name.append("/");
        }
        name.append(typeDecl.getName().replace(".", "$"));
        name.append(";");
        return name.toString();
    }

    static String getUnresolvedJavaType(Type type) {
        StringBuilder jniType = new StringBuilder();
        jniType.append(".*");
        if (type.isClassOrInterfaceType()) {
            type.ifClassOrInterfaceType(c -> {
                c.getScope().ifPresent(s2 -> jniType.append(s2.asString()).append("."));
                jniType.append(c.getName().asString());
            });
        } else {
            jniType.append(type.asString());
        }
        return jniType.toString();
    }

    static String getUnresolvedJniType(Type type) {
        StringBuilder jniType = new StringBuilder();
        jniType.append("L.*");
        if (type.isClassOrInterfaceType()) {
            type.ifClassOrInterfaceType(c -> {
                c.getScope().ifPresent(s2 -> jniType.append(s2.asString()).append("."));
                jniType.append(c.getName().asString());
            });
        } else {
            jniType.append(type.asString());
        }
        jniType.append(";");
        return jniType.toString();
    }
}

