/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android;

import com.microsoft.android.ast.JniMemberInfo;
import com.microsoft.android.ast.JniMethodBaseInfo;
import com.microsoft.android.ast.JniMethodInfo;
import com.microsoft.android.ast.JniPackageInfo;
import com.microsoft.android.ast.JniPackagesInfo;
import com.microsoft.android.ast.JniParameterInfo;
import com.microsoft.android.ast.JniTypeInfo;
import com.microsoft.android.util.Parameter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JavadocXmlGenerator
implements AutoCloseable {
    final PrintStream output;
    Document document;
    Element api;

    public JavadocXmlGenerator(String output) throws FileNotFoundException, ParserConfigurationException, UnsupportedEncodingException {
        if (output == null) {
            this.output = System.out;
        } else {
            File file = new File(output);
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            this.output = new PrintStream(file, "UTF-8");
        }
        this.startApi();
    }

    public JavadocXmlGenerator(PrintStream output) throws ParserConfigurationException {
        Parameter.requireNotNull("output", output);
        this.output = output;
        this.startApi();
    }

    private void startApi() throws ParserConfigurationException {
        this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.api = this.document.createElement("api");
        this.api.setAttribute("api-source", "java-source-utils");
        this.document.appendChild(this.api);
    }

    @Override
    public void close() throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(this.document), new StreamResult(this.output));
        if (this.output != System.out) {
            this.output.flush();
            this.output.close();
        }
    }

    public final void writeCopyrightInfo(File copyright, String urlPrefix, String urlStyle) throws IOException, ParserConfigurationException {
        Element info = this.document.createElement("javadoc-metadata");
        if (copyright != null) {
            Element blurb = this.document.createElement("copyright");
            NodeList contents = this.readXmlFile(copyright);
            if (contents == null) {
                byte[] data = Files.readAllBytes(copyright.toPath());
                blurb.appendChild(this.document.createCDATASection(new String(data, StandardCharsets.UTF_8)));
            } else {
                int len = contents.getLength();
                for (int i = 0; i < len; ++i) {
                    blurb.appendChild(this.document.importNode(contents.item(i), true));
                }
            }
            info.appendChild(blurb);
        }
        if (urlPrefix != null && urlStyle != null) {
            Element link = this.document.createElement("link");
            link.setAttribute("prefix", urlPrefix);
            link.setAttribute("style", urlStyle);
            info.appendChild(link);
        }
        if (info.hasChildNodes()) {
            this.api.appendChild(info);
        }
    }

    final NodeList readXmlFile(File file) throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        try {
            Document contents = builder.parse(file);
            return contents.getChildNodes();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public final void writePackages(JniPackagesInfo packages) throws ParserConfigurationException, TransformerException {
        Parameter.requireNotNull("packages", packages);
        for (JniPackageInfo packageInfo : packages.getSortedPackages()) {
            JavadocXmlGenerator.writePackage(this.document, this.api, packageInfo);
        }
    }

    private static final void writePackage(Document document, Element api, JniPackageInfo packageInfo) {
        Element packageXml = document.createElement("package");
        packageXml.setAttribute("name", packageInfo.getPackageName());
        packageXml.setAttribute("jni-name", packageInfo.getPackageName().replace(".", "/"));
        api.appendChild(packageXml);
        for (JniTypeInfo typeInfo : packageInfo.getSortedTypes()) {
            JavadocXmlGenerator.writeType(document, packageXml, typeInfo);
        }
    }

    private static final void writeType(Document document, Element packageXml, JniTypeInfo typeInfo) {
        Element typeXml = document.createElement(typeInfo.getTypeKind());
        typeXml.setAttribute("name", typeInfo.getRawName());
        typeXml.setAttribute("jni-signature", JavadocXmlGenerator.getTypeJniName(typeInfo));
        packageXml.appendChild(typeXml);
        JavadocXmlGenerator.writeJavadoc(document, typeXml, typeInfo.getJavadocComment());
        for (JniMemberInfo memberInfo : typeInfo.getSortedMembers()) {
            JavadocXmlGenerator.writeMember(document, typeXml, memberInfo);
        }
    }

    private static String getTypeJniName(JniTypeInfo typeInfo) {
        String packageName = typeInfo.getDeclaringPackage().getPackageName();
        StringBuilder name = new StringBuilder();
        name.append("L");
        if (packageName.length() > 0) {
            name.append(packageName.replace(".", "/"));
            name.append("/");
        }
        name.append(typeInfo.getRawName().replace(".", "$"));
        name.append(";");
        return name.toString();
    }

    private static final void writeJavadoc(Document document, Element parent, String javadoc) {
        if ((javadoc = Parameter.normalize(javadoc, "")).length() == 0) {
            return;
        }
        Element javadocXml = document.createElement("javadoc");
        parent.appendChild(javadocXml);
        javadocXml.appendChild(document.createCDATASection(javadoc));
    }

    private static void writeMember(Document document, Element typeXml, JniMemberInfo memberInfo) {
        JniMethodBaseInfo paramsInfo = null;
        int paramsCount = 0;
        if (memberInfo.isConstructor() || memberInfo.isMethod()) {
            paramsInfo = (JniMethodBaseInfo)memberInfo;
            paramsCount = paramsInfo.getParameters().size();
        }
        String javadoc = Parameter.normalize(memberInfo.getJavadocComment(), "");
        if (paramsCount == 0 && javadoc.length() == 0) {
            return;
        }
        Element memberXml = document.createElement(JavadocXmlGenerator.getMemberXmlElement(memberInfo));
        if (!memberInfo.isConstructor()) {
            memberXml.setAttribute("name", memberInfo.getName());
        }
        memberXml.setAttribute("jni-signature", memberInfo.getJniSignature());
        typeXml.appendChild(memberXml);
        if (memberInfo.isMethod()) {
            JniMethodInfo methodInfo = (JniMethodInfo)memberInfo;
            memberXml.setAttribute("return", methodInfo.getJavaReturnType());
            memberXml.setAttribute("jni-return", methodInfo.getJniReturnType());
        }
        if (paramsInfo != null) {
            for (JniParameterInfo paramInfo : paramsInfo.getParameters()) {
                Element parameter = document.createElement("parameter");
                parameter.setAttribute("name", paramInfo.name);
                parameter.setAttribute("type", paramInfo.javaType);
                parameter.setAttribute("jni-type", paramInfo.jniType);
                memberXml.appendChild(parameter);
            }
        }
        JavadocXmlGenerator.writeJavadoc(document, memberXml, memberInfo.getJavadocComment());
    }

    private static String getMemberXmlElement(JniMemberInfo member) {
        if (member.isConstructor()) {
            return "constructor";
        }
        if (member.isMethod()) {
            return "method";
        }
        if (member.isField()) {
            return "field";
        }
        throw new Error("Don't know XML element for: " + member.toString());
    }
}

