/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.AarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JavaSourceUtilsOptions
implements AutoCloseable {
    public static final String HELP_STRING = "[-v] [<-a|--aar> AAR]* [<-j|--jar> JAR]* [<-s|--source> DIRS]*\n\t[--bootclasspath CLASSPATH]\n\t[<-P|--output-params> OUT.params.txt] [<-D|--output-javadoc> OUT.xml]\n\t[--doc-copyright FILE] [--doc-url-prefix URL] [--doc-url-style STYLE]\n\t[@RESPONSE-FILE]* FILES\n\nOptions:\n      @RESPONSE-FILE         Additional options to parse, one option per line.\n      FILES                  .java files to parse.\n  -v                         Verbose output; show diagnostic information.\n  -h, -?, --help             Show this message and exit.\n\nJava type resolution options:\n      --bootclasspath CLASSPATH\n                             '" + File.pathSeparator + "'-separated list of .jar files to use\n                               for type resolution.\n  -a, --aar FILE             .aar file to use for type resolution.\n  -j, --jar FILE             .jar file to use for type resolution.\n  -s, --source DIR           Directory containing .java files for type\n                               resolution purposes.  DOES NOT parse all files.\n\nDocumentation copyright file options:\n  Results in an additional '/api/javadoc-metadata' element when using\n  --output-javadoc.\n      --doc-copyright FILE   Copyright information for Javadoc.  Should be in\n                               mdoc(5) XML, to be held within <remarks/>.\n                               Stored in //javadoc-metadata/copyright.\n      --doc-url-prefix URL   Base URL for links to documentation.\n                               Stored in //javadoc-metadata/link/@prefix.\n      --doc-url-style STYLE  STYLE of URLs to generate for member links.\n                               Stored in //javadoc-metadata/link/@style.\n                               Supported styles include:\n                               - developer.android.com/reference@2020-Nov\n\nOutput file options:\n  -P, --output-params FILE   Write method parameter names to FILE.\n  -D, --output-javadoc FILE  Write Javadoc within XML container to FILE.\n";
    public static boolean verboseOutput;
    public final List<File> aarFiles = new ArrayList<File>();
    public final List<File> jarFiles = new ArrayList<File>();
    public final Collection<File> inputFiles = new ArrayList<File>();
    public boolean haveBootClassPath;
    public String outputParamsTxt;
    public String outputJavadocXml;
    public File docCopyrightFile;
    public String docUrlPrefix;
    public String docUrlStyle;
    private final Collection<File> sourceDirectoryFiles = new ArrayList<File>();
    private File extractedTempDir;

    @Override
    public void close() {
        block3: {
            if (this.extractedTempDir != null) {
                try {
                    Files.walk(this.extractedTempDir.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    this.extractedTempDir.delete();
                }
                catch (Throwable t) {
                    System.err.println("java-source-utils: error deleting temp directory `" + this.extractedTempDir.getAbsolutePath() + "`: " + t.getMessage());
                    if (!verboseOutput) break block3;
                    t.printStackTrace(System.err);
                }
            }
        }
        this.extractedTempDir = null;
    }

    public ParserConfiguration createConfiguration() throws IOException {
        ParserConfiguration config = new ParserConfiguration().setAttributeComments(true).setDoNotAssignCommentsPrecedingEmptyLines(false).setIgnoreAnnotationsWhenAttributingComments(true);
        TypeSolver typeSolver = this.createTypeSolver(config);
        config.setSymbolResolver(new JavaSymbolSolver(typeSolver));
        return config;
    }

    private final TypeSolver createTypeSolver(ParserConfiguration config) throws IOException {
        CombinedTypeSolver typeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        for (File file : this.aarFiles) {
            typeSolver.add(new AarTypeSolver(file));
        }
        for (File file : this.jarFiles) {
            typeSolver.add(new JarTypeSolver(file));
        }
        if (!this.haveBootClassPath) {
            typeSolver.add(new ReflectionTypeSolver());
        }
        for (File srcDir : this.sourceDirectoryFiles) {
            typeSolver.add(new JavaParserTypeSolver(srcDir, config));
        }
        return typeSolver;
    }

    private final JavaSourceUtilsOptions parse(Iterator<String> args) throws IOException {
        if (args == null || !args.hasNext()) {
            return this;
        }
        block33: while (args.hasNext()) {
            String arg;
            switch (arg = args.next()) {
                case "-bootclasspath": {
                    String bootClassPath = JavaSourceUtilsOptions.getNextOptionValue(args, arg);
                    ArrayList<File> files = new ArrayList<File>();
                    for (String cp : bootClassPath.split(File.pathSeparator)) {
                        File file = new File(cp);
                        if (!file.exists()) {
                            System.err.println("java-source-utils: warning: invalid file path for option `-bootclasspath`: " + cp);
                            continue;
                        }
                        files.add(file);
                    }
                    for (int j = files.size(); j > 0; --j) {
                        this.jarFiles.add(0, (File)files.get(j - 1));
                    }
                    this.haveBootClassPath = true;
                    break;
                }
                case "-a": 
                case "--aar": {
                    File file = JavaSourceUtilsOptions.getNextOptionFile(args, arg);
                    if (file == null) break;
                    this.aarFiles.add(file);
                    break;
                }
                case "--doc-copyright": {
                    File file = JavaSourceUtilsOptions.getNextOptionFile(args, arg);
                    if (file == null) break;
                    this.docCopyrightFile = file;
                    break;
                }
                case "--doc-url-prefix": {
                    String prefix;
                    this.docUrlPrefix = prefix = JavaSourceUtilsOptions.getNextOptionValue(args, arg);
                    break;
                }
                case "--doc-url-style": {
                    String style;
                    this.docUrlStyle = style = JavaSourceUtilsOptions.getNextOptionValue(args, arg);
                    break;
                }
                case "-j": 
                case "--jar": {
                    File file = JavaSourceUtilsOptions.getNextOptionFile(args, arg);
                    if (file == null) break;
                    this.jarFiles.add(file);
                    break;
                }
                case "-s": 
                case "--source": {
                    File dir = JavaSourceUtilsOptions.getNextOptionFile(args, arg);
                    if (dir == null) break;
                    this.sourceDirectoryFiles.add(dir);
                    break;
                }
                case "-D": 
                case "--output-javadoc": {
                    this.outputJavadocXml = JavaSourceUtilsOptions.getNextOptionValue(args, arg);
                    break;
                }
                case "-P": 
                case "--output-params": {
                    this.outputParamsTxt = JavaSourceUtilsOptions.getNextOptionValue(args, arg);
                    break;
                }
                case "-v": {
                    verboseOutput = true;
                    break;
                }
                case "-h": 
                case "-?": 
                case "--help": {
                    return null;
                }
                default: {
                    String responseFileName;
                    File responseFile;
                    if (arg.startsWith("@") && (responseFile = new File(responseFileName = arg.substring(1))).exists()) {
                        Iterator<String> lines = Files.readAllLines(responseFile.toPath()).stream().filter(line -> line.length() > 0 && !line.startsWith("#")).iterator();
                        JavaSourceUtilsOptions r = this.parse(lines);
                        if (r != null) continue block33;
                        return null;
                    }
                    File file = new File(arg);
                    if (!file.exists()) {
                        System.err.println("java-source-utils: warning: invalid file path for option `FILES`: " + arg);
                        break;
                    }
                    if (file.isDirectory()) {
                        this.sourceDirectoryFiles.add(file);
                        Files.walk(file.toPath(), new FileVisitOption[0]).filter(f -> Files.isRegularFile(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".java")).map(Path::toFile).forEach(f -> this.inputFiles.add((File)f));
                        break;
                    }
                    if (file.getName().endsWith(".java")) {
                        this.inputFiles.add(file);
                        break;
                    }
                    if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) {
                        System.err.println("java-source-utils: warning: ignoring input file `" + file.getAbsolutePath() + "`.");
                        break;
                    }
                    if (this.extractedTempDir == null) {
                        this.extractedTempDir = Files.createTempDirectory("ji-jst", new FileAttribute[0]).toFile();
                    }
                    File toDir = new File(this.extractedTempDir, file.getName());
                    this.sourceDirectoryFiles.add(toDir);
                    JavaSourceUtilsOptions.extractTo(file, toDir, this.inputFiles);
                    break;
                }
            }
        }
        return this;
    }

    public static JavaSourceUtilsOptions parse(String[] args) throws IOException {
        JavaSourceUtilsOptions options = new JavaSourceUtilsOptions();
        Iterator<String> a = Arrays.stream(args).iterator();
        return options.parse(a);
    }

    private static void extractTo(File zipFilePath, File toDir, Collection<File> inputFiles) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".java")) continue;
                File target = new File(toDir, entry.getName());
                if (verboseOutput) {
                    System.out.println("# creating file: " + target.getAbsolutePath());
                }
                target.getParentFile().mkdirs();
                InputStream zipContents = zipFile.getInputStream(entry);
                Files.copy(zipContents, target.toPath(), new CopyOption[0]);
                zipContents.close();
                inputFiles.add(target);
            }
        }
    }

    static String getNextOptionValue(Iterator<String> args, String option) {
        if (!args.hasNext()) {
            throw new IllegalArgumentException("Expected required value for option `" + option + "`.");
        }
        return args.next();
    }

    static File getNextOptionFile(Iterator<String> args, String option) {
        if (!args.hasNext()) {
            throw new IllegalArgumentException("Expected required value for option `" + option + "`.");
        }
        String fileName = args.next();
        File file = new File(fileName);
        if (!file.exists()) {
            System.err.println("java-source-utils: warning: invalid file path for option `" + option + "`: " + fileName);
            return null;
        }
        return file;
    }
}

