/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.android;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.microsoft.android.JavaSourceUtilsOptions;
import com.microsoft.android.JavadocXmlGenerator;
import com.microsoft.android.JniPackagesInfoFactory;
import com.microsoft.android.ParameterNameGenerator;
import com.microsoft.android.ast.JniPackagesInfo;
import com.microsoft.android.util.Parameter;
import java.io.IOException;

public class App {
    public static final String APP_NAME = "java-source-utils";

    public static void main(String[] args) throws Throwable {
        JavaSourceUtilsOptions options;
        try {
            options = JavaSourceUtilsOptions.parse(args);
            if (options == null) {
                System.out.println("java-source-utils " + JavaSourceUtilsOptions.HELP_STRING);
                return;
            }
        }
        catch (Throwable t) {
            System.err.println("java-source-utils: error: " + t.getMessage());
            if (JavaSourceUtilsOptions.verboseOutput) {
                t.printStackTrace(System.err);
            }
            System.err.println("Usage: java-source-utils " + JavaSourceUtilsOptions.HELP_STRING);
            System.exit(1);
            return;
        }
        try {
            JavaParser parser = App.createParser(options);
            JniPackagesInfoFactory packagesFactory = new JniPackagesInfoFactory(parser);
            JniPackagesInfo packages = packagesFactory.parse(options.inputFiles);
            options.outputParamsTxt = Parameter.normalize(options.outputParamsTxt, "");
            if (options.outputParamsTxt.length() > 0) {
                App.generateParamsTxt(options.outputParamsTxt, packages);
            }
            App.generateXml(options, packages);
            options.close();
        }
        catch (Throwable t) {
            options.close();
            System.err.println("java-source-utils: internal error: " + t.getMessage());
            if (JavaSourceUtilsOptions.verboseOutput) {
                t.printStackTrace(System.err);
            }
            System.exit(2);
            return;
        }
    }

    static JavaParser createParser(JavaSourceUtilsOptions options) throws IOException {
        ParserConfiguration config = options.createConfiguration();
        JavaParser parser = new JavaParser(config);
        return parser;
    }

    static void generateParamsTxt(String filename, JniPackagesInfo packages) throws Throwable {
        try (ParameterNameGenerator paramsTxtGen = new ParameterNameGenerator(filename);){
            paramsTxtGen.writePackages(packages);
        }
    }

    static void generateXml(JavaSourceUtilsOptions options, JniPackagesInfo packages) throws Throwable {
        try (JavadocXmlGenerator javadocXmlGen = new JavadocXmlGenerator(options.outputJavadocXml);){
            javadocXmlGen.writeCopyrightInfo(options.docCopyrightFile, options.docUrlPrefix, options.docUrlStyle);
            javadocXmlGen.writePackages(packages);
        }
    }
}

