/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.typesystem;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeTransformer;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.parametrization.ResolvedTypeParametersMap;
import com.github.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeVariableDeclaration;
import com.github.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.NullType;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferenceTypeImpl
extends ResolvedReferenceType {
    private TypeSolver typeSolver;

    public static ResolvedReferenceType undeterminedParameters(ResolvedReferenceTypeDeclaration typeDeclaration, TypeSolver typeSolver) {
        return new ReferenceTypeImpl(typeDeclaration, typeDeclaration.getTypeParameters().stream().map(ResolvedTypeVariable::new).collect(Collectors.toList()), typeSolver);
    }

    @Override
    protected ResolvedReferenceType create(ResolvedReferenceTypeDeclaration typeDeclaration, List<ResolvedType> typeParametersCorrected) {
        return new ReferenceTypeImpl(typeDeclaration, typeParametersCorrected, this.typeSolver);
    }

    @Override
    protected ResolvedReferenceType create(ResolvedReferenceTypeDeclaration typeDeclaration) {
        return new ReferenceTypeImpl(typeDeclaration, this.typeSolver);
    }

    public ReferenceTypeImpl(ResolvedReferenceTypeDeclaration typeDeclaration, TypeSolver typeSolver) {
        super(typeDeclaration);
        this.typeSolver = typeSolver;
    }

    public ReferenceTypeImpl(ResolvedReferenceTypeDeclaration typeDeclaration, List<ResolvedType> typeArguments, TypeSolver typeSolver) {
        super(typeDeclaration, typeArguments);
        this.typeSolver = typeSolver;
    }

    @Override
    public ResolvedTypeParameterDeclaration asTypeParameter() {
        if (this.typeDeclaration instanceof JavaParserTypeVariableDeclaration) {
            JavaParserTypeVariableDeclaration javaParserTypeVariableDeclaration = (JavaParserTypeVariableDeclaration)this.typeDeclaration;
            return javaParserTypeVariableDeclaration.asTypeParameter();
        }
        throw new UnsupportedOperationException(this.typeDeclaration.getClass().getCanonicalName());
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        if (other instanceof NullType) {
            return !this.isPrimitive();
        }
        if (!other.isVoid() && this.isJavaLangObject()) {
            return true;
        }
        if (other.isPrimitive()) {
            if (this.isJavaLangObject()) {
                return true;
            }
            if (this.isCorrespondingBoxingType(other.describe())) {
                return true;
            }
            SymbolReference<ResolvedReferenceTypeDeclaration> type = this.typeSolver.tryToSolveType(other.asPrimitive().getBoxTypeQName());
            return type.getCorrespondingDeclaration().canBeAssignedTo(this.typeDeclaration);
        }
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return FunctionalInterfaceLogic.isFunctionalInterfaceType(this);
        }
        if (other instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl otherRef = (ReferenceTypeImpl)other;
            if (this.compareConsideringTypeParameters(otherRef)) {
                return true;
            }
            for (ResolvedReferenceType otherAncestor : otherRef.getAllAncestors()) {
                if (!this.compareConsideringTypeParameters(otherAncestor)) continue;
                return true;
            }
            return false;
        }
        if (other.isTypeVariable()) {
            for (ResolvedTypeParameterDeclaration.Bound bound : other.asTypeVariable().asTypeParameter().getBounds()) {
                if (!bound.isExtends() || !this.isAssignableBy(bound.getType())) continue;
                return true;
            }
            return false;
        }
        if (other.isConstraint()) {
            return this.isAssignableBy(other.asConstraintType().getBound());
        }
        if (other.isWildcard()) {
            if (this.isJavaLangObject()) {
                return true;
            }
            if (other.asWildcard().isExtends()) {
                return this.isAssignableBy(other.asWildcard().getBoundedType());
            }
            return false;
        }
        if (other.isUnionType()) {
            return other.asUnionType().getCommonAncestor().map(ancestor -> this.isAssignableBy((ResolvedType)ancestor)).orElse(false);
        }
        return false;
    }

    @Override
    public Set<MethodUsage> getDeclaredMethods() {
        HashSet<MethodUsage> methods = new HashSet<MethodUsage>();
        this.getTypeDeclaration().ifPresent(referenceTypeDeclaration -> {
            for (ResolvedMethodDeclaration methodDeclaration : referenceTypeDeclaration.getDeclaredMethods()) {
                MethodUsage methodUsage = new MethodUsage(methodDeclaration);
                methods.add(methodUsage);
            }
        });
        return methods;
    }

    @Override
    public ResolvedType toRawType() {
        if (this.isRawType()) {
            return this;
        }
        return new ReferenceTypeImpl(this.typeDeclaration, this.typeSolver);
    }

    @Override
    public boolean mention(List<ResolvedTypeParameterDeclaration> typeParameters) {
        return this.typeParametersValues().stream().anyMatch(tp -> tp.mention(typeParameters));
    }

    @Override
    public ResolvedType transformTypeParameters(ResolvedTypeTransformer transformer) {
        ResolvedReferenceType result = this;
        int i = 0;
        for (ResolvedType tp : this.typeParametersValues()) {
            ResolvedType transformedTp = transformer.transform(tp);
            if (transformedTp != tp) {
                List<ResolvedType> typeParametersCorrected = result.asReferenceType().typeParametersValues();
                typeParametersCorrected.set(i, transformedTp);
                result = this.create(this.typeDeclaration, typeParametersCorrected);
            }
            ++i;
        }
        return result;
    }

    @Override
    public List<ResolvedReferenceType> getAllAncestors() {
        List<ResolvedReferenceType> ancestors = this.typeDeclaration.getAllAncestors();
        ancestors = ancestors.stream().map(a -> this.typeParametersMap().replaceAll((ResolvedType)a).asReferenceType()).collect(Collectors.toList());
        ancestors.removeIf(ResolvedReferenceType::isJavaLangObject);
        ResolvedReferenceTypeDeclaration objectType = this.typeSolver.getSolvedJavaLangObject();
        ancestors.add(this.create(objectType));
        return ancestors;
    }

    @Override
    public List<ResolvedReferenceType> getDirectAncestors() {
        List<ResolvedReferenceType> ancestors = this.typeDeclaration.getAncestors();
        ancestors = ancestors.stream().map(a -> this.typeParametersMap().replaceAll((ResolvedType)a).asReferenceType()).collect(Collectors.toList());
        ancestors.removeIf(ResolvedReferenceType::isJavaLangObject);
        if (this.getTypeDeclaration().isPresent()) {
            ResolvedReferenceTypeDeclaration thisTypeDeclaration = this.getTypeDeclaration().get();
            if (thisTypeDeclaration.isClass()) {
                Optional<ResolvedReferenceType> optionalSuperClass = thisTypeDeclaration.asClass().getSuperClass();
                boolean superClassIsJavaLangObject = optionalSuperClass.isPresent() && optionalSuperClass.get().isJavaLangObject();
                boolean thisIsJavaLangObject = thisTypeDeclaration.asClass().isJavaLangObject();
                if (superClassIsJavaLangObject && !thisIsJavaLangObject) {
                    ancestors.add(this.create(this.typeSolver.getSolvedJavaLangObject()));
                }
            } else {
                ancestors.add(this.create(this.typeSolver.getSolvedJavaLangObject()));
            }
        }
        return ancestors;
    }

    @Override
    public ResolvedReferenceType deriveTypeParameters(ResolvedTypeParametersMap typeParametersMap) {
        return this.create(this.typeDeclaration, typeParametersMap);
    }

    @Override
    public Set<ResolvedFieldDeclaration> getDeclaredFields() {
        HashSet<ResolvedFieldDeclaration> allFields = new HashSet<ResolvedFieldDeclaration>();
        if (this.getTypeDeclaration().isPresent()) {
            allFields = new HashSet<ResolvedFieldDeclaration>(this.getTypeDeclaration().get().getDeclaredFields());
        }
        return allFields;
    }
}

