/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.declarations.AssociableToAST;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnnotationDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CompilationUnitContext
extends AbstractJavaParserContext<CompilationUnit> {
    private static boolean isQualifiedName(String name) {
        return name.contains(".");
    }

    public CompilationUnitContext(CompilationUnit wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        String itName = name;
        while (itName.contains(".")) {
            String typeName = this.getType(itName);
            String memberName = this.getMember(itName);
            SymbolReference<ResolvedTypeDeclaration> type = this.solveType(typeName);
            if (type.isSolved()) {
                return new SymbolSolver(this.typeSolver).solveSymbolInType(type.getCorrespondingDeclaration(), memberName);
            }
            itName = typeName;
        }
        for (ImportDeclaration importDecl : ((CompilationUnit)this.wrappedNode).getImports()) {
            if (!importDecl.isStatic()) continue;
            if (importDecl.isAsterisk()) {
                SymbolReference<? extends ResolvedValueDeclaration> ref;
                String qName = importDecl.getNameAsString();
                ResolvedReferenceTypeDeclaration importedType = this.typeSolver.solveType(qName);
                if (this.isAncestorOf(importedType) || !(ref = new SymbolSolver(this.typeSolver).solveSymbolInType(importedType, name)).isSolved()) continue;
                return ref;
            }
            String whole = importDecl.getNameAsString();
            String memberName = this.getMember(whole);
            String typeName = this.getType(whole);
            if (!memberName.equals(name)) continue;
            ResolvedReferenceTypeDeclaration importedType = this.typeSolver.solveType(typeName);
            return new SymbolSolver(this.typeSolver).solveSymbolInType(importedType, memberName);
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    @Override
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        Object qName;
        SymbolReference<ResolvedReferenceTypeDeclaration> ref;
        String qName2;
        if (((CompilationUnit)this.wrappedNode).getTypes() != null) {
            for (TypeDeclaration<?> type : ((CompilationUnit)this.wrappedNode).getTypes()) {
                if (!type.getName().getId().equals(name) && !type.getFullyQualifiedName().map(qualified -> qualified.equals(name)).orElse(false).booleanValue()) continue;
                if (type instanceof ClassOrInterfaceDeclaration) {
                    return SymbolReference.solved(JavaParserFacade.get(this.typeSolver).getTypeDeclaration((ClassOrInterfaceDeclaration)type));
                }
                if (type instanceof AnnotationDeclaration) {
                    return SymbolReference.solved(new JavaParserAnnotationDeclaration((AnnotationDeclaration)type, this.typeSolver));
                }
                if (type instanceof EnumDeclaration) {
                    return SymbolReference.solved(new JavaParserEnumDeclaration((EnumDeclaration)type, this.typeSolver));
                }
                throw new UnsupportedOperationException(type.getClass().getCanonicalName());
            }
            if (name.indexOf(46) > -1) {
                SymbolReference<ResolvedTypeDeclaration> ref2 = null;
                SymbolReference<ResolvedTypeDeclaration> outerMostRef = this.solveType(name.substring(0, name.indexOf(".")));
                if (outerMostRef != null && outerMostRef.isSolved() && outerMostRef.getCorrespondingDeclaration() instanceof JavaParserClassDeclaration) {
                    ref2 = ((JavaParserClassDeclaration)outerMostRef.getCorrespondingDeclaration()).solveType(name.substring(name.indexOf(".") + 1));
                } else if (outerMostRef != null && outerMostRef.isSolved() && outerMostRef.getCorrespondingDeclaration() instanceof JavaParserInterfaceDeclaration) {
                    ref2 = ((JavaParserInterfaceDeclaration)outerMostRef.getCorrespondingDeclaration()).solveType(name.substring(name.indexOf(".") + 1));
                }
                if (ref2 != null && ref2.isSolved()) {
                    return ref2;
                }
            }
        }
        int dotPos = name.indexOf(46);
        String prefix = null;
        if (dotPos > -1) {
            prefix = name.substring(0, dotPos);
        }
        for (ImportDeclaration importDecl : ((CompilationUnit)this.wrappedNode).getImports()) {
            SymbolReference<ResolvedReferenceTypeDeclaration> ref3;
            boolean found;
            if (importDecl.isAsterisk()) continue;
            qName2 = importDecl.getNameAsString();
            boolean defaultPackage = !importDecl.getName().getQualifier().isPresent();
            boolean bl = found = !defaultPackage && importDecl.getName().getIdentifier().equals(name);
            if (!found && prefix != null && (found = qName2.endsWith("." + prefix))) {
                qName2 = qName2 + name.substring(dotPos);
            }
            if (!found || (ref3 = this.typeSolver.tryToSolveType(qName2)) == null || !ref3.isSolved()) continue;
            return SymbolReference.adapt(ref3, ResolvedTypeDeclaration.class);
        }
        if (((CompilationUnit)this.wrappedNode).getPackageDeclaration().isPresent() ? (ref = this.typeSolver.tryToSolveType((String)(qName = ((CompilationUnit)this.wrappedNode).getPackageDeclaration().get().getName().toString() + "." + name))) != null && ref.isSolved() : (ref = this.typeSolver.tryToSolveType((String)(qName = name))) != null && ref.isSolved()) {
            return SymbolReference.adapt(ref, ResolvedTypeDeclaration.class);
        }
        for (ImportDeclaration importDecl : ((CompilationUnit)this.wrappedNode).getImports()) {
            SymbolReference<ResolvedReferenceTypeDeclaration> ref4;
            if (!importDecl.isAsterisk() || (ref4 = this.typeSolver.tryToSolveType(qName2 = importDecl.getNameAsString() + "." + name)) == null || !ref4.isSolved()) continue;
            return SymbolReference.adapt(ref4, ResolvedTypeDeclaration.class);
        }
        SymbolReference<ResolvedReferenceTypeDeclaration> ref5 = this.typeSolver.tryToSolveType("java.lang." + name);
        if (ref5 != null && ref5.isSolved()) {
            return SymbolReference.adapt(ref5, ResolvedTypeDeclaration.class);
        }
        if (CompilationUnitContext.isQualifiedName(name)) {
            return SymbolReference.adapt(this.typeSolver.tryToSolveType(name), ResolvedTypeDeclaration.class);
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }

    private String qName(ClassOrInterfaceType type) {
        if (type.getScope().isPresent()) {
            return this.qName(type.getScope().get()) + "." + type.getName().getId();
        }
        return type.getName().getId();
    }

    private String qName(Name name) {
        if (name.getQualifier().isPresent()) {
            return this.qName(name.getQualifier().get()) + "." + name.getId();
        }
        return name.getId();
    }

    private String toSimpleName(String qName) {
        String[] parts = qName.split("\\.");
        return parts[parts.length - 1];
    }

    private String packageName(String qName) {
        int lastDot = qName.lastIndexOf(46);
        if (lastDot == -1) {
            throw new UnsupportedOperationException();
        }
        return qName.substring(0, lastDot);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        for (ImportDeclaration importDecl : ((CompilationUnit)this.wrappedNode).getImports()) {
            if (!importDecl.isStatic()) continue;
            if (importDecl.isAsterisk()) {
                SymbolReference<ResolvedMethodDeclaration> method;
                String importString = importDecl.getNameAsString();
                if (((CompilationUnit)this.wrappedNode).getPackageDeclaration().isPresent() && ((CompilationUnit)this.wrappedNode).getPackageDeclaration().get().getName().getIdentifier().equals(this.packageName(importString)) && ((CompilationUnit)this.wrappedNode).getTypes().stream().anyMatch(it -> it.getName().getIdentifier().equals(this.toSimpleName(importString)))) {
                    return SymbolReference.unsolved(ResolvedMethodDeclaration.class);
                }
                ResolvedReferenceTypeDeclaration ref = this.typeSolver.solveType(importString);
                if (this.isAncestorOf(ref) || !(method = MethodResolutionLogic.solveMethodInType(ref, name, argumentsTypes, true)).isSolved()) continue;
                return method;
            }
            String qName = importDecl.getNameAsString();
            if (!qName.equals(name) && !qName.endsWith("." + name)) continue;
            String typeName = this.getType(qName);
            ResolvedReferenceTypeDeclaration ref = this.typeSolver.solveType(typeName);
            SymbolReference<ResolvedMethodDeclaration> method = MethodResolutionLogic.solveMethodInType(ref, name, argumentsTypes, true);
            if (method.isSolved()) {
                return method;
            }
            return SymbolReference.unsolved(ResolvedMethodDeclaration.class);
        }
        return SymbolReference.unsolved(ResolvedMethodDeclaration.class);
    }

    @Override
    public List<ResolvedFieldDeclaration> fieldsExposedToChild(Node child) {
        LinkedList<ResolvedFieldDeclaration> res = new LinkedList<ResolvedFieldDeclaration>();
        for (ImportDeclaration importDeclaration : ((CompilationUnit)this.wrappedNode).getImports()) {
            if (!importDeclaration.isStatic()) continue;
            Name typeNameAsNode = importDeclaration.isAsterisk() ? importDeclaration.getName() : importDeclaration.getName().getQualifier().get();
            String typeName = typeNameAsNode.asString();
            ResolvedReferenceTypeDeclaration typeDeclaration = this.typeSolver.solveType(typeName);
            res.addAll(typeDeclaration.getAllFields().stream().filter(f -> f.isStatic()).filter(f -> importDeclaration.isAsterisk() || importDeclaration.getName().getIdentifier().equals(f.getName())).collect(Collectors.toList()));
        }
        return res;
    }

    private String getType(String qName) {
        int index = qName.lastIndexOf(46);
        if (index == -1) {
            throw new UnsupportedOperationException();
        }
        String typeName = qName.substring(0, index);
        return typeName;
    }

    private String getMember(String qName) {
        int index = qName.lastIndexOf(46);
        if (index == -1) {
            throw new UnsupportedOperationException();
        }
        String memberName = qName.substring(index + 1);
        return memberName;
    }

    private boolean isAncestorOf(ResolvedTypeDeclaration descendant) {
        if (descendant instanceof AssociableToAST) {
            Optional astOpt = ((AssociableToAST)((Object)descendant)).toAst();
            if (astOpt.isPresent()) {
                return ((CompilationUnit)this.wrappedNode).isAncestorOf((Node)astOpt.get());
            }
            return false;
        }
        if (descendant instanceof JavaParserEnumDeclaration) {
            return ((CompilationUnit)this.wrappedNode).isAncestorOf(((JavaParserEnumDeclaration)descendant).getWrappedNode());
        }
        throw new UnsupportedOperationException();
    }
}

