/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.visitor.AllFunctionsVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.util.kotlin.asserter.AssertUtil;
import proguard.util.kotlin.asserter.constraint.AbstractKotlinMetadataConstraint;

public class FunctionIntegrity
extends AbstractKotlinMetadataConstraint
implements KotlinFunctionVisitor {
    private boolean hasDefaults = false;

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        kotlinMetadata.accept(clazz, new AllFunctionsVisitor(this));
    }

    @Override
    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        AssertUtil util = new AssertUtil("Function " + kotlinFunctionMetadata.name, this.reporter);
        util.reportIfNull("jvmSignature", kotlinFunctionMetadata.jvmSignature);
        util.reportIfNullReference("referencedMethod", kotlinFunctionMetadata.referencedMethod);
        util.reportIfNullReference("referencedMethodClass", kotlinFunctionMetadata.referencedMethodClass);
        util.reportIfMethodDangling("referenced method", kotlinFunctionMetadata.referencedMethodClass, kotlinFunctionMetadata.referencedMethod);
        util.reportIfMethodDangling("referenced default method", kotlinFunctionMetadata.referencedDefaultMethodClass, kotlinFunctionMetadata.referencedDefaultMethod);
        util.reportIfMethodDangling("referenced default implementation method", kotlinFunctionMetadata.referencedDefaultImplementationMethodClass, kotlinFunctionMetadata.referencedDefaultImplementationMethod);
        this.hasDefaults = false;
        kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, (_clazz, vp) -> this.hasDefaults |= vp.flags.hasDefaultValue);
        if (this.hasDefaults) {
            boolean hasDefaultMethod;
            boolean bl = hasDefaultMethod = kotlinFunctionMetadata.referencedDefaultMethod != null && kotlinFunctionMetadata.referencedDefaultMethod.getName(kotlinFunctionMetadata.referencedDefaultMethodClass).equals(kotlinFunctionMetadata.referencedMethod.getName(kotlinFunctionMetadata.referencedMethodClass) + "$default");
            if (!hasDefaultMethod) {
                this.reporter.report(kotlinFunctionMetadata.name + "$default method not found [" + kotlinFunctionMetadata.jvmSignature + "]");
            }
        }
        if (!kotlinFunctionMetadata.flags.modality.isAbstract && kotlinMetadata.k == 1) {
            KotlinClassKindMetadata kotlinClassKindMetadata = (KotlinClassKindMetadata)kotlinMetadata;
            if (kotlinClassKindMetadata.flags.isInterface) {
                util.reportIfNullReference("default implementation method", kotlinFunctionMetadata.referencedDefaultImplementationMethod);
                util.reportIfNullReference("default implementation method class", kotlinFunctionMetadata.referencedDefaultImplementationMethodClass);
            }
        }
    }
}

