/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringFunction;
import proguard.util.StringMatcher;

public class FilteredStringFunction
implements StringFunction {
    private final StringMatcher nameFilter;
    private final StringFunction acceptedFunction;
    private final StringFunction rejectedFunction;

    public FilteredStringFunction(String nameFilter, StringFunction acceptedFunction, StringFunction rejectedFunction) {
        this.nameFilter = new ListParser(new NameParser()).parse(nameFilter);
        this.acceptedFunction = acceptedFunction;
        this.rejectedFunction = rejectedFunction;
    }

    @Override
    public String transform(String fileName) {
        if (this.nameFilter.matches(fileName)) {
            return this.acceptedFunction.transform(fileName);
        }
        return this.rejectedFunction.transform(fileName);
    }
}

