/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.optimize.gson.GsonContext;
import proguard.optimize.gson.OptimizedJsonFieldVisitor;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileNameFilter;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.shrink.AnnotationUsageMarker;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.KotlinModuleUsageMarker;
import proguard.shrink.LocalVariableTypeUsageMarker;
import proguard.shrink.NestUsageMarker;
import proguard.shrink.SimpleUsageMarker;
import proguard.shrink.UsedClassFilter;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;

public class UsageMarker {
    private final Configuration configuration;

    public UsageMarker(Configuration configuration) {
        this.configuration = configuration;
    }

    public void mark(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool, SimpleUsageMarker simpleUsageMarker) {
        this.mark(programClassPool, libraryClassPool, resourceFilePool, simpleUsageMarker, new ClassUsageMarker(simpleUsageMarker));
    }

    public void mark(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool, SimpleUsageMarker simpleUsageMarker, ClassUsageMarker classUsageMarker) {
        libraryClassPool.classesAccept(classUsageMarker);
        programClassPool.classesAccept(new MultiClassVisitor(new ClassProcessingFlagFilter(0x100000, 0, classUsageMarker), new AllMemberVisitor(new MemberProcessingFlagFilter(0x100000, 0, classUsageMarker))));
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(classUsageMarker));
        }
        programClassPool.classesAccept(new UsedClassFilter(simpleUsageMarker, new AllAttributeVisitor(true, new MultiAttributeVisitor(new InnerUsageMarker(classUsageMarker), new NestUsageMarker(classUsageMarker), new AnnotationUsageMarker(classUsageMarker), new LocalVariableTypeUsageMarker(classUsageMarker)))));
        programClassPool.classesAccept(new InterfaceUsageMarker(classUsageMarker));
        if (this.configuration.keepKotlinMetadata) {
            resourceFilePool.resourceFilesAccept(new ResourceFileNameFilter("META-INF/*.kotlin_module", (ResourceFileVisitor)new ResourceFileProcessingFlagFilter(0, 8192, new KotlinModuleUsageMarker(simpleUsageMarker))));
        }
        ConstantMatcher filter = this.configuration.optimizations != null ? new ListParser(new NameParser()).parse(this.configuration.optimizations) : new ConstantMatcher(true);
        boolean libraryGson = filter.matches("library/gson");
        if (this.configuration.optimize && libraryGson) {
            GsonContext gsonContext = new GsonContext();
            gsonContext.setupFor(programClassPool, libraryClassPool, null);
            if (gsonContext.gsonRuntimeSettings.excludeFieldsWithModifiers) {
                gsonContext.gsonDomainClassPool.classesAccept(new MultiClassVisitor(classUsageMarker, new AllFieldVisitor(classUsageMarker)));
            } else {
                gsonContext.gsonDomainClassPool.classesAccept(new OptimizedJsonFieldVisitor(classUsageMarker, classUsageMarker));
            }
        }
    }
}

