/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExtendedLineNumberInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ExceptionInfoAdder;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.DynamicInvocationMarker;
import proguard.optimize.info.FinalFieldAssignmentMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.NonEmptyStackReturnMarker;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.SideEffectClassChecker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.info.SynchronizedBlockMethodMarker;

public class MethodInliner
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor,
ExceptionInfoVisitor,
LineNumberInfoVisitor {
    private static final int MAXIMUM_INLINED_CODE_LENGTH_JVM = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "8"));
    private static final int MAXIMUM_INLINED_CODE_LENGTH_android = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "32"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JSE = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "7000"));
    private static final int MAXIMUM_RESULTING_CODE_LENGTH_JME = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "2000"));
    static final int METHOD_DUMMY_START_LINE_NUMBER = 0;
    static final int INLINED_METHOD_END_LINE_NUMBER = -1;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DETAILS = false;
    private final boolean microEdition;
    private final boolean android;
    private final boolean allowAccessModification;
    private final boolean inlineSingleInvocations;
    private final InstructionVisitor extraInlinedInvocationVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private final MemberVisitor accessMethodMarker = new OptimizationInfoMemberFilter(new AllAttributeVisitor(new AllInstructionVisitor(new MultiInstructionVisitor(new SuperInvocationMarker(), new AccessMethodMarker()))));
    private final AttributeVisitor methodInvocationMarker = new AllInstructionVisitor(new MethodInvocationMarker());
    private final StackSizeComputer stackSizeComputer = new StackSizeComputer();
    private ProgramClass targetClass;
    private ProgramMethod targetMethod;
    private ConstantAdder constantAdder;
    private ExceptionInfoAdder exceptionInfoAdder;
    private int estimatedResultingCodeLength;
    private boolean inlining;
    private Stack inliningMethods = new Stack();
    private boolean emptyInvokingStack;
    private boolean coveredByCatchAllHandler;
    private int exceptionInfoCount;
    private int uninitializedObjectCount;
    private int variableOffset;
    private boolean inlined;
    private boolean inlinedAny;
    private boolean copiedLineNumbers;
    private String source;
    private int minimumLineNumberIndex;

    public MethodInliner(boolean microEdition, boolean android, boolean allowAccessModification, boolean inlineSingleInvocations) {
        this(microEdition, android, allowAccessModification, inlineSingleInvocations, null);
    }

    public MethodInliner(boolean microEdition, boolean android, boolean allowAccessModification, boolean inlineSingleInvocations, InstructionVisitor extraInlinedInvocationVisitor) {
        this.microEdition = microEdition;
        this.android = android;
        this.allowAccessModification = allowAccessModification;
        this.inlineSingleInvocations = inlineSingleInvocations;
        this.extraInlinedInvocationVisitor = extraInlinedInvocationVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while inlining method:");
            System.err.println("  Target class   = [" + this.targetClass.getName() + "]");
            System.err.println("  Target method  = [" + this.targetMethod.getName(this.targetClass) + this.targetMethod.getDescriptor(this.targetClass) + "]");
            if (this.inlining) {
                System.err.println("  Inlined class  = [" + clazz.getName() + "]");
                System.err.println("  Inlined method = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            }
            System.err.println("  Exception      = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            ex.printStackTrace();
            System.err.println("Not inlining this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.inlining) {
            this.targetClass = (ProgramClass)clazz;
            this.targetMethod = (ProgramMethod)method;
            this.constantAdder = new ConstantAdder(this.targetClass);
            this.exceptionInfoAdder = new ExceptionInfoAdder(this.targetClass, this.codeAttributeComposer);
            this.estimatedResultingCodeLength = codeAttribute.u4codeLength;
            this.inliningMethods.clear();
            this.uninitializedObjectCount = method.getName(clazz).equals("<init>") ? 1 : 0;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.stackSizeComputer.visitCodeAttribute(clazz, method, codeAttribute);
            this.copyCode(clazz, method, codeAttribute);
            if (this.inlinedAny) {
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
                method.accept(clazz, this.accessMethodMarker);
            }
            this.targetClass = null;
            this.targetMethod = null;
            this.constantAdder = null;
        } else if ((this.inlineSingleInvocations ? MethodInvocationMarker.getInvocationCount(method) == 1 : codeAttribute.u4codeLength <= (this.android ? MAXIMUM_INLINED_CODE_LENGTH_android : MAXIMUM_INLINED_CODE_LENGTH_JVM)) && this.estimatedResultingCodeLength + codeAttribute.u4codeLength < (this.microEdition ? MAXIMUM_RESULTING_CODE_LENGTH_JME : MAXIMUM_RESULTING_CODE_LENGTH_JSE)) {
            this.estimatedResultingCodeLength += codeAttribute.u4codeLength;
            this.storeParameters(clazz, method);
            this.copyCode(clazz, method, codeAttribute);
            this.inlined = true;
            this.inlinedAny = true;
        }
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.source = this.inlining ? clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ':' + lineNumberTableAttribute.getLowestLineNumber() + ':' + lineNumberTableAttribute.getHighestLineNumber() : null;
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        this.copiedLineNumbers = true;
    }

    private void storeParameters(Clazz clazz, Method method) {
        String parameterType;
        int parameterIndex;
        String descriptor = method.getDescriptor(clazz);
        boolean isStatic = (method.getAccessFlags() & 8) != 0;
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor);
        int parameterOffset = isStatic ? 0 : 1;
        String[] parameterTypes = new String[parameterSize];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        for (parameterIndex = 0; parameterIndex < parameterSize; ++parameterIndex) {
            parameterTypes[parameterIndex] = parameterType = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize(parameterType) != 2) continue;
            ++parameterIndex;
        }
        this.codeAttributeComposer.beginCodeFragment(parameterSize + 1);
        for (parameterIndex = parameterSize - 1; parameterIndex >= 0; --parameterIndex) {
            byte opcode;
            parameterType = parameterTypes[parameterIndex];
            if (parameterType == null) continue;
            switch (parameterType.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    opcode = 54;
                    break;
                }
                case 'J': {
                    opcode = 55;
                    break;
                }
                case 'F': {
                    opcode = 56;
                    break;
                }
                case 'D': {
                    opcode = 57;
                    break;
                }
                default: {
                    opcode = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(parameterSize - parameterIndex - 1, new VariableInstruction(opcode, this.variableOffset + parameterOffset + parameterIndex));
        }
        if (!isStatic) {
            this.codeAttributeComposer.appendInstruction(parameterSize, new VariableInstruction(58, this.variableOffset));
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    private void copyCode(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        String source;
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        codeAttribute.exceptionsAccept(clazz, method, this.exceptionInfoAdder);
        this.copiedLineNumbers = false;
        this.minimumLineNumberIndex = 0;
        codeAttribute.attributesAccept(clazz, method, this);
        if (!this.copiedLineNumbers) {
            source = this.inlining ? clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ":0:0" : null;
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, new ExtendedLineNumberInfo(0, 0, source)) + 1;
        }
        if (this.inlining) {
            source = clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ":0:0";
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, new ExtendedLineNumberInfo(codeAttribute.u4codeLength, -1, source)) + 1;
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(offset, instruction);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        if (this.inlining) {
            switch (simpleInstruction.opcode) {
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    if (offset < codeAttribute.u4codeLength - 1) {
                        BranchInstruction branchInstruction = new BranchInstruction(-56, codeAttribute.u4codeLength - offset);
                        this.codeAttributeComposer.appendInstruction(offset, branchInstruction);
                    } else {
                        this.codeAttributeComposer.appendLabel(offset);
                    }
                    return;
                }
            }
        }
        this.codeAttributeComposer.appendInstruction(offset, simpleInstruction);
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (this.inlining) {
            variableInstruction.variableIndex += this.variableOffset;
        }
        this.codeAttributeComposer.appendInstruction(offset, variableInstruction);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: {
                ++this.uninitializedObjectCount;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.inlined = false;
                this.codeAttributeComposer.appendLabel(offset);
                this.emptyInvokingStack = !this.inlining && this.stackSizeComputer.isReachable(offset) && this.stackSizeComputer.getStackSizeAfter(offset) == 0;
                this.variableOffset += codeAttribute.u2maxLocals;
                this.coveredByCatchAllHandler = false;
                this.exceptionInfoCount = 0;
                codeAttribute.exceptionsAccept(clazz, method, offset, this);
                this.coveredByCatchAllHandler = this.exceptionInfoCount > 0 ? this.coveredByCatchAllHandler : true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                this.variableOffset -= codeAttribute.u2maxLocals;
                if (!this.inlined) break;
                if (this.extraInlinedInvocationVisitor != null) {
                    this.extraInlinedInvocationVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                }
                return;
            }
        }
        if (this.inlining) {
            constantInstruction.constantIndex = this.constantAdder.addConstant(clazz, constantInstruction.constantIndex);
        }
        this.codeAttributeComposer.appendInstruction(offset, constantInstruction);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        anyMethodrefConstant.referencedMethodAccept(this);
    }

    @Override
    public void visitAnyMember(Clazz Clazz2, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int accessFlags = programMethod.getAccessFlags();
        if (!(KeepMarker.isKept(programMethod) || !this.DEBUG("Access?") || (accessFlags & 0x1A) == 0 || !this.DEBUG("Synchronized?") || (accessFlags & 0x520) != 0 || !this.DEBUG("Init?") || programMethod.getName(programClass).equals("<init>") || !this.DEBUG("Self?") || programMethod.equals(this.targetMethod) && programClass.equals(this.targetClass) || !this.DEBUG("Recurse?") || this.inliningMethods.contains(programMethod) || !this.DEBUG("Version?") || this.targetClass.u4version < programClass.u4version || !this.DEBUG("Super?") || (SuperInvocationMarker.invokesSuperMethods(programMethod) || DynamicInvocationMarker.invokesDynamically(programMethod)) && !programClass.equals(this.targetClass) || !this.DEBUG("Branch?") || BackwardBranchMarker.branchesBackward(programMethod) && this.uninitializedObjectCount != 0 || !this.DEBUG("Access private?") || !this.allowAccessModification && (AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) || AccessMethodMarker.accessesPackageCode(programMethod) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName()))) || !this.DEBUG("Access private in subclass?") || AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) && this.targetClass.extendsOrImplements(programClass) || !this.DEBUG("Access protected?") || AccessMethodMarker.accessesProtectedCode(programMethod) && !programClass.equals(this.targetClass) || !this.DEBUG("Synchronization?") || SynchronizedBlockMethodMarker.hasSynchronizedBlock(programMethod) && !this.coveredByCatchAllHandler || !this.DEBUG("Final fields?") || FinalFieldAssignmentMarker.assignsFinalField(programMethod) || !this.DEBUG("Catch?") || CatchExceptionMarker.catchesExceptions(programMethod) && !this.emptyInvokingStack || !this.DEBUG("Stack?") || NonEmptyStackReturnMarker.returnsWithNonEmptyStack(programMethod) || !this.DEBUG("Side effects?") || SideEffectClassChecker.mayHaveSideEffects(this.targetClass, programClass, programMethod))) {
            boolean oldInlining = this.inlining;
            this.inlining = true;
            this.inliningMethods.push(programMethod);
            programMethod.attributesAccept(programClass, this);
            if (!KeepMarker.isKept(this.targetMethod)) {
                ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(this.targetMethod).merge(MethodOptimizationInfo.getMethodOptimizationInfo(programMethod));
            }
            programMethod.attributesAccept(programClass, this.methodInvocationMarker);
            this.inlining = oldInlining;
            this.inliningMethods.pop();
        } else if (programMethod.getName(programClass).equals("<init>")) {
            --this.uninitializedObjectCount;
        }
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        try {
            String newSource = lineNumberInfo.getSource() != null ? lineNumberInfo.getSource() : this.source;
            LineNumberInfo newLineNumberInfo = newSource != null ? new ExtendedLineNumberInfo(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber, newSource) : new LineNumberInfo(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber);
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, newLineNumberInfo) + 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean DEBUG(String string) {
        return true;
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        ++this.exceptionInfoCount;
        this.coveredByCatchAllHandler |= exceptionInfo.u2catchType == 0;
    }
}

