/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SubclassTraveler;
import proguard.optimize.peephole.ClassMerger;

public class HorizontalClassMerger
implements ClassVisitor {
    private final boolean allowAccessModification;
    private final boolean mergeInterfacesAggressively;
    private final ClassVisitor extraClassVisitor;

    public HorizontalClassMerger(boolean allowAccessModification, boolean mergeInterfacesAggressively) {
        this(allowAccessModification, mergeInterfacesAggressively, null);
    }

    public HorizontalClassMerger(boolean allowAccessModification, boolean mergeInterfacesAggressively, ClassVisitor extraClassVisitor) {
        this.allowAccessModification = allowAccessModification;
        this.mergeInterfacesAggressively = mergeInterfacesAggressively;
        this.extraClassVisitor = extraClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.superClassConstantAccept(new ReferencedClassVisitor(new SubclassTraveler(new ClassMerger(programClass, this.allowAccessModification, this.mergeInterfacesAggressively, false, this.extraClassVisitor))));
    }
}

