/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.ReferenceTracingValueFactory;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.info.ParameterEscapeMarker;
import proguard.util.ArrayUtil;

public class ReferenceEscapeChecker
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private boolean[] instanceEscaping = new boolean[8096];
    private boolean[] instanceReturned = new boolean[8096];
    private boolean[] instanceModified = new boolean[8096];
    private boolean[] externalInstance = new boolean[8096];
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private Method referencingMethod;
    private int referencingOffset;
    private int referencingPopCount;

    public ReferenceEscapeChecker() {
        this(new ReferenceTracingValueFactory(new BasicValueFactory()));
    }

    private ReferenceEscapeChecker(ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(new PartialEvaluator(referenceTracingValueFactory, new ParameterTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    public ReferenceEscapeChecker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = runPartialEvaluator;
    }

    public boolean isInstanceEscaping(int instructionOffset) {
        return this.instanceEscaping[instructionOffset];
    }

    public boolean isInstanceReturned(int instructionOffset) {
        return this.instanceReturned[instructionOffset];
    }

    public boolean isInstanceModified(int instructionOffset) {
        return this.instanceModified[instructionOffset];
    }

    public boolean isInstanceExternal(int instructionOffset) {
        return this.externalInstance[instructionOffset];
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        int codeLength = codeAttribute.u4codeLength;
        this.instanceEscaping = ArrayUtil.ensureArraySize(this.instanceEscaping, codeLength, false);
        this.instanceReturned = ArrayUtil.ensureArraySize(this.instanceReturned, codeLength, false);
        this.instanceModified = ArrayUtil.ensureArraySize(this.instanceModified, codeLength, false);
        this.externalInstance = ArrayUtil.ensureArraySize(this.externalInstance, codeLength, false);
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter(this));
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 83: {
                this.markModifiedReferenceValues(offset, simpleInstruction.stackPopCount(clazz) - 1);
                this.markEscapingReferenceValues(offset, 0);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                this.markModifiedReferenceValues(offset, simpleInstruction.stackPopCount(clazz) - 1);
                break;
            }
            case -80: {
                this.markReturnedReferenceValues(offset, 0);
                break;
            }
            case -65: {
                this.markEscapingReferenceValues(offset, 0);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: 
            case -76: {
                this.markExternalReferenceValue(offset);
                break;
            }
            case -77: {
                this.markEscapingReferenceValues(offset, 0);
                break;
            }
            case -75: {
                this.markModifiedReferenceValues(offset, constantInstruction.stackPopCount(clazz) - 1);
                this.markEscapingReferenceValues(offset, 0);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.referencingMethod = method;
                this.referencingOffset = offset;
                this.referencingPopCount = constantInstruction.stackPopCount(clazz);
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        Method referencedMethod = anyMethodrefConstant.referencedMethod;
        for (int index = 0; index < this.referencingPopCount; ++index) {
            int stackEntryIndex = this.referencingPopCount - index - 1;
            TracedStack stackBefore = this.partialEvaluator.getStackBefore(this.referencingOffset);
            Value stackEntry = stackBefore.getTop(stackEntryIndex);
            if (stackEntry.computationalType() != 5) continue;
            if (referencedMethod == null || ParameterEscapeMarker.isParameterEscaping(referencedMethod, index)) {
                this.markEscapingReferenceValues(this.referencingOffset, stackEntryIndex);
            }
            if (referencedMethod != null && !ParameterEscapeMarker.isParameterModified(referencedMethod, index)) continue;
            this.markModifiedReferenceValues(this.referencingOffset, stackEntryIndex);
        }
        String returnType = ClassUtil.internalMethodReturnType(anyMethodrefConstant.getType(clazz));
        if (referencedMethod == null || (ClassUtil.isInternalClassType(returnType) || ClassUtil.isInternalArrayType(returnType)) && ParameterEscapeMarker.returnsExternalValues(referencedMethod)) {
            this.markExternalReferenceValue(this.referencingOffset);
        }
    }

    private void markEscapingReferenceValues(int instructionOffset, int stackEntryIndex) {
        ReferenceValue referenceValue;
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(instructionOffset);
        Value stackEntry = stackBefore.getTop(stackEntryIndex);
        if (stackEntry.computationalType() == 5 && (referenceValue = stackEntry.referenceValue()).isNull() != 1) {
            this.markEscapingReferenceValues(referenceValue);
        }
    }

    private void markEscapingReferenceValues(ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int parameterCount = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < parameterCount; ++index) {
            if (instructionOffsetValue.isMethodParameter(index)) continue;
            this.instanceEscaping[instructionOffsetValue.instructionOffset((int)index)] = true;
        }
    }

    private void markReturnedReferenceValues(int instructionOffset, int stackEntryIndex) {
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(instructionOffset);
        ReferenceValue referenceValue = stackBefore.getTop(stackEntryIndex).referenceValue();
        if (referenceValue.isNull() != 1) {
            this.markReturnedReferenceValues(referenceValue);
        }
    }

    private void markReturnedReferenceValues(ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int parameterCount = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < parameterCount; ++index) {
            if (instructionOffsetValue.isMethodParameter(index)) continue;
            this.instanceReturned[instructionOffsetValue.instructionOffset((int)index)] = true;
        }
    }

    private void markModifiedReferenceValues(int instructionOffset, int stackEntryIndex) {
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(instructionOffset);
        ReferenceValue referenceValue = stackBefore.getTop(stackEntryIndex).referenceValue();
        if (referenceValue.isNull() != 1) {
            this.markModifiedReferenceValues(referenceValue);
        }
    }

    private void markModifiedReferenceValues(ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue instructionOffsetValue = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int parameterCount = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < parameterCount; ++index) {
            if (instructionOffsetValue.isMethodParameter(index)) continue;
            this.instanceModified[instructionOffsetValue.instructionOffset((int)index)] = true;
        }
    }

    private void markExternalReferenceValue(int offset) {
        this.externalInstance[offset] = true;
    }
}

