/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.io.ExtraDataEntryNameMap;
import proguard.optimize.gson.FieldSignatureCollector;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineDeserializer;
import proguard.optimize.gson.InlineDeserializers;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.TypeTokenClassBuilder;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;

public class GsonDeserializationOptimizer
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final Map<String, InlineDeserializer> inlineDeserializers = new HashMap<String, InlineDeserializer>();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final OptimizedJsonInfo deserializationInfo;
    private final boolean supportExposeAnnotation;
    private final ExtraDataEntryNameMap extraDataEntryNameMap;
    private OptimizedJsonInfo.ClassJsonInfo classDeserializationInfo;
    private Map<String, String[]> javaToJsonFieldNames;
    private Map<String, CompactCodeAttributeComposer.Label> caseLabelByJavaFieldName;
    private CompactCodeAttributeComposer.Label endSwitch;

    public GsonDeserializationOptimizer(ClassPool programClassPool, ClassPool libraryClassPool, GsonRuntimeSettings gsonRuntimeSettings, OptimizedJsonInfo deserializationInfo, ExtraDataEntryNameMap extraDataEntryNameMap) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.deserializationInfo = deserializationInfo;
        this.supportExposeAnnotation = gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation;
        this.extraDataEntryNameMap = extraDataEntryNameMap;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= 0xFFFFFFFD;
        programClass.u2accessFlags |= 1;
        MemberCounter constructorCounter = new MemberCounter();
        programClass.methodsAccept(new MemberNameFilter("<init>", (MemberVisitor)new MemberDescriptorFilter("()V", (MemberVisitor)new MultiMemberVisitor(new MemberAccessSetter(1), constructorCounter))));
        ClassBuilder classBuilder = new ClassBuilder(programClass, this.programClassPool, this.libraryClassPool);
        if (constructorCounter.getCount() == 0) {
            this.addDefaultConstructor(classBuilder);
        }
        int classIndex = this.deserializationInfo.classIndices.get(programClass.getName());
        this.addFromJsonMethod(classBuilder, classIndex);
        this.addFromJsonFieldMethod(classBuilder, classIndex);
        programClass.accept(new MethodLinker());
    }

    private void addDefaultConstructor(ClassBuilder classBuilder) {
        ProgramClass programClass = classBuilder.getProgramClass();
        classBuilder.addMethod(4097, "<init>", "()V", 10, code -> code.aload_0().invokespecial(programClass.getSuperName(), "<init>", "()V").return_(), new ProgramMemberOptimizationInfoSetter());
    }

    private void addFromJsonMethod(ClassBuilder classBuilder, int classIndex) {
        String methodNameFromJson = "fromJson$" + classIndex;
        classBuilder.addMethod(4097, methodNameFromJson, OptimizedClassConstants.METHOD_TYPE_FROM_JSON, 10, new FromJsonCodeAttributeVisitor(), new ProgramMemberOptimizationInfoSetter());
    }

    private void addFromJsonFieldMethod(ClassBuilder classBuilder, int classIndex) {
        String methodNameFromJsonField = "fromJsonField$" + classIndex;
        classBuilder.addMethod(4100, methodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V", 50, new FromJsonFieldCodeBuilder(), new ProgramMemberOptimizationInfoSetter());
    }

    static {
        inlineDeserializers.put("B", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Byte.TYPE));
        inlineDeserializers.put("S", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Short.TYPE));
        inlineDeserializers.put("I", new InlineDeserializers.InlinePrimitiveIntegerDeserializer());
        inlineDeserializers.put("Ljava/lang/String;", new InlineDeserializers.InlineStringDeserializer());
    }

    public static class FromJsonFieldCase
    implements Comparable<FromJsonFieldCase> {
        private String javaFieldName;
        private CompactCodeAttributeComposer.Label label;
        private int fieldIndex;

        public FromJsonFieldCase(String javaFieldName, CompactCodeAttributeComposer.Label label, int fieldIndex) {
            this.javaFieldName = javaFieldName;
            this.label = label;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public int compareTo(FromJsonFieldCase fromJsonFieldCase) {
            return this.fieldIndex - fromJsonFieldCase.fieldIndex;
        }
    }

    private class FromJsonFieldCodeBuilder
    implements ClassBuilder.CodeBuilder,
    MemberVisitor {
        private CompactCodeAttributeComposer ____;
        private int isNullLocalIndex;

        private FromJsonFieldCodeBuilder() {
        }

        @Override
        public void compose(CompactCodeAttributeComposer ____) {
            this.____ = ____;
            ProgramClass clazz = ____.getTargetClass();
            GsonDeserializationOptimizer.this.endSwitch = ____.createLabel();
            if (GsonDeserializationOptimizer.this.javaToJsonFieldNames.size() > 0) {
                CompactCodeAttributeComposer.Label tokenNotNull = ____.createLabel();
                CompactCodeAttributeComposer.Label assignIsNull = ____.createLabel();
                this.isNullLocalIndex = 1;
                ____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;").getstatic("com/google/gson/stream/JsonToken", "NULL", "Lcom/google/gson/stream/JsonToken;");
                ____.ifacmpeq(tokenNotNull).iconst_1().goto_(assignIsNull).label(tokenNotNull).iconst_0().label(assignIsNull).istore(this.isNullLocalIndex);
                this.generateSwitchTables(clazz);
            }
            if (!clazz.getSuperName().equals("java/lang/Object")) {
                Integer superClassIndex = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classIndices.get(clazz.getSuperName());
                String superMethodNameFromJsonField = "fromJsonField$" + superClassIndex;
                ____.aload(0).aload(1).aload(2).iload(3).invokevirtual(clazz.getSuperName(), superMethodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
            } else {
                ____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "skipValue", "()V");
            }
            ____.label(GsonDeserializationOptimizer.this.endSwitch).return_();
        }

        private void generateSwitchTables(Clazz clazz) {
            Set<String> exposedJavaFieldNames = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).classDeserializationInfo.exposedJavaFieldNames;
            Set<String> exposedOrAllJavaFieldNames = GsonDeserializationOptimizer.this.supportExposeAnnotation ? exposedJavaFieldNames : GsonDeserializationOptimizer.this.javaToJsonFieldNames.keySet();
            this.generateSwitchTable(clazz, GsonDeserializationOptimizer.this.javaToJsonFieldNames, exposedOrAllJavaFieldNames);
            if (GsonDeserializationOptimizer.this.supportExposeAnnotation) {
                CompactCodeAttributeComposer.Label nonExposedCasesEnd = this.____.createLabel();
                this.____.aload(1).getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "requireExpose", "Z").ifne(nonExposedCasesEnd);
                HashSet<String> nonExposedJavaFieldNames = new HashSet<String>();
                for (String javaFieldName : GsonDeserializationOptimizer.this.javaToJsonFieldNames.keySet()) {
                    if (exposedJavaFieldNames.contains(javaFieldName)) continue;
                    nonExposedJavaFieldNames.add(javaFieldName);
                }
                this.generateSwitchTable(clazz, GsonDeserializationOptimizer.this.javaToJsonFieldNames, nonExposedJavaFieldNames);
                this.____.label(nonExposedCasesEnd);
            }
        }

        private void generateSwitchTable(Clazz clazz, Map<String, String[]> javaToJsonFieldNames, Set<String> javaFieldNamesToProcess) {
            ArrayList<FromJsonFieldCase> fromJsonFieldCases = new ArrayList<FromJsonFieldCase>();
            for (Map.Entry<String, String[]> javaToJsonFieldNameEntry : javaToJsonFieldNames.entrySet()) {
                if (!javaFieldNamesToProcess.contains(javaToJsonFieldNameEntry.getKey())) continue;
                String[] jsonFieldNames = javaToJsonFieldNameEntry.getValue();
                CompactCodeAttributeComposer.Label caseLabel = this.____.createLabel();
                for (String jsonFieldName : jsonFieldNames) {
                    fromJsonFieldCases.add(new FromJsonFieldCase(javaToJsonFieldNameEntry.getKey(), caseLabel, ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.jsonFieldIndices.get(jsonFieldName)));
                }
            }
            Collections.sort(fromJsonFieldCases);
            int[] cases = new int[fromJsonFieldCases.size()];
            CompactCodeAttributeComposer.Label[] jumpOffsets = new CompactCodeAttributeComposer.Label[fromJsonFieldCases.size()];
            GsonDeserializationOptimizer.this.caseLabelByJavaFieldName = new HashMap();
            for (int caseIndex = 0; caseIndex < fromJsonFieldCases.size(); ++caseIndex) {
                FromJsonFieldCase fromJsonFieldCase = (FromJsonFieldCase)fromJsonFieldCases.get(caseIndex);
                cases[caseIndex] = fromJsonFieldCase.fieldIndex;
                jumpOffsets[caseIndex] = fromJsonFieldCase.label;
                GsonDeserializationOptimizer.this.caseLabelByJavaFieldName.put(fromJsonFieldCase.javaFieldName, fromJsonFieldCase.label);
            }
            CompactCodeAttributeComposer.Label defaultCase = this.____.createLabel();
            this.____.iload(3).lookupswitch(defaultCase, cases, jumpOffsets);
            clazz.fieldsAccept(new MemberAccessFilter(0, 4104, this));
            this.____.label(defaultCase);
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            CompactCodeAttributeComposer.Label fromJsonFieldCaseLabel = (CompactCodeAttributeComposer.Label)GsonDeserializationOptimizer.this.caseLabelByJavaFieldName.get(programField.getName(programClass));
            if (fromJsonFieldCaseLabel != null) {
                programField.accept(programClass, (MemberVisitor)new MemberAccessFlagCleaner(16));
                CompactCodeAttributeComposer.Label isNull = this.____.createLabel();
                this.____.label(fromJsonFieldCaseLabel).iload(this.isNullLocalIndex).ifeq(isNull);
                String fieldDescriptor = programField.getDescriptor(programClass);
                FieldSignatureCollector signatureAttributeCollector = new FieldSignatureCollector();
                programField.attributesAccept(programClass, signatureAttributeCollector);
                InlineDeserializer inlineDeserializer = (InlineDeserializer)inlineDeserializers.get(fieldDescriptor);
                if (inlineDeserializer != null && inlineDeserializer.canDeserialize(GsonDeserializationOptimizer.this.gsonRuntimeSettings)) {
                    inlineDeserializer.deserialize(programClass, programField, this.____, GsonDeserializationOptimizer.this.gsonRuntimeSettings);
                } else {
                    String fieldTypeName;
                    String fieldClassName;
                    if (ClassUtil.isInternalPrimitiveType(fieldDescriptor)) {
                        fieldTypeName = fieldClassName = ClassUtil.internalNumericClassNameFromPrimitiveType(fieldDescriptor.charAt(0));
                    } else {
                        fieldClassName = ClassUtil.internalClassNameFromClassType(fieldDescriptor);
                        fieldTypeName = fieldDescriptor;
                    }
                    String typeTokenClassName = null;
                    if (signatureAttributeCollector.getFieldSignature() != null) {
                        ProgramClass typeTokenClass = new TypeTokenClassBuilder(programClass, programField, signatureAttributeCollector.getFieldSignature()).build();
                        GsonDeserializationOptimizer.this.programClassPool.addClass(typeTokenClass);
                        typeTokenClass.accept(new MultiClassVisitor(new ClassSuperHierarchyInitializer(GsonDeserializationOptimizer.this.programClassPool, GsonDeserializationOptimizer.this.libraryClassPool), new ClassSubHierarchyInitializer(), new ClassReferenceInitializer(GsonDeserializationOptimizer.this.programClassPool, GsonDeserializationOptimizer.this.libraryClassPool)));
                        GsonDeserializationOptimizer.this.extraDataEntryNameMap.addExtraClassToClass((Clazz)programClass, typeTokenClass);
                    }
                    if (typeTokenClassName == null) {
                        this.____.aload(0).aload(1).ldc(fieldTypeName, GsonDeserializationOptimizer.this.programClassPool.getClass(fieldClassName)).invokevirtual("com/google/gson/Gson", "getAdapter", "(Ljava/lang/Class;)Lcom/google/gson/TypeAdapter;");
                    } else {
                        this.____.aload(0).aload(1).new_(typeTokenClassName).dup().invokespecial(typeTokenClassName, "<init>", "()V").invokevirtual("com/google/gson/Gson", "getAdapter", "(Lcom/google/gson/reflect/TypeToken;)Lcom/google/gson/TypeAdapter;");
                    }
                    this.____.aload(2).invokevirtual("com/google/gson/TypeAdapter", "read", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;").checkcast(fieldTypeName, GsonDeserializationOptimizer.this.programClassPool.getClass(fieldClassName));
                    switch (fieldDescriptor.charAt(0)) {
                        case 'Z': {
                            this.____.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                            break;
                        }
                        case 'B': {
                            this.____.invokevirtual("java/lang/Byte", "byteValue", "()B");
                            break;
                        }
                        case 'C': {
                            this.____.invokevirtual("java/lang/Character", "charValue", "()C");
                            break;
                        }
                        case 'S': {
                            this.____.invokevirtual("java/lang/Short", "shortValue", "()S");
                            break;
                        }
                        case 'I': {
                            this.____.invokevirtual("java/lang/Integer", "intValue", "()I");
                            break;
                        }
                        case 'J': {
                            this.____.invokevirtual("java/lang/Long", "longValue", "()J");
                            break;
                        }
                        case 'F': {
                            this.____.invokevirtual("java/lang/Float", "floatValue", "()F");
                            break;
                        }
                        case 'D': {
                            this.____.invokevirtual("java/lang/Double", "doubleValue", "()D");
                        }
                    }
                    this.____.putfield(programClass, programField);
                }
                this.____.goto_(GsonDeserializationOptimizer.this.endSwitch);
                this.____.label(isNull);
                if (!ClassUtil.isInternalPrimitiveType(fieldDescriptor)) {
                    this.____.aload(0).aconst_null().putfield(programClass, programField);
                }
                this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextNull", "()V").goto_(GsonDeserializationOptimizer.this.endSwitch);
            }
        }
    }

    private class FromJsonCodeAttributeVisitor
    implements ClassBuilder.CodeBuilder {
        private FromJsonCodeAttributeVisitor() {
        }

        @Override
        public void compose(CompactCodeAttributeComposer ____) {
            String className = ____.getTargetClass().getName();
            ____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "beginObject", "()V");
            int nextFieldIndexLocalIndex = 1;
            CompactCodeAttributeComposer.Label startWhile = ____.createLabel();
            CompactCodeAttributeComposer.Label endJsonObject = ____.createLabel();
            ____.label(startWhile).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "hasNext", "()Z").ifeq(endJsonObject);
            ____.aload(3).aload(2).invokeinterface("proguard/optimize/gson/_OptimizedJsonReader", "b", "(Lcom/google/gson/stream/JsonReader;)I").istore(nextFieldIndexLocalIndex);
            GsonDeserializationOptimizer.this.classDeserializationInfo = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classJsonInfos.get(className);
            GsonDeserializationOptimizer.this.javaToJsonFieldNames = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).classDeserializationInfo.javaToJsonFieldNames;
            Integer classIndex = ((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).deserializationInfo.classIndices.get(className);
            String methodNameFromJsonField = "fromJsonField$" + classIndex;
            ____.aload(0).aload(1).aload(2).iload(nextFieldIndexLocalIndex).invokevirtual(className, methodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
            ____.goto_(startWhile);
            ____.label(endJsonObject).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "endObject", "()V").return_();
        }
    }
}

