/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class DuplicateInitializerFixer
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final char[] TYPES = new char[]{'B', 'C', 'S', 'I', 'Z'};
    private final MemberVisitor extraFixedInitializerVisitor;

    public DuplicateInitializerFixer() {
        this(null);
    }

    public DuplicateInitializerFixer(MemberVisitor extraFixedInitializerVisitor) {
        this.extraFixedInitializerVisitor = extraFixedInitializerVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String descriptor;
        Method similarMethod;
        String name = programMethod.getName(programClass);
        if (name.equals("<init>") && !programMethod.equals(similarMethod = programClass.findMethod(name, descriptor = programMethod.getDescriptor(programClass)))) {
            if (KeepMarker.isKept(programMethod)) {
                programMethod = (ProgramMethod)similarMethod;
            }
            int index = descriptor.indexOf(41);
            int typeCounter = 0;
            while (true) {
                StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.substring(0, index));
                for (int arrayDimension = 0; arrayDimension < typeCounter / TYPES.length; ++arrayDimension) {
                    newDescriptorBuffer.append('[');
                }
                newDescriptorBuffer.append(TYPES[typeCounter % TYPES.length]);
                newDescriptorBuffer.append(descriptor.substring(index));
                String newDescriptor = newDescriptorBuffer.toString();
                if (programClass.findMethod(name, newDescriptor) == null) {
                    programMethod.u2descriptorIndex = new ConstantPoolEditor(programClass).addUtf8Constant(newDescriptor);
                    programMethod.attributesAccept(programClass, this);
                    MethodOptimizationInfo methodOptimizationInfo = ProgramMethodOptimizationInfo.getMethodOptimizationInfo(programMethod);
                    if (methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
                        ProgramMethodOptimizationInfo programMethodOptimizationInfo = (ProgramMethodOptimizationInfo)methodOptimizationInfo;
                        int parameterCount = ClassUtil.internalMethodParameterCount(newDescriptor, programMethod.getAccessFlags());
                        programMethodOptimizationInfo.insertParameter(parameterCount - 1);
                        int parameterSize = programMethodOptimizationInfo.getParameterSize();
                        programMethodOptimizationInfo.setParameterSize(parameterSize + 1);
                        programMethodOptimizationInfo.setParameterUsed(parameterSize);
                    }
                    if (this.extraFixedInitializerVisitor != null) {
                        this.extraFixedInitializerVisitor.visitProgramMethod(programClass, programMethod);
                    }
                    return;
                }
                ++typeCounter;
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int maxLocals = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        if (codeAttribute.u2maxLocals < maxLocals) {
            codeAttribute.u2maxLocals = maxLocals;
        }
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String descriptor = method.getDescriptor(clazz);
        int descriptorIndex = descriptor.indexOf(41);
        String signature = signatureAttribute.getSignature(clazz);
        int signatureIndex = signature.indexOf(41);
        String newSignature = signature.substring(0, signatureIndex) + descriptor.charAt(descriptorIndex - 1) + signature.substring(signatureIndex);
        signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int oldParametersCount = parameterAnnotationsAttribute.u1parametersCount++;
        if (parameterAnnotationsAttribute.u2parameterAnnotationsCount == null || parameterAnnotationsAttribute.u2parameterAnnotationsCount.length < parameterAnnotationsAttribute.u1parametersCount) {
            int[] annotationsCounts = new int[parameterAnnotationsAttribute.u1parametersCount];
            Annotation[][] annotations = new Annotation[parameterAnnotationsAttribute.u1parametersCount][];
            System.arraycopy(parameterAnnotationsAttribute.u2parameterAnnotationsCount, 0, annotationsCounts, 0, oldParametersCount);
            System.arraycopy(parameterAnnotationsAttribute.parameterAnnotations, 0, annotations, 0, oldParametersCount);
            parameterAnnotationsAttribute.u2parameterAnnotationsCount = annotationsCounts;
            parameterAnnotationsAttribute.parameterAnnotations = annotations;
        }
    }
}

