/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.util.StringFunction;

public class ResourceFileNameObfuscator
implements ResourceFileVisitor {
    private final StringFunction nameObfuscationFunction;
    private final boolean overrideAlreadyObfuscatedNames;
    private final ResourceFileVisitor extraVisitor;

    public ResourceFileNameObfuscator(StringFunction nameObfuscationFunction, boolean overrideAlreadyObfuscatedNames) {
        this(nameObfuscationFunction, overrideAlreadyObfuscatedNames, null);
    }

    public ResourceFileNameObfuscator(StringFunction nameObfuscationFunction, boolean overrideAlreadyObfuscatedNames, ResourceFileVisitor extraVisitor) {
        this.nameObfuscationFunction = nameObfuscationFunction;
        this.overrideAlreadyObfuscatedNames = overrideAlreadyObfuscatedNames;
        this.extraVisitor = extraVisitor;
    }

    @Override
    public void visitAnyResourceFile(ResourceFile resourceFile) {
        if (this.overrideAlreadyObfuscatedNames || !ResourceFileNameObfuscator.isObfuscated(resourceFile)) {
            String obfuscatedFileName = this.nameObfuscationFunction.transform(resourceFile.fileName);
            if (obfuscatedFileName != null) {
                ResourceFileNameObfuscator.setNewResourceFileName(resourceFile, obfuscatedFileName);
            }
            if (this.extraVisitor != null) {
                resourceFile.accept(this.extraVisitor);
            }
        }
    }

    private static void setNewResourceFileName(ResourceFile resourceFile, String newFileName) {
        resourceFile.setProcessingInfo(resourceFile.fileName);
        resourceFile.fileName = newFileName;
    }

    public static boolean isObfuscated(ResourceFile resourceFile) {
        String originalResourceFileName = ResourceFileNameObfuscator.getOriginalResourceFileName(resourceFile);
        return !resourceFile.getFileName().equals(originalResourceFileName);
    }

    public static String getOriginalResourceFileName(ResourceFile resourceFile) {
        Object processingInfo = resourceFile.getProcessingInfo();
        return processingInfo instanceof String ? (String)processingInfo : resourceFile.fileName;
    }
}

