/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.BasicRangeValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.RangeIntegerValue;
import proguard.evaluation.value.ValueFactory;

public class RangeValueFactory
extends BasicRangeValueFactory
implements ValueFactory {
    static final IntegerValue INTEGER_VALUE_BYTE = new RangeIntegerValue(-128, 127);
    static final IntegerValue INTEGER_VALUE_CHAR = new RangeIntegerValue(0, 65535);
    static final IntegerValue INTEGER_VALUE_SHORT = new RangeIntegerValue(Short.MIN_VALUE, Short.MAX_VALUE);
    static final IntegerValue INTEGER_VALUE_INT = new RangeIntegerValue(Integer.MIN_VALUE, Integer.MAX_VALUE);

    public RangeValueFactory() {
    }

    public RangeValueFactory(ValueFactory referenceValueFactory) {
        super(referenceValueFactory);
    }

    @Override
    public IntegerValue createIntegerValue() {
        return INTEGER_VALUE_INT;
    }

    @Override
    public IntegerValue createIntegerValue(int value) {
        return new RangeIntegerValue(value, value);
    }

    @Override
    public IntegerValue createIntegerValue(int min, int max) {
        return new RangeIntegerValue(min, max);
    }
}

