/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.kotlin.visitor.AllConstructorsVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinConstructorFilter;
import proguard.classfile.visitor.MemberVisitor;

public class MethodToKotlinConstructorVisitor
implements MemberVisitor {
    private final KotlinConstructorVisitor kotlinConstructorVisitor;

    public MethodToKotlinConstructorVisitor(KotlinConstructorVisitor kotlinConstructorVisitor) {
        this.kotlinConstructorVisitor = kotlinConstructorVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programClass.kotlinMetadataAccept(new AllConstructorsVisitor(new KotlinConstructorFilter(func -> programMethod.equals(func.referencedMethod), this.kotlinConstructorVisitor)));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryClass.kotlinMetadataAccept(new AllConstructorsVisitor(new KotlinConstructorFilter(func -> libraryMethod.equals(func.referencedMethod), this.kotlinConstructorVisitor)));
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
    }
}

