/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class InstructionWriter
implements InstructionVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private int codeLength;
    private CodeAttributeEditor codeAttributeEditor;

    public void reset(int codeLength) {
        this.codeLength = codeLength;
        if (this.codeAttributeEditor != null) {
            this.codeAttributeEditor.reset(codeLength);
        }
    }

    public void extend(int codeLength) {
        this.codeLength = codeLength;
        if (this.codeAttributeEditor != null) {
            this.codeAttributeEditor.extend(codeLength);
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        simpleInstruction.write(codeAttribute, offset);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        try {
            constantInstruction.write(codeAttribute, offset);
        }
        catch (IllegalArgumentException exception) {
            ConstantInstruction replacementInstruction = new ConstantInstruction(constantInstruction.opcode, constantInstruction.constantIndex, constantInstruction.constant);
            this.replaceInstruction(offset, replacementInstruction);
            constantInstruction.constantIndex = 0;
            constantInstruction.constant = 0;
            constantInstruction.write(codeAttribute, offset);
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        try {
            variableInstruction.write(codeAttribute, offset);
        }
        catch (IllegalArgumentException exception) {
            VariableInstruction replacementInstruction = new VariableInstruction(variableInstruction.opcode, variableInstruction.variableIndex, variableInstruction.constant);
            this.replaceInstruction(offset, replacementInstruction);
            variableInstruction.variableIndex = 0;
            variableInstruction.constant = 0;
            variableInstruction.write(codeAttribute, offset);
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        try {
            branchInstruction.write(codeAttribute, offset);
        }
        catch (IllegalArgumentException exception) {
            BranchInstruction replacementInstruction = new BranchInstruction(-56, branchInstruction.branchOffset);
            switch (branchInstruction.opcode) {
                default: {
                    replacementInstruction = new BranchInstruction(branchInstruction.opcode, branchInstruction.branchOffset);
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: {
                    BranchInstruction complementaryConditionalBranch = new BranchInstruction((byte)((branchInstruction.opcode + 1 ^ 1) - 1), 8);
                    this.insertBeforeInstruction(offset, complementaryConditionalBranch);
                    break;
                }
                case -58: 
                case -57: {
                    BranchInstruction complementaryConditionalBranch = new BranchInstruction((byte)(branchInstruction.opcode ^ 1), 8);
                    this.insertBeforeInstruction(offset, complementaryConditionalBranch);
                    break;
                }
            }
            this.replaceInstruction(offset, replacementInstruction);
            branchInstruction.branchOffset = 0;
            branchInstruction.write(codeAttribute, offset);
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        switchInstruction.write(codeAttribute, offset);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.codeAttributeEditor != null) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
            this.codeAttributeEditor = null;
        }
    }

    private void insertBeforeInstruction(int instructionOffset, Instruction instruction) {
        this.ensureCodeAttributeEditor();
        this.codeAttributeEditor.insertBeforeInstruction(instructionOffset, instruction);
    }

    private void replaceInstruction(int instructionOffset, Instruction instruction) {
        this.ensureCodeAttributeEditor();
        this.codeAttributeEditor.replaceInstruction(instructionOffset, instruction);
    }

    private void insertAfterInstruction(int instructionOffset, Instruction instruction) {
        this.ensureCodeAttributeEditor();
        this.codeAttributeEditor.insertAfterInstruction(instructionOffset, instruction);
    }

    private void ensureCodeAttributeEditor() {
        if (this.codeAttributeEditor == null) {
            this.codeAttributeEditor = new CodeAttributeEditor(false, true);
            this.codeAttributeEditor.reset(this.codeLength);
        }
    }
}

