/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.util.StringUtil;

public class Utf8Constant
extends Constant {
    private byte[] bytes;
    private String string;

    public Utf8Constant() {
    }

    public Utf8Constant(String string) {
        this.bytes = null;
        this.string = string;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
        this.string = null;
    }

    public byte[] getBytes() {
        this.switchToByteArrayRepresentation();
        return this.bytes;
    }

    public void setString(String utf8String) {
        this.bytes = null;
        this.string = utf8String;
    }

    public String getString() {
        this.switchToStringRepresentation();
        return this.string;
    }

    @Override
    public int getTag() {
        return 1;
    }

    @Override
    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitUtf8Constant(clazz, this);
    }

    private void switchToByteArrayRepresentation() {
        if (this.bytes == null) {
            this.bytes = StringUtil.getModifiedUtf8Bytes(this.string);
            this.string = null;
        }
    }

    private void switchToStringRepresentation() {
        if (this.string == null) {
            this.string = StringUtil.getString(this.bytes);
            this.bytes = null;
        }
    }
}

