/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;

public class StringConstant
extends Constant {
    public int u2stringIndex;
    public Clazz referencedClass;
    public Member referencedMember;
    public Clazz javaLangStringClass;
    public int referencedResourceId;
    public ResourceFile referencedResourceFile;

    public StringConstant() {
    }

    public StringConstant(int u2stringIndex, Clazz referencedClass, Member referencedMember) {
        this(u2stringIndex, referencedClass, referencedMember, 0, null);
    }

    public StringConstant(int u2stringIndex, ResourceFile referencedResourceFile) {
        this(u2stringIndex, null, null, 0, referencedResourceFile);
    }

    public StringConstant(int u2stringIndex, Clazz referencedClass, Member referencedMember, int referencedResourceId, ResourceFile referencedResourceFile) {
        this.u2stringIndex = u2stringIndex;
        this.referencedClass = referencedClass;
        this.referencedMember = referencedMember;
        this.referencedResourceId = referencedResourceId;
        this.referencedResourceFile = referencedResourceFile;
    }

    public String getString(Clazz clazz) {
        return clazz.getString(this.u2stringIndex);
    }

    @Override
    public int getTag() {
        return 8;
    }

    @Override
    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitStringConstant(clazz, this);
    }

    public void referencedClassAccept(ClassVisitor classVisitor) {
        if (this.referencedClass != null && this.referencedMember == null) {
            this.referencedClass.accept(classVisitor);
        }
    }

    public void referencedMemberAccept(MemberVisitor memberVisitor) {
        if (this.referencedMember != null) {
            this.referencedMember.accept(this.referencedClass, memberVisitor);
        }
    }

    public void referencedResourceFileAccept(ResourceFileVisitor resourceFileVisitor) {
        if (this.referencedResourceFile != null) {
            this.referencedResourceFile.accept(resourceFileVisitor);
        }
    }
}

