/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.SimpleProcessable;

public abstract class ProgramMember
extends SimpleProcessable
implements Member {
    public int u2accessFlags;
    public int u2nameIndex;
    public int u2descriptorIndex;
    public int u2attributesCount;
    public Attribute[] attributes;

    protected ProgramMember() {
    }

    protected ProgramMember(int u2accessFlags, int u2nameIndex, int u2descriptorIndex, int u2attributesCount, Attribute[] attributes) {
        this(u2accessFlags, u2nameIndex, u2descriptorIndex, u2attributesCount, attributes, 0, null);
    }

    protected ProgramMember(int u2accessFlags, int u2nameIndex, int u2descriptorIndex, int u2attributesCount, Attribute[] attributes, int processingFlags, Object processingInfo) {
        super(processingFlags, processingInfo);
        this.u2accessFlags = u2accessFlags;
        this.u2nameIndex = u2nameIndex;
        this.u2descriptorIndex = u2descriptorIndex;
        this.u2attributesCount = u2attributesCount;
        this.attributes = attributes;
    }

    private Attribute getAttribute(Clazz clazz, String name) {
        for (int index = 0; index < this.u2attributesCount; ++index) {
            Attribute attribute = this.attributes[index];
            if (!attribute.getAttributeName(clazz).equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public abstract void accept(ProgramClass var1, MemberVisitor var2);

    public abstract void attributesAccept(ProgramClass var1, AttributeVisitor var2);

    @Override
    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    @Override
    public String getName(Clazz clazz) {
        return clazz.getString(this.u2nameIndex);
    }

    @Override
    public String getDescriptor(Clazz clazz) {
        return clazz.getString(this.u2descriptorIndex);
    }

    @Override
    public void accept(Clazz clazz, MemberVisitor memberVisitor) {
        this.accept((ProgramClass)clazz, memberVisitor);
    }
}

