/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import proguard.backport.LambdaExpression;
import proguard.backport.LambdaExpressionCollector;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.MemberRemover;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFlagSetter;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.io.ExtraDataEntryNameMap;

public class LambdaExpressionConverter
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private static final String LAMBDA_SINGLETON_FIELD_NAME = "INSTANCE";
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final ExtraDataEntryNameMap extraDataEntryNameMap;
    private final ClassVisitor extraClassVisitor;
    private final Map<Integer, LambdaExpression> lambdaExpressionMap;
    private final CodeAttributeEditor codeAttributeEditor;
    private final MemberRemover memberRemover;
    private static final String METHOD_NAME_DESERIALIZE_LAMBDA = "$deserializeLambda$";
    private static final String METHOD_TYPE_DESERIALIZE_LAMBDA = "(Ljava/lang/invoke/SerializedLambda;)Ljava/lang/Object;";

    public LambdaExpressionConverter(ClassPool programClassPool, ClassPool libraryClassPool, ExtraDataEntryNameMap extraDataEntryNameMap, ClassVisitor extraClassVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.extraDataEntryNameMap = extraDataEntryNameMap;
        this.extraClassVisitor = extraClassVisitor;
        this.lambdaExpressionMap = new HashMap<Integer, LambdaExpression>();
        this.codeAttributeEditor = new CodeAttributeEditor(true, true);
        this.memberRemover = new MemberRemover();
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.lambdaExpressionMap.clear();
        programClass.accept(new LambdaExpressionCollector(this.lambdaExpressionMap));
        if (!this.lambdaExpressionMap.isEmpty()) {
            for (LambdaExpression lambdaExpression : this.lambdaExpressionMap.values()) {
                ProgramClass lambdaClass = this.createLambdaClass(lambdaExpression);
                this.programClassPool.addClass(lambdaClass);
                this.extraDataEntryNameMap.addExtraClassToClass((Clazz)programClass, lambdaClass);
                if (this.extraClassVisitor == null) continue;
                this.extraClassVisitor.visitProgramClass(lambdaClass);
            }
            programClass.accept(new AllMethodVisitor(new AllAttributeVisitor(this)));
            for (LambdaExpression lambdaExpression : this.lambdaExpressionMap.values()) {
                lambdaExpression.lambdaClass.accept(new MultiClassVisitor(new ClassSuperHierarchyInitializer(this.programClassPool, this.libraryClassPool), new ClassSubHierarchyInitializer(), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool)));
            }
            programClass.methodsAccept(this);
            this.memberRemover.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        ProgramClass programClass;
        InvokeDynamicConstant invokeDynamicConstant;
        int bootstrapMethodIndex;
        if (constantInstruction.opcode == -70 && this.lambdaExpressionMap.containsKey(bootstrapMethodIndex = (invokeDynamicConstant = (InvokeDynamicConstant)(programClass = (ProgramClass)clazz).getConstant(constantInstruction.constantIndex)).getBootstrapMethodAttributeIndex())) {
            LambdaExpression lambdaExpression = this.lambdaExpressionMap.get(bootstrapMethodIndex);
            String lambdaClassName = lambdaExpression.getLambdaClassName();
            InstructionSequenceBuilder builder = new InstructionSequenceBuilder(programClass);
            if (lambdaExpression.isStateless()) {
                builder.getstatic(lambdaClassName, LAMBDA_SINGLETON_FIELD_NAME, ClassUtil.internalTypeFromClassName(lambdaClassName));
            } else {
                String type;
                int maxLocals = codeAttribute.u2maxLocals;
                String methodDescriptor = lambdaExpression.getConstructorDescriptor();
                int parameterSize = ClassUtil.internalMethodParameterSize(methodDescriptor);
                if (parameterSize == 1) {
                    // empty if block
                }
                InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(methodDescriptor);
                ArrayList<String> types = new ArrayList<String>();
                while (typeEnumeration.hasMoreTypes()) {
                    types.add(typeEnumeration.nextType());
                }
                int variableIndex = maxLocals;
                ListIterator typeIterator = types.listIterator(types.size());
                while (typeIterator.hasPrevious()) {
                    type = (String)typeIterator.previous();
                    builder.store(variableIndex, type);
                    variableIndex += ClassUtil.internalTypeSize(type);
                }
                builder.new_(lambdaClassName);
                builder.dup();
                typeIterator = types.listIterator();
                while (typeIterator.hasNext()) {
                    type = (String)typeIterator.next();
                    int variableSize = ClassUtil.internalTypeSize(type);
                    builder.load(variableIndex -= variableSize, type);
                }
                builder.invokespecial(lambdaClassName, "<init>", methodDescriptor);
            }
            this.codeAttributeEditor.replaceInstruction(offset, builder.instructions());
        }
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (LambdaExpressionConverter.isDeserializationHook(programClass, programMethod)) {
            this.memberRemover.visitProgramMethod(programClass, programMethod);
        }
    }

    private static boolean isDeserializationHook(Clazz clazz, Method method) {
        return method.getName(clazz).equals(METHOD_NAME_DESERIALIZE_LAMBDA) && method.getDescriptor(clazz).equals(METHOD_TYPE_DESERIALIZE_LAMBDA) && LambdaExpressionConverter.hasFlag(method, 4106);
    }

    private static boolean hasFlag(Member member, int flag) {
        return (member.getAccessFlags() & flag) == flag;
    }

    private ProgramClass createLambdaClass(LambdaExpression lambdaExpression) {
        ProgramClass lambdaClass;
        String[] interfaces;
        String lambdaClassName = lambdaExpression.getLambdaClassName();
        ClassBuilder classBuilder = new ClassBuilder(0x2E0000, 0, lambdaClassName, "java/lang/Object");
        for (String interfaceName : interfaces = lambdaExpression.interfaces) {
            classBuilder.addInterface(interfaceName);
        }
        lambdaExpression.lambdaClass = lambdaClass = classBuilder.getProgramClass();
        if (lambdaExpression.referencesPrivateSyntheticInterfaceMethod()) {
            this.fixInterfaceLambdaMethod(lambdaExpression.referencedClass, (ProgramMethod)lambdaExpression.referencedInvokedMethod, lambdaExpression);
        } else if (lambdaExpression.referencesPrivateConstructor() || lambdaExpression.needsAccessorMethod()) {
            this.addAccessorMethod(lambdaExpression.referencedClass, lambdaExpression);
        }
        if (lambdaExpression.isStateless()) {
            this.completeStatelessLambdaClass(lambdaClass, lambdaExpression);
        } else {
            this.completeCapturingLambdaClass(lambdaClass, lambdaExpression);
        }
        if (lambdaExpression.bridgeMethodDescriptors.length > 0) {
            this.addBridgeMethods(lambdaClass, lambdaExpression);
        }
        return lambdaClass;
    }

    private void fixInterfaceLambdaMethod(ProgramClass programClass, ProgramMethod programMethod, LambdaExpression lambdaExpression) {
        programMethod.accept(programClass, (MemberVisitor)new MemberAccessSetter(0));
        if ((programMethod.getAccessFlags() & 8) == 0) {
            programMethod.accept(programClass, (MemberVisitor)new MemberAccessFlagSetter(8));
            String newDescriptor = LambdaExpressionConverter.prependParameterToMethodDescriptor(lambdaExpression.invokedMethodDesc, ClassUtil.internalTypeFromClassType(programClass.getName()));
            programMethod.u2descriptorIndex = new ConstantPoolEditor(programClass).addUtf8Constant(newDescriptor);
            lambdaExpression.invokedMethodDesc = newDescriptor;
            lambdaExpression.invokedReferenceKind = 6;
        }
    }

    private void addAccessorMethod(ProgramClass programClass, LambdaExpression lambdaExpression) {
        ClassBuilder classBuilder = new ClassBuilder(programClass, this.programClassPool, this.libraryClassPool);
        String className = programClass.getName();
        String shortClassName = ClassUtil.externalShortClassName(ClassUtil.externalClassName(className));
        String accessorMethodName = String.format("accessor$%s$lambda%d", shortClassName, lambdaExpression.bootstrapMethodIndex);
        String accessorMethodDescriptor = lambdaExpression.invokedMethodDesc;
        int accessFlags = lambdaExpression.referencedInvokedMethod.getAccessFlags();
        if (lambdaExpression.invokedReferenceKind == 8) {
            ArrayList<String> invokedParameterTypes = new ArrayList<String>();
            int methodParameterSize = ClassUtil.internalMethodParameterSize(accessorMethodDescriptor);
            for (int i = 0; i < methodParameterSize; ++i) {
                String invokedParameterType = ClassUtil.internalMethodParameterType(accessorMethodDescriptor, i);
                invokedParameterTypes.add(invokedParameterType);
            }
            String invokedClassType = ClassUtil.internalTypeFromClassName(lambdaExpression.invokedClassName);
            accessorMethodDescriptor = ClassUtil.internalMethodDescriptorFromInternalTypes(invokedClassType, invokedParameterTypes);
        } else if ((accessFlags & 8) == 0) {
            accessorMethodDescriptor = LambdaExpressionConverter.prependParameterToMethodDescriptor(accessorMethodDescriptor, ClassUtil.internalTypeFromClassType(className));
        }
        String methodDescriptor = accessorMethodDescriptor;
        classBuilder.addMethod(4104, accessorMethodName, accessorMethodDescriptor, 50, ____ -> {
            if (lambdaExpression.invokedReferenceKind == 8) {
                ____.new_(lambdaExpression.invokedClassName).dup();
            }
            this.completeInterfaceMethod(lambdaExpression, null, methodDescriptor, null, false, 0, ____);
        });
        lambdaExpression.invokedClassName = programClass.getName();
        lambdaExpression.invokedMethodName = accessorMethodName;
        lambdaExpression.invokedMethodDesc = accessorMethodDescriptor;
        lambdaExpression.invokedReferenceKind = 6;
        lambdaExpression.referencedInvokedClass = programClass;
        lambdaExpression.referencedInvokedMethod = programClass.findMethod(accessorMethodName, accessorMethodDescriptor);
    }

    private void completeStatelessLambdaClass(ProgramClass lambdaClass, LambdaExpression lambdaExpression) {
        String lambdaClassType = ClassUtil.internalTypeFromClassName(lambdaClass.getName());
        ClassBuilder classBuilder = new ClassBuilder(lambdaClass, this.programClassPool, this.libraryClassPool);
        classBuilder.addField(25, LAMBDA_SINGLETON_FIELD_NAME, lambdaClassType);
        classBuilder.addMethod(1, "<init>", "()V", 10, code -> code.aload_0().invokespecial("java/lang/Object", "<init>", "()V").return_());
        classBuilder.addMethod(8, "<clinit>", "()V", 30, code -> code.new_(lambdaClass).dup().invokespecial(lambdaClass.getName(), "<init>", "()V").putstatic(lambdaClass.getName(), LAMBDA_SINGLETON_FIELD_NAME, lambdaClassType).return_());
        if (lambdaExpression.isSerializable()) {
            classBuilder.addMethod(2, "readResolve", "()Ljava/lang/Object;", 10, code -> code.getstatic(lambdaClass.getName(), LAMBDA_SINGLETON_FIELD_NAME, lambdaClassType).areturn());
        }
        classBuilder.addMethod(1, lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor, 50, ____ -> {
            if (lambdaExpression.invokedReferenceKind == 8) {
                ____.new_(lambdaExpression.invokedClassName).dup();
                this.completeInterfaceMethod(lambdaExpression, null, lambdaExpression.interfaceMethodDescriptor, lambdaExpression.invokedMethodDesc, false, 1, ____);
            } else {
                boolean isInvokeVirtualOrInterface = lambdaExpression.invokedReferenceKind == 5 || lambdaExpression.invokedReferenceKind == 9;
                this.completeInterfaceMethod(lambdaExpression, null, lambdaExpression.interfaceMethodDescriptor, lambdaExpression.invokedMethodDesc, isInvokeVirtualOrInterface, 1, ____);
            }
        });
    }

    private void completeCapturingLambdaClass(ProgramClass lambdaClass, LambdaExpression lambdaExpression) {
        ClassBuilder classBuilder = new ClassBuilder(lambdaClass, this.programClassPool, this.libraryClassPool);
        String lambdaClassName = lambdaClass.getName();
        String ctorDescriptor = lambdaExpression.getConstructorDescriptor();
        classBuilder.addMethod(1, "<init>", ctorDescriptor, 50, ____ -> {
            ____.aload_0().invokespecial("java/lang/Object", "<init>", "()V");
            InternalTypeEnumeration ctorTypeEnumeration = new InternalTypeEnumeration(ctorDescriptor);
            int ctorArgIndex = 0;
            int ctorVariableIndex = 1;
            while (ctorTypeEnumeration.hasMoreTypes()) {
                String fieldName = "arg$" + ctorArgIndex++;
                String fieldType = ctorTypeEnumeration.nextType();
                ____.aload_0();
                ____.load(ctorVariableIndex, fieldType);
                ____.putfield(lambdaClassName, fieldName, fieldType);
                ctorVariableIndex += ClassUtil.internalTypeSize(fieldType);
            }
            ____.return_();
        });
        InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(ctorDescriptor);
        int argIndex = 0;
        while (typeEnumeration.hasMoreTypes()) {
            String type = typeEnumeration.nextType();
            String fieldName = "arg$" + argIndex++;
            classBuilder.addField(18, fieldName, type);
        }
        classBuilder.addMethod(1, lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor, 50, ____ -> {
            boolean isInvokeVirtualOrInterface = lambdaExpression.invokedReferenceKind == 5 || lambdaExpression.invokedReferenceKind == 9;
            this.completeInterfaceMethod(lambdaExpression, ctorDescriptor, lambdaExpression.interfaceMethodDescriptor, lambdaExpression.invokedMethodDesc, isInvokeVirtualOrInterface, 1, ____);
        });
    }

    private void completeInterfaceMethod(LambdaExpression lambdaExpression, String fieldTypes, String methodDescriptor, String invokedMethodDescriptor, boolean isInvokeVirtualOrInterface, int parameterIndex, CompactCodeAttributeComposer ____) {
        String invokedType;
        String type;
        InternalTypeEnumeration invokedTypeEnumeration;
        InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(methodDescriptor);
        InternalTypeEnumeration internalTypeEnumeration = invokedTypeEnumeration = invokedMethodDescriptor == null ? null : new InternalTypeEnumeration(invokedMethodDescriptor);
        if (fieldTypes != null) {
            String lambdaClassName = ____.getTargetClass().getName();
            InternalTypeEnumeration fieldTypeEnumeration = new InternalTypeEnumeration(fieldTypes);
            int fieldIndex = 0;
            while (fieldTypeEnumeration.hasMoreTypes()) {
                String fieldName = "arg$" + fieldIndex;
                String fieldType = fieldTypeEnumeration.nextType();
                ____.aload_0().getfield(lambdaClassName, fieldName, fieldType);
                if (!isInvokeVirtualOrInterface || fieldIndex > 0) {
                    LambdaExpressionConverter.convertToTargetType(fieldType, invokedTypeEnumeration.nextType(), ____);
                }
                ++fieldIndex;
            }
        } else if (isInvokeVirtualOrInterface) {
            type = typeEnumeration.nextType();
            invokedType = ClassUtil.internalTypeFromClassName(lambdaExpression.invokedClassName);
            ____.load(parameterIndex, type);
            parameterIndex += ClassUtil.internalTypeSize(type);
            LambdaExpressionConverter.convertToTargetType(type, invokedType, ____);
        }
        while (typeEnumeration.hasMoreTypes()) {
            type = typeEnumeration.nextType();
            invokedType = invokedTypeEnumeration != null ? invokedTypeEnumeration.nextType() : null;
            ____.load(parameterIndex, type);
            parameterIndex += ClassUtil.internalTypeSize(type);
            if (invokedType == null) continue;
            LambdaExpressionConverter.convertToTargetType(type, invokedType, ____);
        }
        switch (lambdaExpression.invokedReferenceKind) {
            case 6: {
                if (lambdaExpression.invokesStaticInterfaceMethod()) {
                    ____.invokestatic_interface(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                    break;
                }
                ____.invokestatic(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 5: {
                ____.invokevirtual(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 9: {
                ____.invokeinterface(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 7: 
            case 8: {
                ____.invokespecial(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
            }
        }
        String methodReturnType = typeEnumeration.returnType();
        if (invokedTypeEnumeration != null) {
            LambdaExpressionConverter.convertToTargetType(invokedTypeEnumeration.returnType(), methodReturnType, ____);
        }
        ____.return_(methodReturnType);
    }

    private void addBridgeMethods(ProgramClass lambdaClass, LambdaExpression lambdaExpression) {
        ClassBuilder classBuilder = new ClassBuilder(lambdaClass, this.programClassPool, this.libraryClassPool);
        String methodName = lambdaExpression.interfaceMethod;
        for (String bridgeMethodDescriptor : lambdaExpression.bridgeMethodDescriptors) {
            Method method = lambdaClass.findMethod(methodName, bridgeMethodDescriptor);
            if (method != null) continue;
            classBuilder.addMethod(4161, methodName, bridgeMethodDescriptor, 50, ____ -> {
                ____.aload_0();
                InternalTypeEnumeration interfaceTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
                InternalTypeEnumeration bridgeTypeEnumeration = new InternalTypeEnumeration(bridgeMethodDescriptor);
                int variableIndex = 1;
                while (bridgeTypeEnumeration.hasMoreTypes()) {
                    String type = bridgeTypeEnumeration.nextType();
                    String interfaceType = interfaceTypeEnumeration.nextType();
                    ____.load(variableIndex, type);
                    variableIndex += ClassUtil.internalTypeSize(type);
                    LambdaExpressionConverter.convertToTargetType(type, interfaceType, ____);
                }
                ____.invokevirtual(lambdaClass.getName(), lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor);
                String methodReturnType = bridgeTypeEnumeration.returnType();
                LambdaExpressionConverter.convertToTargetType(interfaceTypeEnumeration.returnType(), methodReturnType, ____);
                ____.return_(methodReturnType);
            });
        }
    }

    private static String prependParameterToMethodDescriptor(String methodDescriptor, String type) {
        StringBuilder methodDescBuilder = new StringBuilder();
        methodDescBuilder.append('(');
        methodDescBuilder.append(type);
        InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(methodDescriptor);
        while (typeEnumeration.hasMoreTypes()) {
            methodDescBuilder.append(typeEnumeration.nextType());
        }
        methodDescBuilder.append(')');
        methodDescBuilder.append(typeEnumeration.returnType());
        return methodDescBuilder.toString();
    }

    private static void convertToTargetType(String sourceType, String targetType, CompactCodeAttributeComposer composer) {
        if (ClassUtil.isInternalPrimitiveType(sourceType) && !ClassUtil.isInternalPrimitiveType(targetType)) {
            switch (sourceType.charAt(0)) {
                case 'I': {
                    composer.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                    break;
                }
                case 'B': {
                    composer.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                    break;
                }
                case 'C': {
                    composer.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                    break;
                }
                case 'S': {
                    composer.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                    break;
                }
                case 'Z': {
                    composer.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                    break;
                }
                case 'J': {
                    composer.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                    break;
                }
                case 'F': {
                    composer.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                    break;
                }
                case 'D': {
                    composer.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                }
            }
        } else if (!ClassUtil.isInternalPrimitiveType(sourceType) && ClassUtil.isInternalPrimitiveType(targetType)) {
            boolean castRequired = sourceType.equals("Ljava/lang/Object;");
            switch (targetType.charAt(0)) {
                case 'I': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "intValue", "()I");
                    break;
                }
                case 'B': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Byte");
                    }
                    composer.invokevirtual("java/lang/Byte", "byteValue", "()B");
                    break;
                }
                case 'C': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Character");
                    }
                    composer.invokevirtual("java/lang/Character", "charValue", "()C");
                    break;
                }
                case 'S': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Short");
                    }
                    composer.invokevirtual("java/lang/Short", "shortValue", "()S");
                    break;
                }
                case 'Z': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Boolean");
                    }
                    composer.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                    break;
                }
                case 'J': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "longValue", "()J");
                    break;
                }
                case 'F': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "floatValue", "()F");
                    break;
                }
                case 'D': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "doubleValue", "()D");
                }
            }
        } else if (ClassUtil.isInternalClassType(sourceType) && (ClassUtil.isInternalClassType(targetType) || ClassUtil.isInternalArrayType(targetType)) && !sourceType.equals(targetType) && !"Ljava/lang/Object;".equals(targetType)) {
            composer.checkcast(ClassUtil.internalClassTypeFromType(targetType));
        }
    }
}

