/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import proguard.ArgumentWordReader;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationConstants;
import proguard.FileWordReader;
import proguard.KeepClassSpecification;
import proguard.LineWordReader;
import proguard.MemberSpecification;
import proguard.MemberValueSpecification;
import proguard.ParseException;
import proguard.WordReader;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;
import proguard.util.StringUtil;

public class ConfigurationParser {
    private final WordReader reader;
    private final Properties properties;
    private String nextWord;
    private String lastComments;

    public ConfigurationParser(String[] args, Properties properties) throws IOException {
        this(args, null, properties);
    }

    public ConfigurationParser(String[] args, File baseDir, Properties properties) throws IOException {
        this(new ArgumentWordReader(args, baseDir), properties);
    }

    public ConfigurationParser(String lines, String description, File baseDir, Properties properties) throws IOException {
        this(new LineWordReader(new LineNumberReader(new StringReader(lines)), description, baseDir), properties);
    }

    public ConfigurationParser(File file) throws IOException {
        this(file, System.getProperties());
    }

    public ConfigurationParser(File file, Properties properties) throws IOException {
        this(new FileWordReader(file), properties);
    }

    public ConfigurationParser(URL url, Properties properties) throws IOException {
        this(new FileWordReader(url), properties);
    }

    public ConfigurationParser(WordReader reader, Properties properties) throws IOException {
        this.reader = reader;
        this.properties = properties;
        this.readNextWord();
    }

    public void parse(Configuration configuration) throws ParseException, IOException {
        while (this.nextWord != null) {
            this.lastComments = this.reader.lastComments();
            if ("@".startsWith(this.nextWord) || "-include".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseIncludeArgument(configuration.lastModified);
                continue;
            }
            if ("-basedirectory".startsWith(this.nextWord)) {
                this.parseBaseDirectoryArgument();
                continue;
            }
            if ("-injars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, false, true);
                continue;
            }
            if ("-outjars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, true, false);
                continue;
            }
            if ("-libraryjars".startsWith(this.nextWord)) {
                configuration.libraryJars = this.parseClassPathArgument(configuration.libraryJars, false, false);
                continue;
            }
            if ("-resourcejars".startsWith(this.nextWord)) {
                throw new ParseException("The '-resourcejars' option is no longer supported. Please use the '-injars' option for all input");
            }
            if ("-skipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(true);
                continue;
            }
            if ("-dontskipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(false);
                continue;
            }
            if ("-dontskipnonpubliclibraryclassmembers".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClassMembers = this.parseNoArgument(false);
                continue;
            }
            if ("-target".startsWith(this.nextWord)) {
                configuration.targetClassVersion = this.parseClassVersion();
                continue;
            }
            if ("-dontcompress".startsWith(this.nextWord)) {
                configuration.dontCompress = this.parseCommaSeparatedList("file name", true, true, false, true, false, true, false, false, false, configuration.dontCompress);
                continue;
            }
            if ("-zipalign".startsWith(this.nextWord)) {
                configuration.zipAlign = this.parseIntegerArgument();
                continue;
            }
            if ("-forceprocessing".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseNoArgument(Long.MAX_VALUE);
                continue;
            }
            if ("-if".startsWith(this.nextWord)) {
                configuration.keep = this.parseIfCondition(configuration.keep);
                continue;
            }
            if ("-keep".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, true, false, false, false, null);
                continue;
            }
            if ("-keepclassmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, false, false, false, null);
                continue;
            }
            if ("-keepclasseswithmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, false, true, false, null);
                continue;
            }
            if ("-keepnames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, true, false, false, true, null);
                continue;
            }
            if ("-keepclassmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, false, false, true, null);
                continue;
            }
            if ("-keepclasseswithmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, false, true, true, null);
                continue;
            }
            if ("-keepcode".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, false, true, false, false, null);
                continue;
            }
            if ("-printseeds".startsWith(this.nextWord)) {
                configuration.printSeeds = this.parseOptionalFile();
                continue;
            }
            if ("-keepdirectories".startsWith(this.nextWord)) {
                configuration.keepDirectories = this.parseCommaSeparatedList("directory name", true, true, false, true, false, true, true, false, false, configuration.keepDirectories);
                continue;
            }
            if ("-dontshrink".startsWith(this.nextWord)) {
                configuration.shrink = this.parseNoArgument(false);
                continue;
            }
            if ("-printusage".startsWith(this.nextWord)) {
                configuration.printUsage = this.parseOptionalFile();
                continue;
            }
            if ("-whyareyoukeeping".startsWith(this.nextWord)) {
                configuration.whyAreYouKeeping = this.parseClassSpecificationArguments(configuration.whyAreYouKeeping);
                continue;
            }
            if ("-dontoptimize".startsWith(this.nextWord)) {
                configuration.optimize = this.parseNoArgument(false);
                continue;
            }
            if ("-optimizationpasses".startsWith(this.nextWord)) {
                configuration.optimizationPasses = this.parseIntegerArgument();
                continue;
            }
            if ("-optimizations".startsWith(this.nextWord)) {
                configuration.optimizations = this.parseCommaSeparatedList("optimization name", true, false, false, false, false, true, false, false, false, configuration.optimizations);
                continue;
            }
            if ("-assumenosideeffects".startsWith(this.nextWord)) {
                configuration.assumeNoSideEffects = this.parseAssumeClassSpecificationArguments(configuration.assumeNoSideEffects);
                continue;
            }
            if ("-assumenoexternalsideeffects".startsWith(this.nextWord)) {
                configuration.assumeNoExternalSideEffects = this.parseAssumeClassSpecificationArguments(configuration.assumeNoExternalSideEffects);
                continue;
            }
            if ("-assumenoescapingparameters".startsWith(this.nextWord)) {
                configuration.assumeNoEscapingParameters = this.parseAssumeClassSpecificationArguments(configuration.assumeNoEscapingParameters);
                continue;
            }
            if ("-assumenoexternalreturnvalues".startsWith(this.nextWord)) {
                configuration.assumeNoExternalReturnValues = this.parseAssumeClassSpecificationArguments(configuration.assumeNoExternalReturnValues);
                continue;
            }
            if ("-assumevalues".startsWith(this.nextWord)) {
                configuration.assumeValues = this.parseAssumeClassSpecificationArguments(configuration.assumeValues);
                continue;
            }
            if ("-allowaccessmodification".startsWith(this.nextWord)) {
                configuration.allowAccessModification = this.parseNoArgument(true);
                continue;
            }
            if ("-mergeinterfacesaggressively".startsWith(this.nextWord)) {
                configuration.mergeInterfacesAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-dontobfuscate".startsWith(this.nextWord)) {
                configuration.obfuscate = this.parseNoArgument(false);
                continue;
            }
            if ("-printmapping".startsWith(this.nextWord)) {
                configuration.printMapping = this.parseOptionalFile();
                continue;
            }
            if ("-applymapping".startsWith(this.nextWord)) {
                configuration.applyMapping = this.parseFile();
                continue;
            }
            if ("-obfuscationdictionary".startsWith(this.nextWord)) {
                configuration.obfuscationDictionary = this.parseURL();
                continue;
            }
            if ("-classobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.classObfuscationDictionary = this.parseURL();
                continue;
            }
            if ("-packageobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.packageObfuscationDictionary = this.parseURL();
                continue;
            }
            if ("-overloadaggressively".startsWith(this.nextWord)) {
                configuration.overloadAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-useuniqueclassmembernames".startsWith(this.nextWord)) {
                configuration.useUniqueClassMemberNames = this.parseNoArgument(true);
                continue;
            }
            if ("-dontusemixedcaseclassnames".startsWith(this.nextWord)) {
                configuration.useMixedCaseClassNames = this.parseNoArgument(false);
                continue;
            }
            if ("-keeppackagenames".startsWith(this.nextWord)) {
                configuration.keepPackageNames = this.parseCommaSeparatedList("package name", true, true, false, false, true, false, false, true, false, configuration.keepPackageNames);
                continue;
            }
            if ("-flattenpackagehierarchy".startsWith(this.nextWord)) {
                configuration.flattenPackageHierarchy = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-repackageclasses".startsWith(this.nextWord) || "-defaultpackage".startsWith(this.nextWord)) {
                configuration.repackageClasses = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-keepattributes".startsWith(this.nextWord)) {
                configuration.keepAttributes = this.parseCommaSeparatedList("attribute name", true, true, false, false, true, false, false, false, false, configuration.keepAttributes);
                continue;
            }
            if ("-keepparameternames".startsWith(this.nextWord)) {
                configuration.keepParameterNames = this.parseNoArgument(true);
                continue;
            }
            if ("-renamesourcefileattribute".startsWith(this.nextWord)) {
                configuration.newSourceFileAttribute = this.parseOptionalArgument();
                continue;
            }
            if ("-adaptclassstrings".startsWith(this.nextWord)) {
                configuration.adaptClassStrings = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, false, true, false, configuration.adaptClassStrings);
                continue;
            }
            if ("-adaptresourcefilenames".startsWith(this.nextWord)) {
                configuration.adaptResourceFileNames = this.parseCommaSeparatedList("resource file name", true, true, false, true, false, true, false, false, false, configuration.adaptResourceFileNames);
                continue;
            }
            if ("-adaptresourcefilecontents".startsWith(this.nextWord)) {
                configuration.adaptResourceFileContents = this.parseCommaSeparatedList("resource file name", true, true, false, true, false, true, false, false, false, configuration.adaptResourceFileContents);
                continue;
            }
            if ("-keepkotlinmetadata".startsWith(this.nextWord)) {
                configuration.keepKotlinMetadata = this.parseNoArgument(true);
                continue;
            }
            if ("-dontpreverify".startsWith(this.nextWord)) {
                configuration.preverify = this.parseNoArgument(false);
                continue;
            }
            if ("-microedition".startsWith(this.nextWord)) {
                configuration.microEdition = this.parseNoArgument(true);
                continue;
            }
            if ("-android".startsWith(this.nextWord)) {
                configuration.android = this.parseNoArgument(true);
                continue;
            }
            if ("-keystore".startsWith(this.nextWord)) {
                configuration.keyStores = this.parseFiles(configuration.keyStores);
                continue;
            }
            if ("-keystorepassword".startsWith(this.nextWord)) {
                configuration.keyStorePasswords = this.parseCommaSeparatedList("keystore password", true, false, false, false, false, false, true, false, false, configuration.keyStorePasswords);
                continue;
            }
            if ("-keyalias".startsWith(this.nextWord)) {
                configuration.keyAliases = this.parseCommaSeparatedList("key", true, false, false, false, false, false, true, false, false, configuration.keyAliases);
                continue;
            }
            if ("-keypassword".startsWith(this.nextWord)) {
                configuration.keyPasswords = this.parseCommaSeparatedList("key password", true, false, false, false, false, false, true, false, false, configuration.keyPasswords);
                continue;
            }
            if ("-verbose".startsWith(this.nextWord)) {
                configuration.verbose = this.parseNoArgument(true);
                continue;
            }
            if ("-dontnote".startsWith(this.nextWord)) {
                configuration.note = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, false, true, false, configuration.note);
                continue;
            }
            if ("-dontwarn".startsWith(this.nextWord)) {
                configuration.warn = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, false, true, false, configuration.warn);
                continue;
            }
            if ("-ignorewarnings".startsWith(this.nextWord)) {
                configuration.ignoreWarnings = this.parseNoArgument(true);
                continue;
            }
            if ("-printconfiguration".startsWith(this.nextWord)) {
                configuration.printConfiguration = this.parseOptionalFile();
                continue;
            }
            if ("-dump".startsWith(this.nextWord)) {
                configuration.dump = this.parseOptionalFile();
                continue;
            }
            if ("-addconfigurationdebugging".startsWith(this.nextWord)) {
                configuration.addConfigurationDebugging = this.parseNoArgument(true);
                continue;
            }
            throw new ParseException("Unknown option " + this.reader.locationDescription());
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private long parseIncludeArgument(long lastModified) throws ParseException, IOException {
        this.readNextWord("configuration file name", true, true, false);
        URL baseURL = this.reader.getBaseURL();
        URL url = null;
        try {
            url = new URL(this.nextWord);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null) {
            this.reader.includeWordReader(new FileWordReader(url));
        } else if (baseURL != null) {
            url = new URL(baseURL, this.nextWord);
            this.reader.includeWordReader(new FileWordReader(url));
        } else {
            url = ConfigurationParser.class.getResource(this.nextWord);
            if (url != null) {
                this.reader.includeWordReader(new FileWordReader(url));
            } else {
                File file = this.file(this.nextWord);
                this.reader.includeWordReader(new FileWordReader(file));
                long fileLastModified = file.lastModified();
                if (fileLastModified > lastModified) {
                    lastModified = fileLastModified;
                }
            }
        }
        this.readNextWord();
        return lastModified;
    }

    private void parseBaseDirectoryArgument() throws ParseException, IOException {
        this.readNextWord("base directory name", true, true, false);
        this.reader.setBaseDir(this.file(this.nextWord));
        this.readNextWord();
    }

    private ClassPath parseClassPathArgument(ClassPath classPath, boolean isOutput, boolean allowFeatureName) throws ParseException, IOException {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        this.readNextWord("jar or directory name", true, false, false);
        String featureName = null;
        if (allowFeatureName && this.nextWord.length() == 0) {
            this.readNextWord("separating ','");
            if (!",".equals(this.nextWord)) {
                throw new ParseException("Expecting separating ',' or jar or directory name' before " + this.reader.locationDescription());
            }
            this.readNextWord("feature name", false, false, false);
            featureName = this.nextWord;
            this.readNextWord("jar or directory name", true, false, false);
        }
        while (true) {
            ClassPathEntry entry = new ClassPathEntry(this.file(this.nextWord), isOutput, featureName);
            this.readNextWord();
            if (!this.configurationEnd() && "(".equals(this.nextWord)) {
                List[] filters = new List[7];
                int counter = 0;
                do {
                    filters[counter++] = this.parseCommaSeparatedList("filter", true, true, true, true, false, true, true, false, false, null);
                } while (counter < filters.length && ";".equals(this.nextWord));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or ';', or closing ')' before " + this.reader.locationDescription());
                }
                entry.setFilter(filters[--counter]);
                if (counter > 0) {
                    entry.setJarFilter(filters[--counter]);
                    if (counter > 0) {
                        entry.setWarFilter(filters[--counter]);
                        if (counter > 0) {
                            entry.setEarFilter(filters[--counter]);
                            if (counter > 0) {
                                entry.setJmodFilter(filters[--counter]);
                                if (counter > 0) {
                                    entry.setZipFilter(filters[--counter]);
                                    if (counter > 0) {
                                        entry.setApkFilter(filters[--counter]);
                                        if (counter > 0) {
                                            entry.setAabFilter(filters[--counter]);
                                            if (counter > 0) {
                                                entry.setAarFilter(filters[--counter]);
                                                if (counter > 0) {
                                                    entry.setJmodFilter(filters[--counter]);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                this.readNextWord();
            }
            classPath.add(entry);
            if (this.configurationEnd()) {
                return classPath;
            }
            if (!this.nextWord.equals(ConfigurationConstants.JAR_SEPARATOR_KEYWORD)) {
                throw new ParseException("Expecting class path separator '" + ConfigurationConstants.JAR_SEPARATOR_KEYWORD + "' before " + this.reader.locationDescription());
            }
            this.readNextWord("jar or directory name", true, false, false);
        }
    }

    private int parseClassVersion() throws ParseException, IOException {
        this.readNextWord("java version");
        int classVersion = ClassUtil.internalClassVersion(this.nextWord);
        if (classVersion == 0) {
            throw new ParseException("Unsupported java version " + this.reader.locationDescription());
        }
        this.readNextWord();
        return classVersion;
    }

    private int parseIntegerArgument() throws ParseException, IOException {
        try {
            this.readNextWord("integer");
            int integer = Integer.parseInt(this.nextWord);
            if (integer <= 0) {
                throw new ParseException("Expecting value larger than 0, instead of '" + this.nextWord + "' before " + this.reader.locationDescription());
            }
            this.readNextWord();
            return integer;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Expecting integer argument instead of '" + this.nextWord + "' before " + this.reader.locationDescription());
        }
    }

    private URL parseURL() throws ParseException, IOException {
        this.readNextWord("file name", true, true, false);
        URL url = this.url(this.nextWord);
        this.readNextWord();
        return url;
    }

    private List parseFiles(List files) throws ParseException, IOException {
        if (files == null) {
            files = new ArrayList<File>();
        }
        files.add(this.parseFile());
        return files;
    }

    private File parseFile() throws ParseException, IOException {
        this.readNextWord("file name", true, true, false);
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private File parseOptionalFile() throws ParseException, IOException {
        this.readNextWord(true, true);
        if (this.configurationEnd()) {
            return Configuration.STD_OUT;
        }
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private String parseOptionalArgument() throws IOException {
        this.readNextWord();
        if (this.configurationEnd()) {
            return "";
        }
        String argument = this.nextWord;
        this.readNextWord();
        return argument;
    }

    private boolean parseNoArgument(boolean value) throws IOException {
        this.readNextWord();
        return value;
    }

    private long parseNoArgument(long value) throws IOException {
        this.readNextWord();
        return value;
    }

    private List parseIfCondition(List keepClassSpecifications) throws ParseException, IOException {
        ClassSpecification condition = this.parseClassSpecificationArguments(true, true, false);
        if (this.nextWord == null) {
            throw new ParseException("Expecting '-keep' option after '-if' option, before " + this.reader.locationDescription());
        }
        if ("-keep".startsWith(this.nextWord)) {
            keepClassSpecifications = this.parseKeepClassSpecificationArguments(keepClassSpecifications, true, true, false, false, false, condition);
        } else if ("-keepclassmembers".startsWith(this.nextWord)) {
            keepClassSpecifications = this.parseKeepClassSpecificationArguments(keepClassSpecifications, false, true, false, false, false, condition);
        } else if ("-keepclasseswithmembers".startsWith(this.nextWord)) {
            keepClassSpecifications = this.parseKeepClassSpecificationArguments(keepClassSpecifications, false, true, false, true, false, condition);
        } else if ("-keepnames".startsWith(this.nextWord)) {
            keepClassSpecifications = this.parseKeepClassSpecificationArguments(keepClassSpecifications, true, true, false, false, true, condition);
        } else if ("-keepclassmembernames".startsWith(this.nextWord)) {
            keepClassSpecifications = this.parseKeepClassSpecificationArguments(keepClassSpecifications, false, true, false, false, true, condition);
        } else if ("-keepclasseswithmembernames".startsWith(this.nextWord)) {
            keepClassSpecifications = this.parseKeepClassSpecificationArguments(keepClassSpecifications, false, true, false, true, true, condition);
        } else if ("-keepcode".startsWith(this.nextWord)) {
            keepClassSpecifications = this.parseKeepClassSpecificationArguments(keepClassSpecifications, false, false, true, false, false, condition);
        } else {
            throw new ParseException("Expecting '-keep' option after '-if' option, before " + this.reader.locationDescription());
        }
        return keepClassSpecifications;
    }

    private List parseKeepClassSpecificationArguments(List keepClassSpecifications, boolean markClasses, boolean markMembers, boolean markCodeAttributes, boolean markConditionally, boolean allowShrinking, ClassSpecification condition) throws ParseException, IOException {
        if (keepClassSpecifications == null) {
            keepClassSpecifications = new ArrayList<KeepClassSpecification>();
        }
        keepClassSpecifications.add(this.parseKeepClassSpecificationArguments(markClasses, markMembers, markCodeAttributes, markConditionally, allowShrinking, condition));
        return keepClassSpecifications;
    }

    private KeepClassSpecification parseKeepClassSpecificationArguments(boolean markClasses, boolean markMembers, boolean markCodeAttributes, boolean markConditionally, boolean allowShrinking, ClassSpecification condition) throws ParseException, IOException {
        boolean allowObfuscation;
        boolean allowOptimization;
        boolean markDescriptorClasses;
        block5: {
            markDescriptorClasses = false;
            allowOptimization = false;
            allowObfuscation = false;
            while (true) {
                this.readNextWord("keyword 'class', 'interface', or 'enum'", false, false, true);
                if (!",".equals(this.nextWord)) break block5;
                this.readNextWord("keyword 'allowshrinking', 'allowoptimization', or 'allowobfuscation'");
                if ("includedescriptorclasses".startsWith(this.nextWord)) {
                    markDescriptorClasses = true;
                    continue;
                }
                if ("includecode".startsWith(this.nextWord)) {
                    markCodeAttributes = true;
                    continue;
                }
                if ("allowshrinking".startsWith(this.nextWord)) {
                    allowShrinking = true;
                    continue;
                }
                if ("allowoptimization".startsWith(this.nextWord)) {
                    allowOptimization = true;
                    continue;
                }
                if (!"allowobfuscation".startsWith(this.nextWord)) break;
                allowObfuscation = true;
            }
            throw new ParseException("Expecting keyword 'includedescriptorclasses', 'includecode', 'allowshrinking', 'allowoptimization', or 'allowobfuscation' before " + this.reader.locationDescription());
        }
        ClassSpecification classSpecification = this.parseClassSpecificationArguments(false, true, false);
        return new KeepClassSpecification(markClasses, markMembers, markConditionally, markDescriptorClasses, markCodeAttributes, allowShrinking, allowOptimization, allowObfuscation, condition, classSpecification);
    }

    private List parseAssumeClassSpecificationArguments(List classSpecifications) throws ParseException, IOException {
        if (classSpecifications == null) {
            classSpecifications = new ArrayList<ClassSpecification>();
        }
        classSpecifications.add(this.parseClassSpecificationArguments(true, true, true));
        return classSpecifications;
    }

    private List<ClassSpecification> parseClassSpecificationArguments(List<ClassSpecification> classSpecifications) throws ParseException, IOException {
        if (classSpecifications == null) {
            classSpecifications = new ArrayList<ClassSpecification>();
        }
        classSpecifications.add(this.parseClassSpecificationArguments(true, true, false));
        return classSpecifications;
    }

    public ClassSpecification parseClassSpecificationArguments() throws ParseException, IOException {
        return this.parseClassSpecificationArguments(false, true, false);
    }

    public ClassSpecification parseClassSpecificationArguments(boolean readFirstWord, boolean allowClassMembers, boolean allowValues) throws ParseException, IOException {
        String externalClassName;
        if (readFirstWord) {
            this.readNextWord("keyword 'class', 'interface', or 'enum'", false, false, true);
        }
        String annotationType = null;
        int requiredSetClassAccessFlags = 0;
        int requiredUnsetClassAccessFlags = 0;
        while (!"class".equals(this.nextWord)) {
            int accessFlag;
            String strippedWord;
            boolean negated = this.nextWord.startsWith("!");
            String string = strippedWord = negated ? this.nextWord.substring(1) : this.nextWord;
            int n = strippedWord.equals("public") ? 1 : (strippedWord.equals("final") ? 16 : (strippedWord.equals("interface") ? 512 : (strippedWord.equals("abstract") ? 1024 : (strippedWord.equals("synthetic") ? 4096 : (strippedWord.equals("@") ? 8192 : (accessFlag = strippedWord.equals("enum") ? 16384 : this.unknownAccessFlag()))))));
            if (accessFlag == 8192) {
                this.readNextWord("annotation type or keyword 'interface'", false, false, false);
                if (!(this.nextWord.equals("interface") || this.nextWord.equals("enum") || this.nextWord.equals("class"))) {
                    annotationType = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", false, false, false, false, true, false, false, false, true, null), false);
                    continue;
                }
            }
            if (!negated) {
                requiredSetClassAccessFlags |= accessFlag;
            } else {
                requiredUnsetClassAccessFlags |= accessFlag;
            }
            if ((requiredSetClassAccessFlags & requiredUnsetClassAccessFlags) != 0) {
                throw new ParseException("Conflicting class access modifiers for '" + strippedWord + "' before " + this.reader.locationDescription());
            }
            if (strippedWord.equals("interface") || strippedWord.equals("enum") || strippedWord.equals("class")) break;
            if (accessFlag == 8192) continue;
            this.readNextWord("keyword 'class', 'interface', or 'enum'", false, false, true);
        }
        String className = "*".equals(externalClassName = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", true, false, false, false, true, false, false, false, false, null), false)) ? null : ClassUtil.internalClassName(externalClassName);
        String extendsAnnotationType = null;
        String extendsClassName = null;
        if (allowClassMembers && !this.configurationEnd() && ("implements".equals(this.nextWord) || "extends".equals(this.nextWord))) {
            String externalExtendsClassName;
            this.readNextWord("class name or interface name", false, false, true);
            if ("@".equals(this.nextWord)) {
                extendsAnnotationType = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, false, true, false, false, false, true, null), false);
            }
            extendsClassName = "*".equals(externalExtendsClassName = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", false, false, false, false, true, false, false, false, false, null), false)) ? null : ClassUtil.internalClassName(externalExtendsClassName);
        }
        ClassSpecification classSpecification = new ClassSpecification(this.lastComments, requiredSetClassAccessFlags, requiredUnsetClassAccessFlags, annotationType, className, extendsAnnotationType, extendsClassName);
        if (allowClassMembers && !this.configurationEnd()) {
            if (!"{".equals(this.nextWord)) {
                throw new ParseException("Expecting opening '{' at " + this.reader.locationDescription());
            }
            while (true) {
                this.readNextWord("class member description or closing '}'", false, false, true);
                if (this.nextWord.equals("}")) {
                    classSpecification.memberComments = this.lastComments = this.reader.lastComments();
                    this.readNextWord();
                    break;
                }
                this.parseMemberSpecificationArguments(externalClassName, allowValues, classSpecification);
            }
        }
        return classSpecification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMemberSpecificationArguments(String externalClassName, boolean allowValues, ClassSpecification classSpecification) throws ParseException, IOException {
        String annotationType = null;
        int requiredSetMemberAccessFlags = 0;
        int requiredUnsetMemberAccessFlags = 0;
        while (!this.configurationEnd(true)) {
            int accessFlag;
            String strippedWord;
            if ("@".equals(this.nextWord)) {
                annotationType = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, false, true, false, false, false, true, null), false);
                continue;
            }
            String string = strippedWord = this.nextWord.startsWith("!") ? this.nextWord.substring(1) : this.nextWord;
            int n = strippedWord.equals("public") ? 1 : (strippedWord.equals("private") ? 2 : (strippedWord.equals("protected") ? 4 : (strippedWord.equals("static") ? 8 : (strippedWord.equals("final") ? 16 : (strippedWord.equals("synchronized") ? 32 : (strippedWord.equals("volatile") ? 64 : (strippedWord.equals("transient") ? 128 : (strippedWord.equals("bridge") ? 64 : (strippedWord.equals("varargs") ? 128 : (strippedWord.equals("native") ? 256 : (strippedWord.equals("abstract") ? 1024 : (strippedWord.equals("strictfp") ? 2048 : (accessFlag = strippedWord.equals("synthetic") ? 4096 : 0)))))))))))));
            if (accessFlag == 0) break;
            if (strippedWord.equals(this.nextWord)) {
                requiredSetMemberAccessFlags |= accessFlag;
            } else {
                requiredUnsetMemberAccessFlags |= accessFlag;
            }
            if ((requiredSetMemberAccessFlags & requiredUnsetMemberAccessFlags) != 0) {
                throw new ParseException("Conflicting class member access modifiers for " + this.reader.locationDescription());
            }
            this.readNextWord("class member description");
        }
        if ("*".equals(this.nextWord) || "<fields>".equals(this.nextWord) || "<methods>".equals(this.nextWord)) {
            if ("*".equals(this.nextWord)) {
                this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                this.checkMethodAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                classSpecification.addField(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
                classSpecification.addMethod(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
            } else if ("<fields>".equals(this.nextWord)) {
                this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                classSpecification.addField(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
            } else if ("<methods>".equals(this.nextWord)) {
                this.checkMethodAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                classSpecification.addMethod(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
            }
            this.readNextWord("separator ';'");
            if (";".equals(this.nextWord)) return;
            throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
        }
        this.checkJavaIdentifier("java type");
        String type = this.nextWord;
        String typeLocation = this.reader.locationDescription();
        this.readNextWord("class member name");
        String name = this.nextWord;
        if ("(".equals(name)) {
            if (!(type.equals("<init>") || type.equals(externalClassName) || type.equals(ClassUtil.externalShortClassName(externalClassName)))) {
                throw new ParseException("Expecting type and name instead of just '" + type + "' before " + this.reader.locationDescription());
            }
            type = "void";
            name = "<init>";
        } else {
            this.checkJavaIdentifier("class member name");
            this.readNextWord("opening '(' or separator ';'");
        }
        if (this.containsGenerics(type)) {
            throw new ParseException("Generics are not allowed (erased) for java type" + typeLocation);
        }
        if (";".equals(this.nextWord)) {
            this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
            String descriptor = ClassUtil.internalType(type);
            if ("<fields>".equals(name)) {
                throw new ParseException("Not expecting field type before with wildcard '<fields>before " + this.reader.locationDescription() + " (use '" + "*" + "' instead)");
            }
            classSpecification.addField(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, name, descriptor));
            return;
        } else if (allowValues && ("=".equals(this.nextWord) || "return".equals(this.nextWord))) {
            this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
            String descriptor = ClassUtil.internalType(type);
            Number[] values2 = this.parseValues(type, descriptor);
            this.readNextWord("separator ';'");
            if (!";".equals(this.nextWord)) {
                throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
            }
            classSpecification.addField(new MemberValueSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, name, descriptor, values2));
            return;
        } else {
            if (!"(".equals(this.nextWord)) throw new ParseException("Expecting opening '(' or separator ';' before " + this.reader.locationDescription());
            this.checkMethodAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
            String descriptor = ClassUtil.internalMethodDescriptor(type, this.parseCommaSeparatedList("argument", true, true, true, false, true, false, false, false, false, null));
            if (!")".equals(this.nextWord)) {
                throw new ParseException("Expecting separating ',' or closing ')' before " + this.reader.locationDescription());
            }
            this.readNextWord("separator ';'");
            if (";".equals(this.nextWord)) {
                if ("<methods>".equals(name)) {
                    throw new ParseException("Not expecting method descriptor with wildcard '<methods>before " + this.reader.locationDescription() + " (use '" + "*" + "' instead)");
                }
                classSpecification.addMethod(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, name, descriptor));
                return;
            } else {
                if (!allowValues || !"=".equals(this.nextWord) && !"return".equals(this.nextWord)) throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
                this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                Number[] values3 = this.parseValues(type, ClassUtil.internalType(type));
                this.readNextWord("separator ';'");
                if (!";".equals(this.nextWord)) {
                    throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
                }
                classSpecification.addMethod(new MemberValueSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, name, descriptor, values3));
            }
        }
    }

    private Number[] parseValues(String externalType, String internalType) throws ParseException, IOException {
        Number[] numberArray;
        this.readNextWord(externalType + " constant");
        int rangeIndex = this.nextWord.indexOf("..");
        if (rangeIndex >= 0) {
            Number[] numberArray2 = new Number[2];
            numberArray2[0] = this.parseValue(externalType, internalType, this.nextWord.substring(0, rangeIndex));
            numberArray = numberArray2;
            numberArray2[1] = this.parseValue(externalType, internalType, this.nextWord.substring(rangeIndex + "..".length()));
        } else {
            Number[] numberArray3 = new Number[1];
            numberArray = numberArray3;
            numberArray3[0] = this.parseValue(externalType, internalType, this.nextWord);
        }
        return numberArray;
    }

    private Number parseValue(String externalType, String internalType, String string) throws ParseException {
        try {
            string = this.replaceSystemProperties(string);
            switch (internalType.charAt(0)) {
                case 'Z': {
                    return this.parseBoolean(string);
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': {
                    return Integer.decode(string);
                }
            }
            throw new ParseException("Can't handle '" + externalType + "' constant " + this.reader.locationDescription());
        }
        catch (NumberFormatException e) {
            throw new ParseException("Can't parse " + externalType + " constant " + this.reader.locationDescription());
        }
    }

    private Integer parseBoolean(String string) throws ParseException {
        if ("false".equals(this.nextWord)) {
            return 0;
        }
        if ("true".equals(this.nextWord)) {
            return 1;
        }
        throw new ParseException("Unknown boolean constant " + this.reader.locationDescription());
    }

    private List parseCommaSeparatedLists(String expectedDescription, boolean readFirstWord, boolean allowEmptyList, boolean expectClosingParenthesis, boolean isFileName, boolean checkJavaIdentifiers, boolean allowGenerics, boolean replaceSystemProperties, boolean replaceExternalClassNames, boolean replaceExternalTypes, List list) throws ParseException, IOException {
        if (list == null) {
            list = new ArrayList<List>();
        }
        list.add(this.parseCommaSeparatedList(expectedDescription, readFirstWord, allowEmptyList, expectClosingParenthesis, isFileName, checkJavaIdentifiers, allowGenerics, replaceSystemProperties, replaceExternalClassNames, replaceExternalTypes, null));
        return list;
    }

    private List parseCommaSeparatedList(String expectedDescription, boolean readFirstWord, boolean allowEmptyList, boolean expectClosingParenthesis, boolean isFileName, boolean checkJavaIdentifiers, boolean allowGenerics, boolean replaceSystemProperties, boolean replaceExternalClassNames, boolean replaceExternalTypes, List list) throws ParseException, IOException {
        return this.parseCommaSeparatedList(expectedDescription, readFirstWord, allowEmptyList, null, expectClosingParenthesis, isFileName, checkJavaIdentifiers, allowGenerics, replaceSystemProperties, replaceExternalClassNames, replaceExternalTypes, list);
    }

    private List parseCommaSeparatedList(String expectedDescription, boolean readFirstWord, boolean allowEmptyList, String defaultIfEmpty, boolean expectClosingParenthesis, boolean isFileName, boolean checkJavaIdentifiers, boolean allowGenerics, boolean replaceSystemProperties, boolean replaceExternalClassNames, boolean replaceExternalTypes, List list) throws ParseException, IOException {
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (readFirstWord) {
            if (!allowEmptyList) {
                this.readNextWord(expectedDescription, isFileName, true, false);
            } else if (expectClosingParenthesis) {
                this.readNextWord(expectedDescription, isFileName, true, false);
                if (this.nextWord.length() == 0) {
                    this.readNextWord("closing ')'");
                    if (defaultIfEmpty != null) {
                        list.add(defaultIfEmpty);
                    }
                    return list;
                }
                if (this.nextWord.equals(")")) {
                    if (defaultIfEmpty != null) {
                        list.add(defaultIfEmpty);
                    }
                    return list;
                }
            } else {
                this.readNextWord(isFileName, true);
                if (this.configurationEnd()) {
                    if (defaultIfEmpty != null) {
                        list.add(defaultIfEmpty);
                    }
                    return list;
                }
            }
        }
        while (true) {
            if (checkJavaIdentifiers) {
                this.checkJavaIdentifier("java type", allowGenerics);
            }
            if (replaceSystemProperties) {
                this.nextWord = this.replaceSystemProperties(this.nextWord);
            }
            if (replaceExternalClassNames) {
                this.nextWord = ClassUtil.internalClassName(this.nextWord);
            }
            if (replaceExternalTypes) {
                this.nextWord = ClassUtil.internalType(this.nextWord);
            }
            list.add(this.nextWord);
            if (expectClosingParenthesis) {
                this.readNextWord("separating ',' or closing ')'");
            } else {
                this.readNextWord();
            }
            if (!",".equals(this.nextWord)) {
                return list;
            }
            this.readNextWord(expectedDescription, isFileName, true, false);
        }
    }

    private ClassSpecification convertToClassSpecification(List<String> list) {
        return new ClassSpecification(null, 0, 0, null, StringUtil.join(",", list.toArray(new String[list.size()])), null, null);
    }

    private ClassSpecification removeMemberSpecification(ClassSpecification classSpecification) {
        classSpecification.fieldSpecifications = null;
        classSpecification.methodSpecifications = null;
        return classSpecification;
    }

    private int unknownAccessFlag() throws ParseException {
        throw new ParseException("Unexpected keyword " + this.reader.locationDescription());
    }

    private URL url(String word) throws ParseException, MalformedURLException {
        String fileName = this.replaceSystemProperties(word);
        try {
            URL url = new URL(fileName);
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            URL url;
            URL baseURL = this.reader.getBaseURL();
            if (baseURL != null) {
                url = new URL(baseURL, fileName);
            } else {
                url = ConfigurationParser.class.getResource(fileName);
                if (url == null) {
                    File file = new File(fileName);
                    if (!file.isAbsolute()) {
                        file = new File(this.reader.getBaseDir(), fileName);
                    }
                    url = file.toURI().toURL();
                }
            }
            return url;
        }
    }

    private File file(String word) throws ParseException {
        String fileName = this.replaceSystemProperties(word);
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(this.reader.getBaseDir(), fileName);
        }
        return file;
    }

    private String replaceSystemProperties(String word) throws ParseException {
        int toIndex;
        int fromIndex = 0;
        while ((fromIndex = word.indexOf(60, fromIndex)) >= 0 && (toIndex = word.indexOf(62, fromIndex + 1)) >= 0) {
            String propertyName = word.substring(fromIndex + 1, toIndex);
            String propertyValue = this.properties.getProperty(propertyName);
            if (propertyValue == null) {
                try {
                    Integer.parseInt(propertyName);
                    fromIndex = toIndex + 1;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Value of system property '" + propertyName + "' is undefined in " + this.reader.locationDescription());
                }
            }
            word = word.substring(0, fromIndex) + propertyValue + word.substring(toIndex + 1);
            fromIndex += propertyValue.length();
        }
        return word;
    }

    private void readNextWord(String expectedDescription) throws ParseException, IOException {
        this.readNextWord(expectedDescription, false, false, false);
    }

    private void readNextWord(String expectedDescription, boolean isFileName, boolean expectSingleFile, boolean expectingAtCharacter) throws ParseException, IOException {
        this.readNextWord(isFileName, expectSingleFile);
        if (this.configurationEnd(expectingAtCharacter)) {
            throw new ParseException("Expecting " + expectedDescription + " before " + this.reader.locationDescription());
        }
    }

    private void readNextWord() throws IOException {
        this.readNextWord(false, false);
    }

    private void readNextWord(boolean isFileName, boolean expectSingleFile) throws IOException {
        this.nextWord = this.reader.nextWord(isFileName, expectSingleFile);
    }

    private boolean configurationEnd() {
        return this.configurationEnd(false);
    }

    private boolean configurationEnd(boolean expectingAtCharacter) {
        return this.nextWord == null || this.nextWord.startsWith("-") || !expectingAtCharacter && this.nextWord.equals("@");
    }

    private void checkJavaIdentifier(String expectedDescription) throws ParseException {
        this.checkJavaIdentifier(expectedDescription, true);
    }

    private void checkJavaIdentifier(String expectedDescription, boolean allowGenerics) throws ParseException {
        if (!this.isJavaIdentifier(this.nextWord)) {
            throw new ParseException("Expecting " + expectedDescription + " before " + this.reader.locationDescription());
        }
        if (!allowGenerics && this.containsGenerics(this.nextWord)) {
            throw new ParseException("Generics are not allowed (erased) in " + expectedDescription + " " + this.reader.locationDescription());
        }
    }

    private boolean isJavaIdentifier(String word) {
        if (word.length() == 0) {
            return false;
        }
        for (int index = 0; index < word.length(); ++index) {
            char c = word.charAt(index);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']' || c == '<' || c == '>' || c == '-' || c == '!' || c == '*' || c == '?' || c == '%') continue;
            return false;
        }
        return true;
    }

    private boolean containsGenerics(String word) {
        int index = 0;
        int openIndex;
        while ((openIndex = word.indexOf(60, index)) >= 0) {
            int closeIndex = word.indexOf(62, openIndex + 1);
            if (closeIndex < 0) {
                return false;
            }
            try {
                Integer.parseInt(word.substring(openIndex + 1, closeIndex));
            }
            catch (NumberFormatException e) {
                return true;
            }
            index = closeIndex + 1;
        }
        return false;
    }

    private void checkFieldAccessFlags(int requiredSetMemberAccessFlags, int requiredUnsetMemberAccessFlags) throws ParseException {
        if (((requiredSetMemberAccessFlags | requiredUnsetMemberAccessFlags) & 0xFFFFAF20) != 0) {
            throw new ParseException("Invalid method access modifier for field before " + this.reader.locationDescription());
        }
    }

    private void checkMethodAccessFlags(int requiredSetMemberAccessFlags, int requiredUnsetMemberAccessFlags) throws ParseException {
        if (((requiredSetMemberAccessFlags | requiredUnsetMemberAccessFlags) & 0xFFFFE200) != 0) {
            throw new ParseException("Invalid field access modifier for method before " + this.reader.locationDescription());
        }
    }

    public static void main(String[] args) {
        try (ConfigurationParser parser = new ConfigurationParser(args, System.getProperties());){
            parser.parse(new Configuration());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

