/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this.parse(parameterList);
    }

    protected void parse(String parameterList) throws MimeTypeParseException {
        char c;
        if (parameterList == null) {
            return;
        }
        int length = parameterList.length();
        if (length <= 0) {
            return;
        }
        int i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, 0);
        while (i2 < length && (c = parameterList.charAt(i2)) == ';') {
            String value;
            ++i2;
            if ((i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2)) >= length) {
                return;
            }
            int lastIndex = i2;
            while (i2 < length && MimeTypeParameterList.isTokenChar(parameterList.charAt(i2))) {
                ++i2;
            }
            String name = parameterList.substring(lastIndex, i2).toLowerCase(Locale.ENGLISH);
            if ((i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2)) >= length || parameterList.charAt(i2) != '=') {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            ++i2;
            if ((i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2)) >= length) {
                throw new MimeTypeParseException("Couldn't find a value for parameter named " + name);
            }
            c = parameterList.charAt(i2);
            if (c == '\"') {
                if (++i2 >= length) {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                lastIndex = i2;
                while (i2 < length && (c = parameterList.charAt(i2)) != '\"') {
                    if (c == '\\') {
                        ++i2;
                    }
                    ++i2;
                }
                if (c != '\"') {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                value = MimeTypeParameterList.unquote(parameterList.substring(lastIndex, i2));
                ++i2;
            } else if (MimeTypeParameterList.isTokenChar(c)) {
                lastIndex = i2;
                while (i2 < length && MimeTypeParameterList.isTokenChar(parameterList.charAt(i2))) {
                    ++i2;
                }
                value = parameterList.substring(lastIndex, i2);
            } else {
                throw new MimeTypeParseException("Unexpected character encountered at index " + i2);
            }
            this.parameters.put(name, value);
            i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2);
        }
        if (i2 < length) {
            throw new MimeTypeParseException("More characters encountered in input than expected.");
        }
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String name) {
        return (String)this.parameters.get(name.trim().toLowerCase(Locale.ENGLISH));
    }

    public void set(String name, String value) {
        this.parameters.put(name.trim().toLowerCase(Locale.ENGLISH), value);
    }

    public void remove(String name) {
        this.parameters.remove(name.trim().toLowerCase(Locale.ENGLISH));
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration keys2 = this.parameters.keys();
        while (keys2.hasMoreElements()) {
            String key = (String)keys2.nextElement();
            buffer.append("; ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote((String)this.parameters.get(key)));
        }
        return buffer.toString();
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static int skipWhiteSpace(String rawdata, int i2) {
        int length = rawdata.length();
        while (i2 < length && Character.isWhitespace(rawdata.charAt(i2))) {
            ++i2;
        }
        return i2;
    }

    private static String quote(String value) {
        boolean needsQuotes = false;
        int length = value.length();
        for (int i2 = 0; i2 < length && !needsQuotes; ++i2) {
            needsQuotes = !MimeTypeParameterList.isTokenChar(value.charAt(i2));
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer();
            buffer.ensureCapacity((int)((double)length * 1.5));
            buffer.append('\"');
            for (int i3 = 0; i3 < length; ++i3) {
                char c = value.charAt(i3);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value;
    }

    private static String unquote(String value) {
        int valueLength = value.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(valueLength);
        boolean escaped = false;
        for (int i2 = 0; i2 < valueLength; ++i2) {
            char currentChar = value.charAt(i2);
            if (!escaped && currentChar != '\\') {
                buffer.append(currentChar);
                continue;
            }
            if (escaped) {
                buffer.append(currentChar);
                escaped = false;
                continue;
            }
            escaped = true;
        }
        return buffer.toString();
    }
}

