/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TObjectByteHashMap;
import gnu.trove.TObjectByteIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectByteHashMapDecorator<V>
extends AbstractMap<V, Byte>
implements Map<V, Byte> {
    protected final TObjectByteHashMap<V> _map;

    public TObjectByteHashMapDecorator(TObjectByteHashMap<V> map2) {
        this._map = map2;
    }

    @Override
    public Byte put(V key, Byte value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (val instanceof Byte) {
                    V k = this.unwrapKey(key);
                    byte v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        V k = this.unwrapKey(key);
        byte v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Byte remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<V, Byte>> entrySet() {
        return new AbstractSet<Map.Entry<V, Byte>>(){

            @Override
            public int size() {
                return TObjectByteHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TObjectByteHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TObjectByteHashMapDecorator.this.containsKey(k) && TObjectByteHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<V, Byte>> iterator() {
                return new Iterator<Map.Entry<V, Byte>>(){
                    private final TObjectByteIterator<V> it;
                    {
                        this.it = TObjectByteHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<V, Byte> next() {
                        this.it.advance();
                        final Object key = TObjectByteHashMapDecorator.this.wrapKey(this.it.key());
                        final Byte v = TObjectByteHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<V, Byte>(){
                            private Byte val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public V getKey() {
                                return key;
                            }

                            @Override
                            public Byte getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Byte setValue(Byte value) {
                                this.val = value;
                                return TObjectByteHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<V, Byte> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<V, Byte>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TObjectByteHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends V, ? extends Byte> map2) {
        Iterator<Map.Entry<V, Byte>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<V, Byte> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected final V wrapKey(Object o) {
        return (V)o;
    }

    protected final V unwrapKey(Object key) {
        return (V)key;
    }

    protected Byte wrapValue(byte k) {
        return new Byte(k);
    }

    protected byte unwrapValue(Object value) {
        return (Byte)value;
    }
}

