/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TFloatHashSet;
import gnu.trove.TFloatIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatHashSetDecorator
extends AbstractSet<Float>
implements Set<Float> {
    protected final TFloatHashSet _set;

    public TFloatHashSetDecorator(TFloatHashSet set) {
        this._set = set;
    }

    @Override
    public boolean add(Float value) {
        return this._set.add(this.unwrap(value));
    }

    @Override
    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Object val = it.next();
                if (val instanceof Float) {
                    float v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            private final TFloatIterator it;
            {
                this.it = TFloatHashSetDecorator.this._set.iterator();
            }

            @Override
            public Float next() {
                return TFloatHashSetDecorator.this.wrap(this.it.next());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Float wrap(float k) {
        return new Float(k);
    }

    protected float unwrap(Object value) {
        return ((Float)value).floatValue();
    }
}

