/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntIterator;
import gnu.trove.TObjectIntProcedure;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectIntHashMap<K>
extends TObjectHash<K> {
    protected transient int[] _values;

    public TObjectIntHashMap() {
    }

    public TObjectIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectIntHashMap(TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    public TObjectIntHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectIntHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectIntIterator<K> iterator() {
        return new TObjectIntIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new int[capacity];
        return capacity;
    }

    public int put(K key, int value) {
        int previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        Object[] oldKeys = this._set;
        int[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new int[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (oldKeys[i2] == null || oldKeys[i2] == REMOVED) continue;
            Object o = oldKeys[i2];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i2];
        }
    }

    public int get(K key) {
        int index = this.index(key);
        return index < 0 ? 0 : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys2 = this._set;
        int[] values2 = this._values;
        int i2 = keys2.length;
        while (i2-- > 0) {
            keys2[i2] = null;
            values2[i2] = 0;
        }
    }

    public int remove(K key) {
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectIntHashMap)) {
            return false;
        }
        TObjectIntHashMap that = (TObjectIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = 0;
        super.removeAt(index);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        Object[] keys2 = this._set;
        int i2 = keys2.length;
        int j = 0;
        while (i2-- > 0) {
            if (keys2[i2] == null || keys2[i2] == REMOVED) continue;
            vals[j++] = v[i2];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys2 = new Object[this.size()];
        Object[] k = this._set;
        int i2 = k.length;
        int j = 0;
        while (i2-- > 0) {
            if (k[i2] == null || k[i2] == REMOVED) continue;
            keys2[j++] = k[i2];
        }
        return keys2;
    }

    public boolean containsValue(int val) {
        Object[] keys2 = this._set;
        int[] vals = this._values;
        int i2 = keys2.length;
        while (i2-- > 0) {
            if (keys2[i2] == null || keys2[i2] == REMOVED || val != vals[i2]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        Object[] keys2 = this._set;
        int[] values2 = this._values;
        int i2 = keys2.length;
        while (i2-- > 0) {
            if (keys2[i2] == null || keys2[i2] == REMOVED || procedure.execute(values2[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectIntProcedure<K> procedure) {
        Object[] keys2 = this._set;
        int[] values2 = this._values;
        int i2 = keys2.length;
        while (i2-- > 0) {
            if (keys2[i2] == null || keys2[i2] == REMOVED || procedure.execute(keys2[i2], values2[i2])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TObjectIntProcedure<K> procedure) {
        boolean modified = false;
        Object[] keys2 = this._set;
        int[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i2 = keys2.length;
            while (i2-- > 0) {
                if (keys2[i2] == null || keys2[i2] == REMOVED || procedure.execute(keys2[i2], values2[i2])) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        Object[] keys2 = this._set;
        int[] values2 = this._values;
        int i2 = keys2.length;
        while (i2-- > 0) {
            if (keys2[i2] == null || keys2[i2] == REMOVED) continue;
            values2[i2] = function.execute(values2[i2]);
        }
    }

    public boolean increment(K key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(K key, int amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = stream.readObject();
            int val = stream.readInt();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TObjectIntProcedure<K>(){

            @Override
            public boolean execute(K key, int value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append((Object)(key == this ? "(this Map)" : key));
                sb.append('=');
                sb.append(value);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TObjectIntProcedure<K> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public boolean execute(K key, int value) {
            this.h += TObjectIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<K>
    implements TObjectIntProcedure<K> {
        private final TObjectIntHashMap<K> _otherMap;

        EqProcedure(TObjectIntHashMap<K> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(K key, int value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }
}

