/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectDoubleHashMap;
import gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TObjectDoubleIterator<K>
extends TIterator {
    private final TObjectDoubleHashMap<K> _map;

    public TObjectDoubleIterator(TObjectDoubleHashMap<K> map2) {
        super(map2);
        this._map = map2;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i2 = this._index;
        while (i2-- > 0 && (set[i2] == null || set[i2] == TObjectHash.REMOVED)) {
        }
        return i2;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public double value() {
        return this._map._values[this._index];
    }

    public double setValue(double val) {
        double old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

