/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatObjectIterator;
import gnu.trove.TFloatObjectProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.THash;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatObjectHashMap<V>
extends THash
implements TFloatHashingStrategy {
    protected transient V[] _values;
    protected transient float[] _set;
    protected final TFloatHashingStrategy _hashingStrategy;

    public TFloatObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(TFloatHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TFloatObjectHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TFloatObjectHashMap<V> clone() {
        TFloatObjectHashMap m3 = (TFloatObjectHashMap)super.clone();
        m3._values = this._values == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._values.clone();
        m3._set = this._values == EMPTY_OBJECT_ARRAY ? null : (float[])this._set.clone();
        return m3;
    }

    public TFloatObjectIterator<V> iterator() {
        return new TFloatObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        this._set = initialCapacity == -1 ? null : new float[capacity];
        return capacity;
    }

    public boolean contains(float val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TFloatProcedure procedure) {
        float[] set = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i2) || procedure.execute(set[i2])) continue;
            return false;
        }
        return true;
    }

    public V put(float key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TFloatObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TFloatObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        this._values[index] = TFloatObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new float[newCapacity];
        this._values = new Object[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (!TFloatObjectHashMap.isFull(oldVals, i2)) continue;
            float o = oldKeys[i2];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i2];
        }
    }

    public V get(float key) {
        int index = this.index(key);
        return index < 0 ? null : (V)TFloatObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        float[] keys2 = this._set;
        V[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            keys2[i2] = 0.0f;
            values2[i2] = null;
        }
    }

    public V remove(float key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = TFloatObjectHashMap.unwrapNull(this._values[index]);
            this.removeAt(index);
        }
        return prev;
    }

    protected int index(float val) {
        float[] set = this._set;
        Object[] values2 = this._values;
        if (values2 == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TFloatObjectHashMap.isFree(values2, index) && (TFloatObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TFloatObjectHashMap.isFree(values2, index) && (TFloatObjectHashMap.isRemoved(values2, index) || set[index] != val));
        }
        return TFloatObjectHashMap.isFree(values2, index) ? -1 : index;
    }

    protected int insertionIndex(float val) {
        int firstRemoved;
        if (this._values == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] values2 = this._values;
        float[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TFloatObjectHashMap.isFree(values2, index)) {
            return index;
        }
        if (TFloatObjectHashMap.isFull(values2, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TFloatObjectHashMap.isRemoved(values2, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TFloatObjectHashMap.isRemoved(values2, index)) continue;
            firstRemoved = index;
        } while (TFloatObjectHashMap.isFull(values2, index) && set[index] != val);
        if (TFloatObjectHashMap.isRemoved(values2, index)) {
            while (!TFloatObjectHashMap.isFree(values2, index) && (TFloatObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TFloatObjectHashMap.isFull(values2, index)) {
            return -index - 1;
        }
        return firstRemoved == -1 ? index : firstRemoved;
    }

    static boolean isFull(Object[] values2, int index) {
        Object value = values2[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values2, int index) {
        return values2[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values2, int index) {
        return values2[index] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatObjectHashMap)) {
            return false;
        }
        TFloatObjectHashMap that = (TFloatObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values2 = this._values;
        int i2 = values2.length;
        int j = 0;
        while (i2-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i2)) continue;
            vals[j++] = TFloatObjectHashMap.unwrapNull(values2[i2]);
        }
        return vals;
    }

    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        int j = 0;
        while (i2-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i2)) continue;
            keys2[j++] = k[i2];
        }
        return keys2;
    }

    public boolean containsValue(V val) {
        Object[] values2 = this._values;
        if (null == val) {
            int i2 = values2.length;
            while (i2-- > 0) {
                if (TObjectHash.NULL != values2[i2]) continue;
                return true;
            }
        } else {
            int i3 = values2.length;
            while (i3-- > 0) {
                V value = TFloatObjectHashMap.unwrapNull(values2[i3]);
                if (!TFloatObjectHashMap.isFull(values2, i3) || val != value && !val.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i2) || procedure.execute(TFloatObjectHashMap.unwrapNull(values2[i2]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatObjectProcedure<V> procedure) {
        float[] keys2 = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i2) || procedure.execute(keys2[i2], TFloatObjectHashMap.unwrapNull(values2[i2]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TFloatObjectProcedure<V> procedure) {
        boolean modified = false;
        float[] keys2 = this._set;
        Object[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i2 = values2.length;
            while (i2-- > 0) {
                if (!TFloatObjectHashMap.isFull(values2, i2) || procedure.execute(keys2[i2], TFloatObjectHashMap.unwrapNull(values2[i2]))) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i2)) continue;
            values2[i2] = TFloatObjectHashMap.wrapNull(function.execute(TFloatObjectHashMap.unwrapNull(values2[i2])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final int computeHashCode(float val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatObjectProcedure<V>(){

            @Override
            public boolean execute(float key, V value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<V>
    implements TFloatObjectProcedure<V> {
        private final TFloatObjectHashMap<V> _otherMap;

        EqProcedure(TFloatObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(float key, V value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TFloatObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(float key, V value) {
            this.h += TFloatObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

