/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleObjectIterator;
import gnu.trove.TDoubleObjectProcedure;
import gnu.trove.TDoubleProcedure;
import gnu.trove.THash;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDoubleObjectHashMap<V>
extends THash
implements TDoubleHashingStrategy {
    protected transient V[] _values;
    protected transient double[] _set;
    protected final TDoubleHashingStrategy _hashingStrategy;

    public TDoubleObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TDoubleObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TDoubleObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TDoubleObjectHashMap(TDoubleHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TDoubleObjectHashMap(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TDoubleObjectHashMap(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TDoubleObjectHashMap<V> clone() {
        TDoubleObjectHashMap m3 = (TDoubleObjectHashMap)super.clone();
        m3._values = this._values == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._values.clone();
        m3._set = this._values == EMPTY_OBJECT_ARRAY ? null : (double[])this._set.clone();
        return m3;
    }

    public TDoubleObjectIterator<V> iterator() {
        return new TDoubleObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        this._set = initialCapacity == -1 ? null : new double[capacity];
        return capacity;
    }

    public boolean contains(double val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        double[] set = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values2, i2) || procedure.execute(set[i2])) continue;
            return false;
        }
        return true;
    }

    public V put(double key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TDoubleObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TDoubleObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        this._values[index] = TDoubleObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        double[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new double[newCapacity];
        this._values = new Object[newCapacity];
        int i2 = oldCapacity;
        while (i2-- > 0) {
            if (!TDoubleObjectHashMap.isFull(oldVals, i2)) continue;
            double o = oldKeys[i2];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i2];
        }
    }

    public V get(double key) {
        int index = this.index(key);
        return index < 0 ? null : (V)TDoubleObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        double[] keys2 = this._set;
        V[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            keys2[i2] = 0.0;
            values2[i2] = null;
        }
    }

    public V remove(double key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = TDoubleObjectHashMap.unwrapNull(this._values[index]);
            this.removeAt(index);
        }
        return prev;
    }

    protected int index(double val) {
        double[] set = this._set;
        Object[] values2 = this._values;
        if (values2 == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TDoubleObjectHashMap.isFree(values2, index) && (TDoubleObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TDoubleObjectHashMap.isFree(values2, index) && (TDoubleObjectHashMap.isRemoved(values2, index) || set[index] != val));
        }
        return TDoubleObjectHashMap.isFree(values2, index) ? -1 : index;
    }

    protected int insertionIndex(double val) {
        int firstRemoved;
        if (this._values == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] values2 = this._values;
        double[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TDoubleObjectHashMap.isFree(values2, index)) {
            return index;
        }
        if (TDoubleObjectHashMap.isFull(values2, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TDoubleObjectHashMap.isRemoved(values2, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TDoubleObjectHashMap.isRemoved(values2, index)) continue;
            firstRemoved = index;
        } while (TDoubleObjectHashMap.isFull(values2, index) && set[index] != val);
        if (TDoubleObjectHashMap.isRemoved(values2, index)) {
            while (!TDoubleObjectHashMap.isFree(values2, index) && (TDoubleObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TDoubleObjectHashMap.isFull(values2, index)) {
            return -index - 1;
        }
        return firstRemoved == -1 ? index : firstRemoved;
    }

    static boolean isFull(Object[] values2, int index) {
        Object value = values2[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values2, int index) {
        return values2[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values2, int index) {
        return values2[index] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleObjectHashMap)) {
            return false;
        }
        TDoubleObjectHashMap that = (TDoubleObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values2 = this._values;
        int i2 = values2.length;
        int j = 0;
        while (i2-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values2, i2)) continue;
            vals[j++] = TDoubleObjectHashMap.unwrapNull(values2[i2]);
        }
        return vals;
    }

    public double[] keys() {
        double[] keys2 = new double[this.size()];
        double[] k = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        int j = 0;
        while (i2-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values2, i2)) continue;
            keys2[j++] = k[i2];
        }
        return keys2;
    }

    public boolean containsValue(V val) {
        Object[] values2 = this._values;
        if (null == val) {
            int i2 = values2.length;
            while (i2-- > 0) {
                if (TObjectHash.NULL != values2[i2]) continue;
                return true;
            }
        } else {
            int i3 = values2.length;
            while (i3-- > 0) {
                V value = TDoubleObjectHashMap.unwrapNull(values2[i3]);
                if (!TDoubleObjectHashMap.isFull(values2, i3) || val != value && !val.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(double key) {
        return this.contains(key);
    }

    public boolean forEachKey(TDoubleProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values2, i2) || procedure.execute(TDoubleObjectHashMap.unwrapNull(values2[i2]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TDoubleObjectProcedure<V> procedure) {
        double[] keys2 = this._set;
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values2, i2) || procedure.execute(keys2[i2], TDoubleObjectHashMap.unwrapNull(values2[i2]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TDoubleObjectProcedure<V> procedure) {
        boolean modified = false;
        double[] keys2 = this._set;
        Object[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i2 = values2.length;
            while (i2-- > 0) {
                if (!TDoubleObjectHashMap.isFull(values2, i2) || procedure.execute(keys2[i2], TDoubleObjectHashMap.unwrapNull(values2[i2]))) continue;
                this.removeAt(i2);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values2 = this._values;
        int i2 = values2.length;
        while (i2-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values2, i2)) continue;
            values2[i2] = TDoubleObjectHashMap.wrapNull(function.execute(TDoubleObjectHashMap.unwrapNull(values2[i2])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            double key = stream.readDouble();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final int computeHashCode(double val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TDoubleObjectProcedure<V>(){

            @Override
            public boolean execute(double key, V value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<V>
    implements TDoubleObjectProcedure<V> {
        private final TDoubleObjectHashMap<V> _otherMap;

        EqProcedure(TDoubleObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(double key, V value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TDoubleObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(double key, V value) {
            this.h += TDoubleObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

