/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TDoubleArrayList
implements Serializable,
Cloneable {
    protected transient double[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public TDoubleArrayList() {
    }

    public TDoubleArrayList(int capacity) {
        this._data = new double[capacity];
        this._pos = 0;
    }

    public TDoubleArrayList(double[] values2) {
        this(Math.max(values2.length, 4));
        this.add(values2);
    }

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new double[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            double[] tmp = new double[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data != null && this._data.length > this.size()) {
            double[] tmp = new double[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(double val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(double[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(double[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, double value) {
        if (offset == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value;
        ++this._pos;
    }

    public void insert(int offset, double[] values2) {
        this.insert(offset, values2, 0, values2.length);
    }

    public void insert(int offset, double[] values2, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values2, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public double get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[offset];
    }

    public double getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, double val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public double getSet(int offset, double val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        double old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, double[] values2) {
        this.set(offset, values2, 0, values2.length);
    }

    public void set(int offset, double[] values2, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, values2, valOffset, length);
    }

    public void setQuick(int offset, double val) {
        this._data[offset] = val;
    }

    public void clear() {
        this._data = null;
        this._pos = 0;
    }

    public void clear(int capacity) {
        this._data = new double[capacity];
        this._pos = 0;
    }

    public void reset() {
        this.fill(0.0);
        this._pos = 0;
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public double remove(int offset) {
        double old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void transformValues(TDoubleFunction function) {
        int i2 = this._pos;
        while (i2-- > 0) {
            this._data[i2] = function.execute(this._data[i2]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i2 = from;
        for (int j = to - 1; i2 < j; ++i2, --j) {
            this.swap(i2, j);
        }
    }

    public void shuffle(Random rand) {
        int i2 = this._pos;
        while (i2-- > 1) {
            this.swap(i2, rand.nextInt(i2));
        }
    }

    private void swap(int i2, int j) {
        double tmp = this._data[i2];
        this._data[i2] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TDoubleArrayList clone = null;
        try {
            clone = (TDoubleArrayList)super.clone();
            clone._data = this._data == null ? null : (double[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public double[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public double[] toNativeArray(int offset, int len) {
        double[] rv = new double[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(double[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TDoubleArrayList) {
            TDoubleArrayList that = (TDoubleArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i2 = this._pos;
            while (i2-- > 0) {
                if (this._data[i2] == that._data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h2 = 0;
        int i2 = this._pos;
        while (i2-- > 0) {
            h2 += HashFunctions.hash(this._data[i2]);
        }
        return h2;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TDoubleProcedure procedure) {
        int i2 = this._pos;
        while (i2-- > 0) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, 0, this._pos);
        }
    }

    public void sort(int fromIndex, int toIndex) {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, fromIndex, toIndex);
        }
    }

    public void fill(double val) {
        if (!this.isEmpty()) {
            Arrays.fill(this._data, 0, this._pos, val);
        }
    }

    public void fill(int fromIndex, int toIndex, double val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        if (!this.isEmpty()) {
            Arrays.fill(this._data, fromIndex, toIndex, val);
        }
    }

    public int binarySearch(double value) {
        return this.binarySearch(value, 0, this._pos);
    }

    public int binarySearch(double value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = this._data[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(double value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset, double value) {
        for (int i2 = offset; i2 < this._pos; ++i2) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(double value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset, double value) {
        int i2 = offset;
        while (i2-- > 0) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public boolean contains(double value) {
        return this.lastIndexOf(value) >= 0;
    }

    public TDoubleArrayList grep(TDoubleProcedure condition) {
        TDoubleArrayList list = new TDoubleArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!condition.execute(this._data[i2])) continue;
            list.add(this._data[i2]);
        }
        return list;
    }

    public TDoubleArrayList inverseGrep(TDoubleProcedure condition) {
        TDoubleArrayList list = new TDoubleArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (condition.execute(this._data[i2])) continue;
            list.add(this._data[i2]);
        }
        return list;
    }

    public double max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        double max = this._data[this._pos - 1];
        int i2 = this._pos - 1;
        while (i2-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return max;
    }

    public double min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        double min2 = this._data[this._pos - 1];
        int i2 = this._pos - 1;
        while (i2-- > 0) {
            min2 = Math.min(min2, this._data[this._pos]);
        }
        return min2;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TDoubleProcedure(){

            public boolean execute(double val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this._data = new double[size];
        while (size-- > 0) {
            double val = stream.readDouble();
            this.add(val);
        }
    }
}

