/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class LongEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    @Override
    public int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        if (octetLength % 8 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfLong", new Object[]{8}));
        }
        return octetLength / 8;
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength * 8;
    }

    @Override
    public final Object decodeFromBytes(byte[] b, int start, int length) throws EncodingAlgorithmException {
        long[] data2 = new long[this.getPrimtiveLengthFromOctetLength(length)];
        this.decodeFromBytesToLongArray(data2, 0, b, start, length);
        return data2;
    }

    @Override
    public final Object decodeFromInputStream(InputStream s2) throws IOException {
        return this.decodeFromInputStreamToIntArray(s2);
    }

    @Override
    public void encodeToOutputStream(Object data2, OutputStream s2) throws IOException {
        if (!(data2 instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] ldata = (long[])data2;
        this.encodeToOutputStreamFromLongArray(ldata, s2);
    }

    @Override
    public Object convertFromCharacters(char[] ch, int start, int length) {
        final CharBuffer cb = CharBuffer.wrap(ch, start, length);
        final ArrayList longList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(cb, new BuiltInEncodingAlgorithm.WordListener(){

            @Override
            public void word(int start, int end) {
                String lStringValue = cb.subSequence(start, end).toString();
                longList.add(Long.valueOf(lStringValue));
            }
        });
        return this.generateArrayFromList(longList);
    }

    @Override
    public void convertToCharacters(Object data2, StringBuffer s2) {
        if (!(data2 instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] ldata = (long[])data2;
        this.convertToCharactersFromLongArray(ldata, s2);
    }

    public final void decodeFromBytesToLongArray(long[] ldata, int istart, byte[] b, int start, int length) {
        int size = length / 8;
        for (int i2 = 0; i2 < size; ++i2) {
            ldata[istart++] = (long)(b[start++] & 0xFF) << 56 | (long)(b[start++] & 0xFF) << 48 | (long)(b[start++] & 0xFF) << 40 | (long)(b[start++] & 0xFF) << 32 | (long)(b[start++] & 0xFF) << 24 | (long)(b[start++] & 0xFF) << 16 | (long)(b[start++] & 0xFF) << 8 | (long)(b[start++] & 0xFF);
        }
    }

    public final long[] decodeFromInputStreamToIntArray(InputStream s2) throws IOException {
        ArrayList<Long> longList = new ArrayList<Long>();
        byte[] b = new byte[8];
        while (true) {
            int n;
            if ((n = s2.read(b)) != 8) {
                if (n == -1) break;
                while (n != 8) {
                    int m3 = s2.read(b, n, 8 - n);
                    if (m3 == -1) {
                        throw new EOFException();
                    }
                    n += m3;
                }
            }
            long l = ((long)b[0] << 56) + ((long)(b[1] & 0xFF) << 48) + ((long)(b[2] & 0xFF) << 40) + ((long)(b[3] & 0xFF) << 32) + ((long)(b[4] & 0xFF) << 24) + (long)((b[5] & 0xFF) << 16) + (long)((b[6] & 0xFF) << 8) + (long)((b[7] & 0xFF) << 0);
            longList.add(l);
        }
        return this.generateArrayFromList(longList);
    }

    public final void encodeToOutputStreamFromLongArray(long[] ldata, OutputStream s2) throws IOException {
        for (int i2 = 0; i2 < ldata.length; ++i2) {
            long bits = ldata[i2];
            s2.write((int)(bits >>> 56 & 0xFFL));
            s2.write((int)(bits >>> 48 & 0xFFL));
            s2.write((int)(bits >>> 40 & 0xFFL));
            s2.write((int)(bits >>> 32 & 0xFFL));
            s2.write((int)(bits >>> 24 & 0xFFL));
            s2.write((int)(bits >>> 16 & 0xFFL));
            s2.write((int)(bits >>> 8 & 0xFFL));
            s2.write((int)(bits & 0xFFL));
        }
    }

    @Override
    public final void encodeToBytes(Object array, int astart, int alength, byte[] b, int start) {
        this.encodeToBytesFromLongArray((long[])array, astart, alength, b, start);
    }

    public final void encodeToBytesFromLongArray(long[] ldata, int lstart, int llength, byte[] b, int start) {
        int lend = lstart + llength;
        for (int i2 = lstart; i2 < lend; ++i2) {
            long bits = ldata[i2];
            b[start++] = (byte)(bits >>> 56 & 0xFFL);
            b[start++] = (byte)(bits >>> 48 & 0xFFL);
            b[start++] = (byte)(bits >>> 40 & 0xFFL);
            b[start++] = (byte)(bits >>> 32 & 0xFFL);
            b[start++] = (byte)(bits >>> 24 & 0xFFL);
            b[start++] = (byte)(bits >>> 16 & 0xFFL);
            b[start++] = (byte)(bits >>> 8 & 0xFFL);
            b[start++] = (byte)(bits & 0xFFL);
        }
    }

    public final void convertToCharactersFromLongArray(long[] ldata, StringBuffer s2) {
        int end = ldata.length - 1;
        for (int i2 = 0; i2 <= end; ++i2) {
            s2.append(Long.toString(ldata[i2]));
            if (i2 == end) continue;
            s2.append(' ');
        }
    }

    public final long[] generateArrayFromList(List array) {
        long[] ldata = new long[array.size()];
        for (int i2 = 0; i2 < ldata.length; ++i2) {
            ldata[i2] = (Long)array.get(i2);
        }
        return ldata;
    }
}

