/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/analytics/Anonymizer;", "", "()V", "anonymize", "", "logger", "Lcom/android/utils/ILogger;", "data", "charset", "Ljava/nio/charset/Charset;", "anonymizeUtf8", "shared"})
public final class Anonymizer {
    public static final Anonymizer INSTANCE;

    @JvmStatic
    @NotNull
    public static final String anonymizeUtf8(@NotNull ILogger logger, @Nullable String data2) throws IOException {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull(charset, "Charsets.UTF_8");
        return Anonymizer.anonymize(logger, data2, charset);
    }

    @JvmStatic
    @NotNull
    public static final String anonymize(@NotNull ILogger logger, @Nullable String data2, @NotNull Charset charset) throws IOException {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        if (data2 == null || Intrinsics.areEqual(data2, "")) {
            return "";
        }
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putBytes(AnalyticsSettings.INSTANCE.getSalt());
        hasher.putString(data2, charset);
        String string = hasher.hash().toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "hasher.hash().toString()");
        return string;
    }

    private Anonymizer() {
    }

    static {
        Anonymizer anonymizer;
        INSTANCE = anonymizer = new Anonymizer();
    }
}

