/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.AnalyticsSettingsData;
import com.android.tools.analytics.AnalyticsSettingsKt;
import com.android.tools.analytics.Environment;
import com.android.tools.analytics.WebServerDateProvider;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010J\u001a\u00020+H\u0003J\b\u0010K\u001a\u00020\u0004H\u0007J\b\u0010L\u001a\u00020MH\u0007J\b\u0010N\u001a\u00020MH\u0002J(\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020Q2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010S2\n\b\u0002\u0010T\u001a\u0004\u0018\u00010UH\u0007J\u0015\u0010V\u001a\u00020\u00152\u0006\u0010W\u001a\u00020+H\u0000\u00a2\u0006\u0002\bXJ\u0010\u0010Y\u001a\u00020+2\u0006\u0010P\u001a\u00020QH\u0003J)\u0010Z\u001a\u0002H[\"\u0004\b\u0000\u0010[2\u0006\u0010\\\u001a\u0002H[2\f\u0010]\u001a\b\u0012\u0004\u0012\u0002H[0^H\u0003\u00a2\u0006\u0002\u0010_J\b\u0010`\u001a\u00020MH\u0007J\u0012\u0010a\u001a\u00020M2\b\u0010W\u001a\u0004\u0018\u00010+H\u0007J\u0006\u0010b\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u00158FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001f\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R&\u0010'\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00158\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010\u0002\u001a\u0004\b)\u0010\u0018R\u001a\u0010*\u001a\u0004\u0018\u00010+8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b,\u0010\u0002R.\u0010/\u001a\u0004\u0018\u00010.2\b\u0010-\u001a\u0004\u0018\u00010.8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b0\u0010\u0002\u001a\u0004\b1\u00102\"\u0004\b3\u00104R.\u00105\u001a\u0004\u0018\u00010.2\b\u0010-\u001a\u0004\u0018\u00010.8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b6\u0010\u0002\u001a\u0004\b7\u00102\"\u0004\b8\u00104R*\u00109\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00158F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b:\u0010\u0002\u001a\u0004\b;\u0010\u0018\"\u0004\b<\u0010\u001dR\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020B8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020F8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bG\u0010\u0002\u001a\u0004\bH\u0010I\u00a8\u0006c"}, d2={"Lcom/android/tools/analytics/AnalyticsSettings;", "", "()V", "DAYS_IN_LEAP_YEAR", "", "DAYS_IN_NON_LEAP_YEAR", "DAYS_TO_WAIT_FOR_REQUESTING_SENTIMENT_AGAIN", "EPOCH", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "LOG", "Ljava/util/logging/Logger;", "SALT_SKEW_NOT_INITIALIZED", "dateProvider", "Lcom/android/utils/DateProvider;", "dateProvider$annotations", "getDateProvider", "()Lcom/android/utils/DateProvider;", "setDateProvider", "(Lcom/android/utils/DateProvider;)V", "debugDisablePublishing", "", "debugDisablePublishing$annotations", "getDebugDisablePublishing", "()Z", "exceptionThrown", "exceptionThrown$annotations", "getExceptionThrown", "setExceptionThrown", "(Z)V", "gate", "googlePlayDateProvider", "Lcom/android/tools/analytics/WebServerDateProvider;", "googlePlayDateProvider$annotations", "getGooglePlayDateProvider", "()Lcom/android/tools/analytics/WebServerDateProvider;", "setGooglePlayDateProvider", "(Lcom/android/tools/analytics/WebServerDateProvider;)V", "<set-?>", "initialized", "initialized$annotations", "getInitialized", "instance", "Lcom/android/tools/analytics/AnalyticsSettingsData;", "instance$annotations", "value", "Ljava/util/Date;", "lastSentimentAnswerDate", "lastSentimentAnswerDate$annotations", "getLastSentimentAnswerDate", "()Ljava/util/Date;", "setLastSentimentAnswerDate", "(Ljava/util/Date;)V", "lastSentimentQuestionDate", "lastSentimentQuestionDate$annotations", "getLastSentimentQuestionDate", "setLastSentimentQuestionDate", "optedIn", "optedIn$annotations", "getOptedIn", "setOptedIn", "salt", "", "getSalt", "()[B", "settingsFile", "Ljava/io/File;", "getSettingsFile$shared", "()Ljava/io/File;", "userId", "", "userId$annotations", "getUserId", "()Ljava/lang/String;", "createNewAnalyticsSettingsData", "currentSaltSkew", "disable", "", "ensureInitialized", "initialize", "logger", "Lcom/android/utils/ILogger;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "environment", "Lcom/android/tools/analytics/Environment;", "isValid", "settings", "isValid$shared", "loadSettingsData", "runIfAnalyticsSettingsUsable", "T", "default", "callback", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "saveSettings", "setInstanceForTest", "shouldRequestUserSentiment", "shared"})
public final class AnalyticsSettings {
    private static final Logger LOG;
    private static final int DAYS_IN_LEAP_YEAR = 366;
    private static final int DAYS_IN_NON_LEAP_YEAR = 365;
    private static final int DAYS_TO_WAIT_FOR_REQUESTING_SENTIMENT_AGAIN = 7;
    private static boolean initialized;
    private static boolean exceptionThrown;
    public static final int SALT_SKEW_NOT_INITIALIZED = -1;
    @NotNull
    private static DateProvider dateProvider;
    private static final LocalDate EPOCH;
    private static final Object gate;
    private static AnalyticsSettingsData instance;
    @Nullable
    private static WebServerDateProvider googlePlayDateProvider;
    public static final AnalyticsSettings INSTANCE;

    @JvmStatic
    public static /* synthetic */ void initialized$annotations() {
    }

    public static final boolean getInitialized() {
        return initialized;
    }

    @JvmStatic
    public static /* synthetic */ void exceptionThrown$annotations() {
    }

    public static final boolean getExceptionThrown() {
        return exceptionThrown;
    }

    public static final void setExceptionThrown(boolean bl) {
        exceptionThrown = bl;
    }

    @JvmStatic
    public static /* synthetic */ void userId$annotations() {
    }

    @NotNull
    public static final String getUserId() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable("", userId.1.INSTANCE);
    }

    @JvmStatic
    public static /* synthetic */ void optedIn$annotations() {
    }

    public static final boolean getOptedIn() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(false, optedIn.1.INSTANCE);
    }

    public static final void setOptedIn(boolean value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ boolean $value;

            public final void invoke() {
                block0: {
                    AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                    if (analyticsSettingsData == null) break block0;
                    AnalyticsSettingsData analyticsSettingsData2 = analyticsSettingsData;
                    boolean bl = false;
                    boolean bl2 = false;
                    AnalyticsSettingsData $this$apply = analyticsSettingsData2;
                    boolean bl3 = false;
                    $this$apply.setOptedIn(this.$value);
                }
            }
            {
                this.$value = bl;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    private static final <T> T runIfAnalyticsSettingsUsable(T t, Function0<? extends T> callback) {
        Throwable throwable = null;
        Object object = gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (exceptionThrown) {
                T t2 = t;
                return t2;
            }
            INSTANCE.ensureInitialized();
            try {
                T t3 = callback.invoke();
                return t3;
            }
            catch (Throwable t4) {
                exceptionThrown = true;
                throwable = t4;
                Unit unit = Unit.INSTANCE;
                // MONITOREXIT @DISABLED, blocks:[3, 4] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                if (throwable == null) return t;
                try {
                    LOG.log(Level.SEVERE, throwable, runIfAnalyticsSettingsUsable.2.INSTANCE);
                    return t;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return t;
            }
        }
    }

    private final void ensureInitialized() {
        if (!initialized && Boolean.getBoolean("idea.is.internal")) {
            throw (Throwable)new RuntimeException("call to AnalyticsSettings before initialization");
        }
    }

    @JvmStatic
    public static /* synthetic */ void debugDisablePublishing$annotations() {
    }

    public static final boolean getDebugDisablePublishing() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(false, debugDisablePublishing.1.INSTANCE);
    }

    @JvmStatic
    public static /* synthetic */ void lastSentimentQuestionDate$annotations() {
    }

    @Nullable
    public static final Date getLastSentimentQuestionDate() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(null, lastSentimentQuestionDate.1.INSTANCE);
    }

    public static final void setLastSentimentQuestionDate(@Nullable Date value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ Date $value;

            public final void invoke() {
                block0: {
                    AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                    if (analyticsSettingsData == null) break block0;
                    analyticsSettingsData.setLastSentimentQuestionDate(this.$value);
                }
            }
            {
                this.$value = date;
                super(0);
            }
        });
    }

    @JvmStatic
    public static /* synthetic */ void lastSentimentAnswerDate$annotations() {
    }

    @Nullable
    public static final Date getLastSentimentAnswerDate() {
        return AnalyticsSettings.runIfAnalyticsSettingsUsable(null, lastSentimentAnswerDate.1.INSTANCE);
    }

    public static final void setLastSentimentAnswerDate(@Nullable Date value) {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, (Function0)new Function0<Unit>(value){
            final /* synthetic */ Date $value;

            public final void invoke() {
                block0: {
                    AnalyticsSettingsData analyticsSettingsData = AnalyticsSettings.access$getInstance$p();
                    if (analyticsSettingsData == null) break block0;
                    analyticsSettingsData.setLastSentimentAnswerDate(this.$value);
                }
            }
            {
                this.$value = date;
                super(0);
            }
        });
    }

    @VisibleForTesting
    @JvmStatic
    public static /* synthetic */ void dateProvider$annotations() {
    }

    @NotNull
    public static final DateProvider getDateProvider() {
        return dateProvider;
    }

    public static final void setDateProvider(@NotNull DateProvider dateProvider) {
        Intrinsics.checkParameterIsNotNull(dateProvider, "<set-?>");
        AnalyticsSettings.dateProvider = dateProvider;
    }

    @JvmStatic
    private static /* synthetic */ void instance$annotations() {
    }

    @VisibleForTesting
    @JvmStatic
    public static final int currentSaltSkew() {
        Date date = dateProvider.now();
        Intrinsics.checkExpressionValueIsNotNull(date, "dateProvider.now()");
        LocalDate now = LocalDate.from(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        long days = ChronoUnit.DAYS.between(EPOCH, now) + (long)3;
        return (int)(days / (long)28);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @JvmStatic
    private static final AnalyticsSettingsData loadSettingsData(ILogger logger) throws IOException {
        File file = INSTANCE.getSettingsFile$shared();
        if (!file.exists()) {
            return AnalyticsSettings.createNewAnalyticsSettingsData();
        }
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        try {
            AnalyticsSettingsData analyticsSettingsData;
            AutoCloseable autoCloseable = channel.tryLock();
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileLock it = (FileLock)autoCloseable;
                boolean bl2 = false;
                InputStream inputStream = Channels.newInputStream(channel);
                Gson gson = new GsonBuilder().create();
                analyticsSettingsData = gson.fromJson((Reader)new InputStreamReader(inputStream), AnalyticsSettingsData.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
            AnalyticsSettingsData settings2 = analyticsSettingsData;
            if (settings2 == null || !INSTANCE.isValid$shared(settings2)) {
                return AnalyticsSettings.createNewAnalyticsSettingsData();
            }
            return settings2;
        }
        catch (OverlappingFileLockException e) {
            logger.warning("Unable to lock settings file %s: %s", file.toString(), e);
        }
        catch (JsonParseException e) {
            logger.warning("Unable to parse settings file %s: %s", file.toString(), e);
        }
        catch (IllegalStateException e) {
            logger.warning("Unable to parse settings file %s: %s", file.toString(), e);
        }
        AnalyticsSettingsData newSettings = new AnalyticsSettingsData();
        newSettings.setUserId(UUID.randomUUID().toString());
        return newSettings;
    }

    @VisibleForTesting
    @JvmStatic
    private static final AnalyticsSettingsData createNewAnalyticsSettingsData() throws IOException {
        AnalyticsSettingsData settings2 = new AnalyticsSettingsData();
        File uidFile = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "uid.txt").toFile();
        if (uidFile.exists()) {
            try {
                String uid = Files.readFirstLine(uidFile, Charsets.UTF_8);
                settings2.setUserId(uid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (settings2.getUserId() == null) {
            settings2.setUserId(UUID.randomUUID().toString());
        }
        settings2.saveSettings();
        return settings2;
    }

    @JvmStatic
    public static /* synthetic */ void googlePlayDateProvider$annotations() {
    }

    @Nullable
    public static final WebServerDateProvider getGooglePlayDateProvider() {
        return googlePlayDateProvider;
    }

    public static final void setGooglePlayDateProvider(@Nullable WebServerDateProvider webServerDateProvider) {
        googlePlayDateProvider = webServerDateProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger, @Nullable ScheduledExecutorService scheduler, @Nullable Environment environment) {
        block7: {
            Intrinsics.checkParameterIsNotNull(logger, "logger");
            Object object = gate;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                try {
                    Environment environment2 = environment;
                    if (environment2 != null) {
                        Environment environment3 = environment2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Environment it = environment3;
                        boolean bl6 = false;
                        Environment.Companion.setInstance(environment);
                    }
                    if (instance != null) {
                        return;
                    }
                    initialized = true;
                    instance = AnalyticsSettings.loadSettingsData(logger);
                }
                catch (IOException e) {
                    initialized = true;
                    instance = new AnalyticsSettingsData();
                    logger.warning("Unable to initialize metrics, ensure %s is writable, details: %s", AnalyticsPaths.getAndEnsureAndroidSettingsHome(), e.getMessage());
                }
                Unit unit = Unit.INSTANCE;
            }
            ScheduledExecutorService scheduledExecutorService = scheduler;
            if (scheduledExecutorService == null) break block7;
            scheduledExecutorService.submit(new Runnable(logger){
                final /* synthetic */ ILogger $logger;

                public final void run() {
                    try {
                        WebServerDateProvider gp = new WebServerDateProvider(new URL("https://play.google.com/"));
                        AnalyticsSettings.setDateProvider(gp);
                        AnalyticsSettings.setGooglePlayDateProvider(gp);
                    }
                    catch (IOException _) {
                        this.$logger.warning("Unable to get current time from Google's servers, using local system time instead.", new Object[0]);
                    }
                }
                {
                    this.$logger = iLogger;
                }
            });
        }
    }

    public static /* synthetic */ void initialize$default(ILogger iLogger, ScheduledExecutorService scheduledExecutorService, Environment environment, int n, Object object) {
        if ((n & 2) != 0) {
            scheduledExecutorService = null;
        }
        if ((n & 4) != 0) {
            environment = null;
        }
        AnalyticsSettings.initialize(iLogger, scheduledExecutorService, environment);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger, @Nullable ScheduledExecutorService scheduler) {
        AnalyticsSettings.initialize$default(logger, scheduler, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger) {
        AnalyticsSettings.initialize$default(logger, null, null, 6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void disable() {
        Object object = gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            initialized = true;
            instance = new AnalyticsSettingsData();
            DateProvider dateProvider = DateProvider.SYSTEM;
            Intrinsics.checkExpressionValueIsNotNull(dateProvider, "DateProvider.SYSTEM");
            AnalyticsSettings.dateProvider = dateProvider;
            googlePlayDateProvider = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @JvmStatic
    public static final void setInstanceForTest(@Nullable AnalyticsSettingsData settings2) {
        Object object = gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            instance = settings2;
            initialized = instance != null;
            exceptionThrown = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final File getSettingsFile$shared() {
        File file = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "analytics.settings").toFile();
        Intrinsics.checkExpressionValueIsNotNull(file, "Paths.get(AnalyticsPaths\u2026ytics.settings\").toFile()");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getSalt() throws IOException {
        Object object = gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            AnalyticsSettingsData analyticsSettingsData;
            block5: {
                boolean bl3 = false;
                if (instance != null) break block5;
                byte[] byArray = new byte[]{};
                return byArray;
            }
            AnalyticsSettingsData data2 = analyticsSettingsData;
            int dataSkew532 = (data2.getSaltSkew() - 11) / 19;
            int currentSaltSkew = AnalyticsSettings.currentSaltSkew();
            int currentSaltSkew532 = (currentSaltSkew - 11) / 19;
            if (dataSkew532 != currentSaltSkew532) {
                data2.setSaltSkew(currentSaltSkew);
                SecureRandom random = new SecureRandom();
                byte[] blob = new byte[24];
                random.nextBytes(blob);
                data2.setSaltValue(new BigInteger(blob));
                AnalyticsSettings.saveSettings();
            }
            BigInteger bigInteger = data2.getSaltValue();
            Intrinsics.checkExpressionValueIsNotNull(bigInteger, "data.saltValue");
            byte[] byArray = AnalyticsSettingsKt.toByteArrayOfLength24(bigInteger);
            return byArray;
        }
    }

    @JvmStatic
    public static final void saveSettings() throws IOException {
        AnalyticsSettings.runIfAnalyticsSettingsUsable(Unit.INSTANCE, saveSettings.1.INSTANCE);
    }

    public final boolean isValid$shared(@NotNull AnalyticsSettingsData settings2) {
        Intrinsics.checkParameterIsNotNull(settings2, "settings");
        return settings2.getUserId() != null && (settings2.getSaltSkew() == -1 || settings2.getSaltValue() != null);
    }

    public final boolean shouldRequestUserSentiment() {
        Calendar calendar;
        if (!AnalyticsSettings.getOptedIn()) {
            return false;
        }
        Date lastSentimentAnswerDate2 = AnalyticsSettings.getLastSentimentAnswerDate();
        Date lastSentimentQuestionDate2 = AnalyticsSettings.getLastSentimentQuestionDate();
        Date now = dateProvider.now();
        int daysInYear = 365;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = now;
        Intrinsics.checkExpressionValueIsNotNull(date, "now");
        if (gregorianCalendar.isLeapYear(date.getYear() + 1900)) {
            daysInYear = 366;
        }
        if (lastSentimentAnswerDate2 != null) {
            Calendar calendar2 = calendar = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull(calendar2, "calendar");
            calendar2.setTime(now);
            calendar.add(5, -daysInYear);
            Date lastYear = calendar.getTime();
            if (lastSentimentAnswerDate2.after(lastYear)) {
                return false;
            }
        }
        if (lastSentimentQuestionDate2 != null) {
            Calendar calendar3 = calendar = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull(calendar3, "calendar");
            calendar3.setTime(now);
            calendar.add(5, -7);
            Date startOfWaitForRequest = calendar.getTime();
            return !lastSentimentQuestionDate2.after(startOfWaitForRequest);
        }
        GregorianCalendar startOfYear = new GregorianCalendar(now.getYear() + 1900, 0, 1);
        startOfYear.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        long daysSinceJanFirst = ChronoUnit.DAYS.between(startOfYear.toInstant(), now.toInstant());
        long offset = Math.abs(Hashing.farmHashFingerprint64().hashString(AnalyticsSettings.getUserId(), Charsets.UTF_8).asLong()) % (long)daysInYear;
        return daysSinceJanFirst == offset;
    }

    private AnalyticsSettings() {
    }

    static {
        AnalyticsSettings analyticsSettings;
        INSTANCE = analyticsSettings = new AnalyticsSettings();
        LOG = Logger.getLogger(INSTANCE.getClass().getName());
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkExpressionValueIsNotNull(dateProvider, "DateProvider.SYSTEM");
        AnalyticsSettings.dateProvider = dateProvider;
        EPOCH = LocalDate.ofEpochDay(0L);
        gate = new Object();
    }

    public static final /* synthetic */ AnalyticsSettingsData access$getInstance$p() {
        return instance;
    }

    public static final /* synthetic */ void access$setInstance$p(AnalyticsSettingsData analyticsSettingsData) {
        instance = analyticsSettingsData;
    }
}

