/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool;

import com.android.repository.api.Channel;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Repository;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RemotePackageImpl;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.legacy.LegacyDownloader;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class OfflineRepoCreator {
    private final OfflineRepoConfig mConfig;

    public OfflineRepoCreator(OfflineRepoConfig config) {
        this.mConfig = config;
    }

    public void run() throws IOException {
        File tempDir = FileOpUtils.getNewTempDir("OfflineRepoCreator", this.mConfig.mFop);
        AndroidSdkHandler handler = AndroidSdkHandler.getInstance(tempDir);
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        RepoManager mgr = handler.getSdkManager(progress);
        SettingsController settings2 = new SettingsController(){

            @Override
            public boolean getForceHttp() {
                return false;
            }

            @Override
            public void setForceHttp(boolean force) {
            }

            @Override
            public boolean getDisableSdkPatches() {
                return true;
            }

            @Override
            public void setDisableSdkPatches(boolean disable) {
            }

            @Override
            public Channel getChannel() {
                return null;
            }
        };
        mgr.loadSynchronously(0L, progress, new LegacyDownloader(this.mConfig.mFop, settings2), settings2);
        Map<String, RemotePackage> remotes = mgr.getPackages().getRemotePackages();
        ArrayList<RemotePackageImpl> toWrite = new ArrayList<RemotePackageImpl>();
        for (String path : this.mConfig.mPackages) {
            RemotePackageImpl remote = (RemotePackageImpl)remotes.get(path);
            if (remote == null) continue;
            toWrite.add(remote);
            URL url = InstallerUtil.resolveCompleteArchiveUrl(remote, progress);
            Path dest = this.mConfig.mDest.resolve(remote.getArchive().getComplete().getUrl());
            if (OfflineRepoCreator.checkExisting(remote, dest)) continue;
            System.out.println("downloading " + url + " to " + dest);
            Files.copy(url.openStream(), dest, StandardCopyOption.REPLACE_EXISTING);
        }
        if (!toWrite.isEmpty()) {
            this.writeRepoXml(toWrite, mgr, progress);
        }
    }

    private static boolean checkExisting(RemotePackageImpl remote, Path dest) throws IOException {
        if (Files.exists(dest, new LinkOption[0])) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(dest, new OpenOption[0]));){
                    int n;
                    byte[] buf = new byte[4096];
                    while ((n = ((InputStream)in).read(buf)) >= 0) {
                        digest.update(buf, 0, n);
                    }
                }
                if (DatatypeConverter.printHexBinary(digest.digest()).equals(remote.getArchive().getComplete().getChecksum().toUpperCase())) {
                    System.out.println(dest + " is up to date");
                    return true;
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return false;
    }

    private void writeRepoXml(List<RemotePackageImpl> toWrite, RepoManager mgr, ProgressIndicator progress) throws IOException {
        CommonFactory factory = RepoManager.getCommonModule().createLatestFactory();
        Repository repo = factory.createRepositoryType();
        HashSet<String> seenLicenses = new HashSet<String>();
        for (RemotePackageImpl remote : toWrite) {
            License l = remote.getLicense();
            if (l != null && !seenLicenses.contains(l.getId())) {
                repo.addLicense(l);
                seenLicenses.add(l.getId());
            }
            remote.setChannel(null);
            repo.getRemotePackage().add(remote);
        }
        Path outFile = this.mConfig.mDest.resolve("offline-repo.xml");
        System.out.println("Writing repo xml to " + outFile);
        InstallerUtil.writeRepoXml(mgr, repo, outFile.toFile(), this.mConfig.mFop, progress);
    }

    public static void main(String[] args2) throws IOException {
        OfflineRepoConfig config = OfflineRepoConfig.parse(args2);
        if (config == null) {
            System.exit(1);
        }
        OfflineRepoCreator creator = new OfflineRepoCreator(config);
        creator.run();
    }

    private static class OfflineRepoConfig {
        private Path mDest;
        private List<String> mPackages = Lists.newArrayList();
        private FileOp mFop = FileOpUtils.create();
        private static final String DEST = "--dest";
        private static final String PKG_LIST = "--package_file";

        private OfflineRepoConfig() {
        }

        public static OfflineRepoConfig parse(String[] args2) {
            OfflineRepoConfig result2 = new OfflineRepoConfig();
            try {
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    if (args2[i2].equals(DEST)) {
                        result2.mDest = Paths.get(args2[++i2], new String[0]);
                        continue;
                    }
                    if (args2[i2].equals(PKG_LIST)) {
                        result2.mPackages.addAll(Files.readAllLines(Paths.get(args2[++i2], new String[0])));
                        continue;
                    }
                    result2.mPackages.add(args2[i2]);
                }
                if (result2.mDest == null || result2.mPackages.isEmpty()) {
                    OfflineRepoConfig.printUsage();
                    return null;
                }
                return result2;
            }
            catch (Exception e) {
                OfflineRepoConfig.printUsage();
                System.err.println();
                e.printStackTrace();
                return null;
            }
        }

        private static void printUsage() {
            System.err.println("Usage: java com.android.sdklib.tool.OfflineRepoCreator \\");
            System.err.println("  --dest <path> [--package_file <filename>] <packages>...");
            System.err.println();
            System.err.println("<package> is a sdk-style path (e.g. \"build-tools;23.0.0\" or \"platforms;android-23\")");
            System.err.println("<filename> is a file that contains one <package> per line");
            System.err.println();
            System.err.println("* If the env var REPO_OS_OVERRIDE is set to \"windows\",\n  \"macosx\", or \"linux\", packages will be created for that OS");
        }
    }
}

