/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote.internal.packages;

import com.android.repository.Revision;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.legacy.descriptors.PkgDesc;
import com.android.sdklib.repository.legacy.descriptors.PkgDescExtra;
import com.android.sdklib.repository.legacy.local.LocalExtraPkgInfo;
import com.android.sdklib.repository.legacy.remote.RemotePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.IMinApiLevelDependency;
import com.android.sdklib.repository.legacy.remote.internal.packages.IMinToolsDependency;
import com.android.sdklib.repository.legacy.remote.internal.packages.MinToolsMixin;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemotePackageParserUtils;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.w3c.dom.Node;

@Deprecated
public class RemoteExtraPkgInfo
extends RemotePkgInfo
implements IMinApiLevelDependency,
IMinToolsDependency {
    private final MinToolsMixin mMinToolsMixin;
    private final String mDisplayName;
    private final String mPath;
    private final String mOldPaths;
    private final int mMinApiLevel;
    private final String[] mProjectFiles;

    public RemoteExtraPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        Object vendor;
        this.mMinToolsMixin = new MinToolsMixin(packageNode);
        this.mPath = RemotePackageParserUtils.getXmlString(packageNode, "path");
        String name = RemotePackageParserUtils.getXmlString(packageNode, "name-display");
        Object vname = RemotePackageParserUtils.getXmlString(packageNode, "vendor-display");
        String vid = RemotePackageParserUtils.getXmlString(packageNode, "vendor-id");
        if (vid.isEmpty()) {
            vendor = RemotePackageParserUtils.getXmlString(packageNode, "vendor");
            vid = this.sanitizeLegacyVendor((String)vendor);
            if (((String)vname).isEmpty()) {
                vname = vendor;
            }
        }
        if (((String)vname).isEmpty()) {
            vname = vid;
        }
        vendor = IdDisplay.create(vid.trim(), ((String)vname).trim());
        if (name.isEmpty()) {
            name = LocalExtraPkgInfo.getPrettyName((IdDisplay)vendor, this.mPath);
        }
        this.mDisplayName = name.trim();
        this.mMinApiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "min-api-level", 0);
        this.mProjectFiles = this.parseProjectFiles(RemotePackageParserUtils.findChildElement(packageNode, "project-files"));
        this.mOldPaths = RemotePackageParserUtils.getXmlString(packageNode, "old-paths");
        Revision revision = this.getRevision();
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newExtra((IdDisplay)vendor, this.mPath, this.mDisplayName, this.getOldPaths(), revision);
        pkgDescBuilder.setDescriptionShort(RemoteExtraPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.mDisplayName, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteExtraPkgInfo.createListDescription(this.mListDisplay, this.mDisplayName, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    private String[] parseProjectFiles(Node projectFilesNode) {
        ArrayList<String> paths = new ArrayList<String>();
        if (projectFilesNode != null) {
            String nsUri = projectFilesNode.getNamespaceURI();
            for (Node child = projectFilesNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                String path;
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"path".equals(child.getLocalName()) || (path = child.getTextContent()) == null || (path = path.trim()).isEmpty()) continue;
                paths.add(path);
            }
        }
        return paths.toArray(new String[0]);
    }

    @Override
    public Revision getMinToolsRevision() {
        return this.mMinToolsMixin.getMinToolsRevision();
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    public String[] getOldPaths() {
        return PkgDescExtra.convertOldPaths(this.mOldPaths);
    }

    public String getPath() {
        String path = this.mPath.replaceAll("[^a-zA-Z0-9-]+", "_");
        if (path.isEmpty() || path.equals("_")) {
            int h2 = path.hashCode();
            path = String.format("extra%08x", h2);
        }
        return path;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    private String sanitizeLegacyVendor(String vendorDisplay) {
        if (vendorDisplay != null && !vendorDisplay.isEmpty()) {
            String vendor = vendorDisplay.trim();
            if ((vendor = vendor.replaceAll("[^a-zA-Z0-9-]+", "_")).equals("_")) {
                int h2 = vendor.hashCode();
                vendor = String.format("vendor%08x", h2);
            }
            return vendor;
        }
        return "";
    }

    private static String createListDescription(String listDisplay, String displayName, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        String s2 = String.format("%1$s%2$s", displayName, obsolete ? " (Obsolete)" : "");
        return s2;
    }

    private static String createShortDescription(String listDisplay, Revision revision, String displayName, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        String s2 = String.format("%1$s, revision %2$s%3$s", displayName, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        return s2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = this.mMinToolsMixin.hashCode(super.hashCode());
        result2 = 31 * result2 + this.mMinApiLevel;
        result2 = 31 * result2 + (this.mPath == null ? 0 : this.mPath.hashCode());
        result2 = 31 * result2 + Arrays.hashCode(this.mProjectFiles);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemoteExtraPkgInfo)) {
            return false;
        }
        RemoteExtraPkgInfo other = (RemoteExtraPkgInfo)obj;
        if (this.mMinApiLevel != other.mMinApiLevel) {
            return false;
        }
        if (this.mPath == null ? other.mPath != null : !this.mPath.equals(other.mPath)) {
            return false;
        }
        if (!Arrays.equals(this.mProjectFiles, other.mProjectFiles)) {
            return false;
        }
        return this.mMinToolsMixin.equals(obj);
    }
}

