/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.repository.Revision;
import com.android.repository.api.Dependency;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.RepoPackageImpl;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.legacy.LegacyRepoUtils;
import com.android.sdklib.repository.legacy.descriptors.PkgType;
import com.android.sdklib.repository.legacy.local.LocalAddonPkgInfo;
import com.android.sdklib.repository.legacy.local.LocalPkgInfo;
import com.android.sdklib.repository.legacy.local.LocalPlatformPkgInfo;
import com.android.sdklib.repository.legacy.local.LocalSdk;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LegacyLocalRepoLoader
implements FallbackLocalRepoLoader {
    private final LocalSdk mLocalSdk;
    private Map<File, LocalPkgInfo> mPkgs = null;
    private final FileOp mFop;

    public LegacyLocalRepoLoader(File root, FileOp fop) {
        this.mLocalSdk = new LocalSdk(fop);
        this.mLocalSdk.setLocation(root);
        this.mFop = fop;
    }

    @Override
    public LocalPackage parseLegacyLocalPackage(File dir, ProgressIndicator progress) {
        LocalPkgInfo info;
        if (!this.mFop.exists(new File(dir, "source.properties"))) {
            return null;
        }
        progress.logVerbose(String.format("Parsing legacy package: %s", dir));
        if (this.mPkgs == null) {
            HashMap<File, LocalPkgInfo> result2 = Maps.newHashMap();
            this.mLocalSdk.clearLocalPkg(PkgType.PKG_ALL);
            for (LocalPkgInfo local : this.mLocalSdk.getPkgsInfos(PkgType.PKG_ALL)) {
                result2.put(local.getLocalDir(), local);
            }
            this.mPkgs = result2;
        }
        if ((info = this.mPkgs.get(dir)) == null) {
            return null;
        }
        return new LegacyLocalPackage(info, progress);
    }

    @Override
    public void refresh() {
        this.mPkgs = null;
    }

    @Override
    public boolean shouldParse(File root) {
        return this.mFop.exists(new File(root, "source.properties"));
    }

    class LegacyLocalPackage
    implements LocalPackage {
        private final ProgressIndicator mProgress;
        private final LocalPkgInfo mWrapped;

        LegacyLocalPackage(LocalPkgInfo wrapped, ProgressIndicator progress) {
            this.mWrapped = wrapped;
            this.mProgress = progress;
        }

        @Override
        public TypeDetails getTypeDetails() {
            int layoutVersion = 0;
            if (this.mWrapped instanceof LocalPlatformPkgInfo) {
                layoutVersion = ((LocalPlatformPkgInfo)this.mWrapped).getLayoutlibApi();
            }
            List<OptionalLibrary> addonLibraries = Lists.newArrayList();
            if (this.mWrapped instanceof LocalAddonPkgInfo) {
                addonLibraries = LegacyRepoUtils.parseLegacyAdditionalLibraries(this.mWrapped.getLocalDir(), this.mProgress, LegacyLocalRepoLoader.this.mFop);
            }
            return LegacyRepoUtils.createTypeDetails(this.mWrapped.getDesc(), layoutVersion, addonLibraries, this.getLocation(), this.mProgress, LegacyLocalRepoLoader.this.mFop);
        }

        @Override
        public Revision getVersion() {
            return this.mWrapped.getDesc().getRevision();
        }

        @Override
        public String getDisplayName() {
            return LegacyRepoUtils.getDisplayName(this.mWrapped.getDesc());
        }

        @Override
        public License getLicense() {
            License res = this.mWrapped.getDesc().getLicense();
            CommonFactory factory = RepoManager.getCommonModule().createLatestFactory();
            if (res == null) {
                res = factory.createLicenseType();
                res.setValue(this.mWrapped.getSourceProperties().getProperty("Pkg.License"));
                res.setId(String.format(Locale.US, "license-%X", this.mWrapped.getSourceProperties().hashCode()));
                res.setType("text");
            }
            return res;
        }

        @Override
        public Collection<Dependency> getAllDependencies() {
            ArrayList<Dependency> result2 = Lists.newArrayList();
            Revision rev = this.mWrapped.getDesc().getMinPlatformToolsRev();
            CommonFactory factory = RepoManager.getCommonModule().createLatestFactory();
            if (rev != null) {
                result2.add(factory.createDependencyType(rev, "platform-tools"));
            }
            if ((rev = this.mWrapped.getDesc().getMinToolsRev()) != null) {
                result2.add(factory.createDependencyType(rev, "tools"));
            }
            return result2;
        }

        @Override
        public String getPath() {
            File sourcePropsFile = new File(this.mWrapped.getLocalDir(), "source.properties");
            try {
                Properties sourceProps = new Properties();
                sourceProps.load(LegacyLocalRepoLoader.this.mFop.newFileInputStream(sourcePropsFile));
                String newPath = sourceProps.getProperty("Pkg.Path");
                if (newPath != null) {
                    return newPath;
                }
            }
            catch (IOException sourceProps) {
                // empty catch block
            }
            String relativePath = null;
            try {
                relativePath = FileOpUtils.makeRelative(this.mWrapped.getLocalSdk().getLocation(), this.mWrapped.getLocalDir(), LegacyLocalRepoLoader.this.mFop);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return LegacyRepoUtils.getLegacyPath(this.mWrapped.getDesc(), relativePath);
        }

        @Override
        public boolean obsolete() {
            return this.mWrapped.getDesc().isObsolete() || this.mWrapped.getDesc().getType() == PkgType.PKG_SAMPLE;
        }

        @Override
        public CommonFactory createFactory() {
            return RepoManager.getCommonModule().createLatestFactory();
        }

        @Override
        public RepoPackageImpl asMarshallable() {
            return LocalPackageImpl.create(this);
        }

        @Override
        public int compareTo(RepoPackage o) {
            int result2 = ComparisonChain.start().compare((Comparable<?>)((Object)this.getPath()), (Comparable<?>)((Object)o.getPath())).compare(this.getVersion(), o.getVersion()).result();
            if (result2 != 0) {
                return result2;
            }
            if (!(o instanceof LocalPackage)) {
                return this.getClass().getName().compareTo(o.getClass().getName());
            }
            return 0;
        }

        @Override
        public File getLocation() {
            return this.mWrapped.getLocalDir();
        }

        @Override
        public void setInstalledPath(File root) {
        }
    }
}

