/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.installer;

import com.android.repository.Revision;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

public class MavenInstallListener
implements PackageOperation.StatusChangeListener {
    public static final String MAVEN_DIR_NAME = "m2repository";
    public static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";
    private final AndroidSdkHandler mSdkHandler;

    public MavenInstallListener(AndroidSdkHandler sdkHandler) {
        this.mSdkHandler = sdkHandler;
    }

    @Override
    public void statusChanged(PackageOperation installer, ProgressIndicator progress) throws PackageOperation.StatusChangeListenerException {
        File dir;
        if (installer.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE && !this.updateMetadata((dir = installer.getLocation(progress)).getParentFile(), progress)) {
            throw new PackageOperation.StatusChangeListenerException("Failed to update maven metadata for " + installer.getPackage().getDisplayName());
        }
    }

    private boolean updateMetadata(File root, ProgressIndicator progress) {
        FileOp fileOp = this.mSdkHandler.getFileOp();
        MavenMetadata metadata2 = null;
        for (File version : fileOp.listFiles(root)) {
            if (!fileOp.isDirectory(version)) continue;
            metadata2 = MavenInstallListener.createOrUpdateMetadata(version, metadata2, progress, fileOp);
        }
        File metadataFile = new File(root, MAVEN_METADATA_FILE_NAME);
        if (metadata2 != null) {
            progress.logVerbose("Writing Maven metadata to " + metadataFile.getAbsolutePath());
            return MavenInstallListener.writeMetadata(metadata2, metadataFile, progress, fileOp);
        }
        progress.logVerbose("Deleting Maven metadata " + metadataFile.getAbsolutePath());
        return MavenInstallListener.deleteMetadataFiles(metadataFile, progress, fileOp);
    }

    private static boolean deleteMetadataFiles(File metadataFile, ProgressIndicator progress, FileOp fop) {
        if (!FileOpUtils.deleteIfExists(metadataFile, fop)) {
            progress.logError("Failed to delete " + metadataFile.getAbsolutePath());
            return false;
        }
        File md5File = MavenInstallListener.getMetadataHashFile(metadataFile, "MD5");
        if (!FileOpUtils.deleteIfExists(md5File, fop)) {
            progress.logError("Failed to delete " + md5File.getAbsolutePath());
            return false;
        }
        File sha1File = MavenInstallListener.getMetadataHashFile(metadataFile, "SHA1");
        if (!FileOpUtils.deleteIfExists(sha1File, fop)) {
            progress.logError("Failed to delete " + sha1File.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeMetadata(MavenMetadata metadata2, File file, ProgressIndicator progress, FileOp fop) {
        Marshaller marshaller;
        Revision max = null;
        for (String s2 : metadata2.versioning.versions.version) {
            Revision rev = Revision.parseRevision(s2);
            if (max != null && (rev.isPreview() || rev.compareTo(max) <= 0)) continue;
            max = rev;
        }
        if (max != null) {
            metadata2.versioning.release = max.toString();
        }
        metadata2.versioning.lastUpdated = System.currentTimeMillis();
        try {
            JAXBContext context;
            try {
                context = JAXBContext.newInstance(MavenMetadata.class);
            }
            catch (JAXBException e) {
                progress.logError("Failed to create JAXBContext", e);
                return false;
            }
            marshaller = context.createMarshaller();
        }
        catch (JAXBException e) {
            progress.logError("Failed to create Marshaller", e);
            return false;
        }
        ByteArrayOutputStream metadataOutBytes = new ByteArrayOutputStream();
        try {
            marshaller.marshal(new JAXBElement<MavenMetadata>(new QName("metadata"), MavenMetadata.class, metadata2), metadataOutBytes);
        }
        catch (JAXBException e) {
            progress.logWarning("Failed to write maven metadata: ", e);
            return false;
        }
        OutputStream metadataOutFile = null;
        try {
            metadataOutFile = fop.newFileOutputStream(file);
            metadataOutFile.write(metadataOutBytes.toByteArray());
        }
        catch (IOException e) {
            progress.logWarning("Failed to write metadata file.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (metadataOutFile != null) {
                try {
                    metadataOutFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!MavenInstallListener.writeHashFile(file, "MD5", progress, metadataOutBytes, fop)) {
            return false;
        }
        return MavenInstallListener.writeHashFile(file, "SHA1", progress, metadataOutBytes, fop);
    }

    private static MavenMetadata createOrUpdateMetadata(File versionPath, MavenMetadata metadata2, ProgressIndicator progress, FileOp fop) {
        PackageInfo info;
        File pomFile = new File(versionPath, String.format("%1$s-%2$s.pom", versionPath.getParentFile().getName(), versionPath.getName()));
        if (fop.exists(pomFile) && (info = MavenInstallListener.unmarshal(pomFile, PackageInfo.class, progress, fop)) != null) {
            if (metadata2 == null) {
                metadata2 = new MavenMetadata();
                metadata2.artifactId = info.artifactId;
                metadata2.groupId = info.groupId;
                metadata2.versioning = new MavenMetadata.Versioning();
                metadata2.versioning.versions = new MavenMetadata.Versioning.Versions();
                metadata2.versioning.versions.version = Lists.newArrayList();
            }
            metadata2.versioning.versions.version.add(info.version);
        }
        return metadata2;
    }

    @VisibleForTesting
    static <T> T unmarshal(File f, Class<T> clazz, ProgressIndicator progress, FileOp fop) {
        Object result2;
        InputStream metadataInputStream;
        Unmarshaller unmarshaller;
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(clazz);
        }
        catch (JAXBException e) {
            progress.logError("Failed to create JAXBContext", e);
            return null;
        }
        try {
            unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler(event -> true);
        }
        catch (JAXBException e) {
            progress.logError("Failed to create unmarshaller", e);
            return null;
        }
        try {
            metadataInputStream = fop.newFileInputStream(f);
        }
        catch (IOException e) {
            return null;
        }
        try {
            result2 = unmarshaller.unmarshal(metadataInputStream);
        }
        catch (JAXBException e) {
            progress.logWarning("Couldn't parse maven metadata file: " + f, e);
            return null;
        }
        return (T)result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeHashFile(File file, String algorithm, ProgressIndicator progress, ByteArrayOutputStream metadataOutBytes, FileOp fop) {
        OutputStream hashOutputStream;
        MessageDigest digest;
        File hashFile = MavenInstallListener.getMetadataHashFile(file, algorithm);
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            progress.logError(algorithm + " algorithm not found", e);
            return false;
        }
        try {
            hashOutputStream = fop.newFileOutputStream(hashFile);
        }
        catch (IOException e) {
            progress.logWarning("Failed to open " + algorithm + " file");
            return false;
        }
        try {
            hashOutputStream.write(DatatypeConverter.printHexBinary(digest.digest(metadataOutBytes.toByteArray())).getBytes());
        }
        catch (IOException e) {
            progress.logWarning("Failed to write " + algorithm + " file");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                hashOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private static File getMetadataHashFile(File file, String algorithm) {
        return new File(file.getParent(), "maven-metadata.xml." + algorithm.toLowerCase());
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="project", namespace="http://maven.apache.org/POM/4.0.0")
    private static class PackageInfo {
        @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
        public String artifactId;
        @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
        public String groupId;
        @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
        public String version;

        private PackageInfo() {
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="metadata")
    @VisibleForTesting
    static class MavenMetadata {
        protected String groupId;
        protected String artifactId;
        protected Versioning versioning;

        MavenMetadata() {
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class Versioning {
            protected String release;
            protected Versions versions;
            protected long lastUpdated;

            @XmlAccessorType(value=XmlAccessType.FIELD)
            public static class Versions {
                protected List<String> version;
            }
        }
    }
}

