/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.utils.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LoggerProgressIndicatorWrapper
extends ProgressIndicatorAdapter {
    private final ILogger mWrapped;

    public LoggerProgressIndicatorWrapper(ILogger toWrap) {
        this.mWrapped = toWrap;
    }

    @Override
    public void logWarning(String s2) {
        this.mWrapped.warning(s2, new Object[0]);
    }

    @Override
    public void logWarning(String s2, Throwable e) {
        if (e == null) {
            this.logWarning(s2);
            return;
        }
        this.mWrapped.warning("%1$s:\n%2$s", s2, LoggerProgressIndicatorWrapper.throwableToString(e));
    }

    @Override
    public void logError(String s2) {
        this.logError(s2, null);
    }

    @Override
    public void logError(String s2, Throwable e) {
        this.mWrapped.error(e, s2, new Object[0]);
    }

    @Override
    public void logInfo(String s2) {
        this.mWrapped.lifecycle(s2, new Object[0]);
    }

    @Override
    public void logVerbose(String s2) {
        this.mWrapped.verbose(s2, new Object[0]);
    }

    private static String throwableToString(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

