/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.SdkCommonFactory;
import java.util.Locale;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class IdDisplay
implements Comparable<IdDisplay> {
    public static IdDisplay create(String id, String display) {
        SdkCommonFactory factory = AndroidSdkHandler.getCommonModule().createLatestFactory();
        IdDisplay result2 = factory.createIdDisplayType();
        result2.setId(id);
        result2.setDisplay(display);
        return result2;
    }

    public abstract void setId(String var1);

    public abstract void setDisplay(String var1);

    public abstract String getId();

    public abstract String getDisplay();

    @Override
    public int compareTo(IdDisplay o) {
        return this.getId().compareTo(o.getId());
    }

    public boolean equals(Object o) {
        if (!(o instanceof IdDisplay)) {
            return false;
        }
        return this.compareTo((IdDisplay)o) == 0;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return String.format("%1$s [%2$s]", this.getId(), this.getDisplay());
    }

    public static String idToDisplay(String id) {
        char c;
        String name = id.replaceAll("[^A-Za-z0-9]+", " ");
        name = name.replaceAll(" +", " ");
        if (!(name = name.trim()).isEmpty() && !Character.isUpperCase(c = name.charAt(0))) {
            StringBuilder sb = new StringBuilder(name);
            sb.replace(0, 1, String.valueOf(c).toUpperCase(Locale.US));
            name = sb.toString();
        }
        return name;
    }
}

