/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.io.FolderWrapper;
import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.android.sdklib.internal.project.IPropertySource;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.utils.ILogger;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ProjectProperties
implements IPropertySource {
    protected static final Pattern PATTERN_PROP = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_PROGUARD_CONFIG = "proguard.config";
    public static final String PROPERTY_SDK = "sdk.dir";
    public static final String PROPERTY_NDK = "ndk.dir";
    public static final String PROPERTY_NDK_SYMLINKDIR = "ndk.symlinkdir";
    public static final String PROPERTY_CMAKE = "cmake.dir";
    private static final String PROPERTY_SDK_LEGACY = "sdk-location";
    public static final String PROPERTY_SPLIT_BY_DENSITY = "split.density";
    public static final String PROPERTY_PACKAGE = "package";
    public static final String PROPERTY_VERSIONCODE = "versionCode";
    public static final String PROPERTY_PROJECTS = "projects";
    private static final String LOCAL_HEADER = "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n";
    protected final IAbstractFolder mProjectFolder;
    protected final Map<String, String> mProperties;
    protected final PropertyType mType;

    public static ProjectProperties load(String projectFolderOsPath, PropertyType type2) {
        FolderWrapper wrapper = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.load(wrapper, type2);
    }

    public static ProjectProperties load(IAbstractFolder projectFolder, PropertyType type2) {
        Map<String, String> map2;
        IAbstractFile propFile;
        if (projectFolder.exists() && (propFile = projectFolder.getFile(type2.mFilename)).exists() && (map2 = ProjectProperties.parsePropertyFile(propFile, null)) != null) {
            return new ProjectProperties(projectFolder, map2, type2);
        }
        return null;
    }

    public static boolean delete(IAbstractFolder projectFolder, PropertyType type2) {
        IAbstractFile propFile;
        if (projectFolder.exists() && (propFile = projectFolder.getFile(type2.mFilename)).exists()) {
            return propFile.delete();
        }
        return false;
    }

    public static boolean delete(String projectFolderOsPath, PropertyType type2) {
        FolderWrapper wrapper = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.delete(wrapper, type2);
    }

    public static ProjectPropertiesWorkingCopy create(String projectFolderOsPath, PropertyType type2) {
        FolderWrapper folder = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.create(folder, type2);
    }

    public static ProjectPropertiesWorkingCopy create(IAbstractFolder projectFolder, PropertyType type2) {
        return new ProjectPropertiesWorkingCopy(projectFolder, new HashMap<String, String>(), type2);
    }

    public static ProjectProperties createEmpty(String projectFolderOsPath, PropertyType type2) {
        FolderWrapper folder = new FolderWrapper(projectFolderOsPath);
        return ProjectProperties.createEmpty(folder, type2);
    }

    public static ProjectProperties createEmpty(IAbstractFolder projectFolder, PropertyType type2) {
        return new ProjectProperties(projectFolder, new HashMap<String, String>(), type2);
    }

    public IAbstractFile getFile() {
        return this.mProjectFolder.getFile(this.mType.mFilename);
    }

    public ProjectPropertiesWorkingCopy makeWorkingCopy() {
        return this.makeWorkingCopy(this.mType);
    }

    public ProjectPropertiesWorkingCopy makeWorkingCopy(PropertyType type2) {
        HashMap<String, String> propList = new HashMap<String, String>(this.mProperties);
        return new ProjectPropertiesWorkingCopy(this.mProjectFolder, propList, type2);
    }

    public PropertyType getType() {
        return this.mType;
    }

    @Override
    public synchronized String getProperty(String name) {
        return this.mProperties.get(name);
    }

    public synchronized Set<String> keySet() {
        return new HashSet<String>(this.mProperties.keySet());
    }

    public synchronized void reload() {
        Map<String, String> map2;
        IAbstractFile propFile;
        if (this.mProjectFolder.exists() && (propFile = this.mProjectFolder.getFile(this.mType.mFilename)).exists() && (map2 = ProjectProperties.parsePropertyFile(propFile, null)) != null) {
            this.mProperties.clear();
            this.mProperties.putAll(map2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parsePropertyFile(IAbstractFile propFile, ILogger log) {
        InputStream is = null;
        try {
            is = propFile.getContents();
            Map<String, String> map2 = ProjectProperties.parsePropertyStream(is, propFile.getOsLocation(), log);
            return map2;
        }
        catch (StreamException e) {
            if (log != null) {
                log.warning("Error parsing '%1$s': %2$s.", propFile.getOsLocation(), e.getMessage());
            }
        }
        finally {
            try {
                Closeables.close(is, true);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> parsePropertyStream(InputStream propStream, String propPath, ILogger log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ProjectProperties(IAbstractFolder projectFolder, Map<String, String> map2, PropertyType type2) {
        this.mProjectFolder = projectFolder;
        this.mProperties = map2;
        this.mType = type2;
    }

    private static String unescape(String value) {
        return value.replaceAll("\\\\\\\\", "\\\\").replace("\\:", ":");
    }

    @Override
    public void debugPrint() {
        System.out.println("DEBUG PROJECTPROPERTIES: " + this.mProjectFolder);
        System.out.println("type: " + (Object)((Object)this.mType));
        for (Map.Entry<String, String> entry : this.mProperties.entrySet()) {
            System.out.println(entry.getKey() + " -> " + entry.getValue());
        }
        System.out.println("<<< DEBUG PROJECTPROPERTIES");
    }

    public static enum PropertyType {
        LOCAL("local.properties", "# This file is automatically generated by Android Tools.\n# Do not modify this file -- YOUR CHANGES WILL BE ERASED!\n#\n# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n", new String[]{"sdk.dir"}, new String[]{"sdk-location"}),
        LEGACY_DEFAULT("default.properties", null, null, null),
        LEGACY_BUILD("build.properties", null, null, null);

        private final String mFilename;
        private final String mHeader;
        private final Set<String> mKnownProps;
        private final Set<String> mRemovedProps;

        private PropertyType(String filename, String header, String[] validProps, String[] removedProps) {
            this.mFilename = filename;
            this.mHeader = header;
            HashSet<String> s2 = new HashSet<String>();
            if (validProps != null) {
                s2.addAll(Arrays.asList(validProps));
            }
            this.mKnownProps = Collections.unmodifiableSet(s2);
            s2 = new HashSet();
            if (removedProps != null) {
                s2.addAll(Arrays.asList(removedProps));
            }
            this.mRemovedProps = Collections.unmodifiableSet(s2);
        }

        public String getFilename() {
            return this.mFilename;
        }

        public String getHeader() {
            return this.mHeader;
        }

        public boolean isKnownProperty(String name) {
            for (String propRegex : this.mKnownProps) {
                if (!propRegex.equals(name) && !Pattern.matches(propRegex, name)) continue;
                return true;
            }
            return false;
        }

        public boolean isRemovedProperty(String name) {
            for (String propRegex : this.mRemovedProps) {
                if (!propRegex.equals(name) && !Pattern.matches(propRegex, name)) continue;
                return true;
            }
            return false;
        }
    }
}

