/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.resources.Density;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.ScreenType;

public class Screen {
    private ScreenSize mScreenSize;
    private double mDiagonalLength;
    private Density mPixelDensity;
    private ScreenRatio mScreenRatio;
    private int mXDimension;
    private int mYDimension;
    private double mXdpi;
    private double mYdpi;
    private Multitouch mMultitouch;
    private TouchScreen mMechanism;
    private ScreenType mScreenType;
    private int mChin;
    private ScreenRound mScreenRound;
    private int mFoldedXOffset;
    private int mFoldedYOffset;
    private int mFoldedWidth;
    private int mFoldedHeight;

    public ScreenSize getSize() {
        return this.mScreenSize;
    }

    public void setSize(ScreenSize s2) {
        this.mScreenSize = s2;
    }

    public double getDiagonalLength() {
        return this.mDiagonalLength;
    }

    public void setDiagonalLength(double diagonalLength) {
        this.mDiagonalLength = diagonalLength;
    }

    public Density getPixelDensity() {
        return this.mPixelDensity;
    }

    public void setPixelDensity(Density pDensity) {
        this.mPixelDensity = pDensity;
    }

    public ScreenRatio getRatio() {
        return this.mScreenRatio;
    }

    public void setRatio(ScreenRatio ratio) {
        this.mScreenRatio = ratio;
    }

    public int getXDimension() {
        return this.mXDimension;
    }

    public void setXDimension(int xDimension) {
        this.mXDimension = xDimension;
    }

    public int getYDimension() {
        return this.mYDimension;
    }

    public void setYDimension(int yDimension) {
        this.mYDimension = yDimension;
    }

    public double getXdpi() {
        return this.mXdpi;
    }

    public void setXdpi(double xdpi) {
        this.mXdpi = xdpi;
    }

    public double getYdpi() {
        return this.mYdpi;
    }

    public void setYdpi(double ydpi) {
        this.mYdpi = ydpi;
    }

    public Multitouch getMultitouch() {
        return this.mMultitouch;
    }

    public void setMultitouch(Multitouch m3) {
        this.mMultitouch = m3;
    }

    public TouchScreen getMechanism() {
        return this.mMechanism;
    }

    public void setMechanism(TouchScreen mechanism) {
        this.mMechanism = mechanism;
    }

    public ScreenType getScreenType() {
        return this.mScreenType;
    }

    public void setScreenType(ScreenType screenType) {
        this.mScreenType = screenType;
    }

    public ScreenRound getScreenRound() {
        return this.mScreenRound;
    }

    public void setScreenRound(ScreenRound screenRound) {
        this.mScreenRound = screenRound;
    }

    public boolean isFoldable() {
        return this.mFoldedHeight > 0 && this.mFoldedWidth > 0;
    }

    public void setFoldedXOffset(int xOffset) {
        this.mFoldedXOffset = xOffset;
    }

    public int getFoldedXOffset() {
        return this.mFoldedXOffset;
    }

    public void setFoldedYOffset(int yOffset) {
        this.mFoldedYOffset = yOffset;
    }

    public int getFoldedYOffset() {
        return this.mFoldedYOffset;
    }

    public void setFoldedWidth(int width) {
        this.mFoldedWidth = width;
    }

    public int getFoldedWidth() {
        return this.mFoldedWidth;
    }

    public void setFoldedHeight(int height) {
        this.mFoldedHeight = height;
    }

    public int getFoldedHeight() {
        return this.mFoldedHeight;
    }

    public int getChin() {
        return this.mChin;
    }

    public void setChin(int chin) {
        this.mChin = chin;
    }

    public Screen deepCopy() {
        Screen s2 = new Screen();
        s2.mScreenSize = this.mScreenSize;
        s2.mDiagonalLength = this.mDiagonalLength;
        s2.mPixelDensity = this.mPixelDensity;
        s2.mScreenRatio = this.mScreenRatio;
        s2.mXDimension = this.mXDimension;
        s2.mYDimension = this.mYDimension;
        s2.mXdpi = this.mXdpi;
        s2.mYdpi = this.mYdpi;
        s2.mMultitouch = this.mMultitouch;
        s2.mMechanism = this.mMechanism;
        s2.mScreenType = this.mScreenType;
        s2.mScreenRound = this.mScreenRound;
        s2.mChin = this.mChin;
        s2.mFoldedXOffset = this.mFoldedXOffset;
        s2.mFoldedYOffset = this.mFoldedYOffset;
        s2.mFoldedWidth = this.mFoldedWidth;
        s2.mFoldedHeight = this.mFoldedHeight;
        return s2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Screen)) {
            return false;
        }
        Screen s2 = (Screen)o;
        return s2.mScreenSize == this.mScreenSize && s2.mDiagonalLength == this.mDiagonalLength && s2.mPixelDensity == this.mPixelDensity && s2.mScreenRatio == this.mScreenRatio && s2.mXDimension == this.mXDimension && s2.mYDimension == this.mYDimension && s2.mXdpi == this.mXdpi && s2.mYdpi == this.mYdpi && s2.mMultitouch == this.mMultitouch && s2.mMechanism == this.mMechanism && s2.mScreenType == this.mScreenType && s2.mScreenRound == this.mScreenRound && s2.mChin == this.mChin && s2.mFoldedXOffset == this.mFoldedXOffset && s2.mFoldedYOffset == this.mFoldedYOffset && s2.mFoldedWidth == this.mFoldedWidth && s2.mFoldedHeight == this.mFoldedHeight;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.mScreenSize.ordinal();
        long f = Double.doubleToLongBits(this.mDiagonalLength);
        hash = 31 * hash + (int)(f ^ f >>> 32);
        hash = 31 * hash + this.mPixelDensity.ordinal();
        hash = 31 * hash + this.mScreenRatio.ordinal();
        hash = 31 * hash + this.mXDimension;
        hash = 31 * hash + this.mYDimension;
        f = Double.doubleToLongBits(this.mXdpi);
        hash = 31 * hash + (int)(f ^ f >>> 32);
        f = Double.doubleToLongBits(this.mYdpi);
        hash = 31 * hash + (int)(f ^ f >>> 32);
        hash = 31 * hash + this.mMultitouch.ordinal();
        hash = 31 * hash + this.mMechanism.ordinal();
        hash = 31 * hash + this.mScreenType.ordinal();
        hash = 31 * hash + this.mChin;
        if (this.mScreenRound != null) {
            hash = 31 * hash + this.mScreenRound.ordinal();
        }
        hash = 31 * hash + this.mFoldedXOffset;
        hash = 31 * hash + this.mFoldedYOffset;
        hash = 31 * hash + this.mFoldedWidth;
        hash = 31 * hash + this.mFoldedHeight;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Screen [mScreenSize=");
        sb.append(this.mScreenSize);
        sb.append(", mDiagonalLength=");
        sb.append(this.mDiagonalLength);
        sb.append(", mPixelDensity=");
        sb.append(this.mPixelDensity);
        sb.append(", mScreenRatio=");
        sb.append(this.mScreenRatio);
        sb.append(", mXDimension=");
        sb.append(this.mXDimension);
        sb.append(", mYDimension=");
        sb.append(this.mYDimension);
        sb.append(", mXdpi=");
        sb.append(this.mXdpi);
        sb.append(", mYdpi=");
        sb.append(this.mYdpi);
        sb.append(", mMultitouch=");
        sb.append((Object)this.mMultitouch);
        sb.append(", mMechanism=");
        sb.append(this.mMechanism);
        sb.append(", mScreenType=");
        sb.append((Object)this.mScreenType);
        sb.append(", mScreenRound=");
        sb.append(this.mScreenRound);
        sb.append(", mChin=");
        sb.append(this.mChin);
        sb.append(", mFoldableXOffset=");
        sb.append(this.mFoldedXOffset);
        sb.append(", mFoldableYOffset=");
        sb.append(this.mFoldedYOffset);
        sb.append(", mFoldableWidth=");
        sb.append(this.mFoldedWidth);
        sb.append(", mFoldableHeight=");
        sb.append(this.mFoldedHeight);
        sb.append("]");
        return sb.toString();
    }
}

