/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Meta;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.repository.targets.SystemImage;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Device {
    public static final double MINIMUM_TABLET_SIZE = 7.0;
    public static final double MINIMUM_TV_SIZE = 15.0;
    private final String mName;
    private final String mId;
    private final String mManufacturer;
    private final boolean mHasPlayStore;
    private final List<Software> mSoftware;
    private final List<State> mState;
    private final Meta mMeta;
    private final State mDefaultState;
    private String mTagId;
    private Map<String, String> mBootProps;
    private static Pattern PATTERN = Pattern.compile("(\\d+\\.?\\d*)(?:in|\") (.+?)( \\(.*Nexus.*\\))?");

    @Deprecated
    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        return this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public boolean hasPlayStore() {
        return this.mHasPlayStore;
    }

    public String getManufacturer() {
        return this.mManufacturer;
    }

    public List<Software> getAllSoftware() {
        return this.mSoftware;
    }

    public List<State> getAllStates() {
        return this.mState;
    }

    public Hardware getDefaultHardware() {
        return this.mDefaultState.getHardware();
    }

    public Meta getMeta() {
        return this.mMeta;
    }

    public State getDefaultState() {
        return this.mDefaultState;
    }

    public Software getSoftware(int apiVersion) {
        for (Software s2 : this.mSoftware) {
            if (apiVersion < s2.getMinSdkLevel() || apiVersion > s2.getMaxSdkLevel()) continue;
            return s2;
        }
        return null;
    }

    public State getState(String name) {
        for (State s2 : this.getAllStates()) {
            if (!s2.getName().equals(name)) continue;
            return s2;
        }
        return null;
    }

    public Dimension getScreenSize(ScreenOrientation orientation) {
        int screenHeight;
        int screenWidth;
        int y;
        Screen screen = this.getDefaultHardware().getScreen();
        if (screen == null) {
            return null;
        }
        int x = screen.getXDimension();
        if (x > (y = screen.getYDimension())) {
            if (orientation == ScreenOrientation.LANDSCAPE) {
                screenWidth = x;
                screenHeight = y;
            } else {
                screenWidth = y;
                screenHeight = x;
            }
        } else if (orientation == ScreenOrientation.LANDSCAPE) {
            screenWidth = y;
            screenHeight = x;
        } else {
            screenWidth = x;
            screenHeight = y;
        }
        return new Dimension(screenWidth, screenHeight);
    }

    public String getTagId() {
        return this.mTagId;
    }

    public Map<String, String> getBootProps() {
        return this.mBootProps;
    }

    public boolean isScreenRound() {
        return this.getDefaultHardware().getScreen().getScreenRound() == ScreenRound.ROUND;
    }

    public int getChinSize() {
        return this.getDefaultHardware().getScreen().getChin();
    }

    private Device(Builder b) {
        this.mName = b.mName;
        this.mId = b.mId;
        this.mManufacturer = b.mManufacturer;
        this.mHasPlayStore = b.mHasPlayStore;
        this.mSoftware = Collections.unmodifiableList(b.mSoftware);
        this.mState = Collections.unmodifiableList(b.mState);
        this.mMeta = b.mMeta;
        this.mDefaultState = b.mDefaultState;
        this.mTagId = b.mTagId;
        this.mBootProps = Collections.unmodifiableMap(b.mBootProps);
    }

    public boolean equals(Object o) {
        boolean ok;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device d = (Device)o;
        boolean bl = ok = this.mName.equals(d.getDisplayName()) && this.mManufacturer.equals(d.getManufacturer()) && this.mSoftware.equals(d.getAllSoftware()) && this.mState.equals(d.getAllStates()) && this.mMeta.equals(d.getMeta()) && this.mDefaultState.equals(d.getDefaultState());
        if (!ok) {
            return false;
        }
        boolean bl2 = ok = this.mTagId == null && d.mTagId == null || this.mTagId != null && this.mTagId.equals(d.mTagId);
        if (!ok) {
            return false;
        }
        ok = this.mBootProps == null && d.mBootProps == null || this.mBootProps != null && this.mBootProps.equals(d.mBootProps);
        return ok;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.mName.hashCode();
        hash = 31 * hash + this.mManufacturer.hashCode();
        hash = 31 * hash + this.mSoftware.hashCode();
        hash = 31 * hash + this.mState.hashCode();
        hash = 31 * hash + this.mMeta.hashCode();
        hash = 31 * hash + this.mDefaultState.hashCode();
        if (this.mTagId != null) {
            hash = 31 * hash + this.mTagId.hashCode();
        }
        if (this.mBootProps != null && !this.mBootProps.isEmpty()) {
            hash = 31 * hash + this.mBootProps.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Device [mName=");
        sb.append(this.mName);
        sb.append(", mId=");
        sb.append(this.mId);
        sb.append(", mManufacturer=");
        sb.append(this.mManufacturer);
        sb.append(", mSoftware=");
        sb.append(this.mSoftware);
        sb.append(", mState=");
        sb.append(this.mState);
        sb.append(", mMeta=");
        sb.append(this.mMeta);
        sb.append(", mDefaultState=");
        sb.append(this.mDefaultState);
        sb.append(", mTagId=");
        sb.append(this.mTagId);
        sb.append(", mBootProps=");
        sb.append(this.mBootProps);
        sb.append("]");
        return sb.toString();
    }

    private String getSortableName() {
        String sortableName = this.mName;
        Matcher matcher = PATTERN.matcher(sortableName);
        if (matcher.matches()) {
            String size = matcher.group(1);
            String n = matcher.group(2);
            int dot = size.indexOf(46);
            if (dot == -1) {
                size = size + ".0";
                dot = size.length() - 2;
            }
            if (dot < 3) {
                size = "000".substring(dot) + size;
            }
            sortableName = size + "\" " + n;
        }
        return sortableName;
    }

    public static Comparator<Device> getDisplayComparator() {
        return new Comparator<Device>(){

            @Override
            public int compare(Device d1, Device d2) {
                String s1 = d1.getSortableName();
                String s2 = d2.getSortableName();
                if (s1.length() > 1 && s2.length() > 1) {
                    int i2;
                    int i1 = Character.isDigit(s1.charAt(0)) ? 1 : 0;
                    int n = i2 = Character.isDigit(s2.charAt(0)) ? 1 : 0;
                    if (i1 != i2) {
                        return i1 - i2;
                    }
                }
                return s1.compareTo(s2);
            }
        };
    }

    public static class Builder {
        private String mName;
        private String mId;
        private String mManufacturer;
        private boolean mHasPlayStore;
        private final List<Software> mSoftware = new ArrayList<Software>();
        private final List<State> mState = new ArrayList<State>();
        private Meta mMeta;
        private State mDefaultState;
        private String mTagId;
        private final Map<String, String> mBootProps = new TreeMap<String, String>();

        public Builder() {
        }

        public Builder(Device d) {
            this.mTagId = null;
            this.mName = d.getDisplayName();
            this.mId = d.getId();
            this.mManufacturer = d.getManufacturer();
            this.mHasPlayStore = d.hasPlayStore();
            for (Software software : d.getAllSoftware()) {
                this.mSoftware.add(software.deepCopy());
            }
            for (State state : d.getAllStates()) {
                this.mState.add(state.deepCopy());
            }
            this.mMeta = d.getMeta();
        }

        public void setName(String name) {
            this.mName = name;
        }

        public void setId(String id) {
            this.mId = id;
        }

        public void setTagId(String tagId) {
            this.mTagId = tagId;
            if (SystemImage.WEAR_TAG.getId().equals(this.mTagId)) {
                this.mHasPlayStore = true;
            }
        }

        public void addBootProp(String propName, String propValue) {
            this.mBootProps.put(propName, propValue);
        }

        public void setManufacturer(String manufacturer) {
            this.mManufacturer = manufacturer;
        }

        public void setPlayStore(boolean hasPlayStore) {
            this.mHasPlayStore = hasPlayStore;
            if (SystemImage.WEAR_TAG.getId().equals(this.mTagId)) {
                this.mHasPlayStore = true;
            }
        }

        public void addSoftware(Software sw) {
            this.mSoftware.add(sw);
        }

        public void addAllSoftware(Collection<? extends Software> sw) {
            this.mSoftware.addAll(sw);
        }

        public void addState(State state) {
            this.mState.add(state);
        }

        public void addAllState(Collection<? extends State> states) {
            this.mState.addAll(states);
        }

        public boolean removeState(String stateName) {
            for (int i2 = 0; i2 < this.mState.size(); ++i2) {
                if (stateName == null || !stateName.equals(this.mState.get(i2).getName())) continue;
                this.mState.remove(i2);
                return true;
            }
            return false;
        }

        List<State> getAllStates() {
            return this.mState;
        }

        public void setMeta(Meta meta) {
            this.mMeta = meta;
        }

        public Device build() {
            if (this.mName == null) {
                throw this.generateBuildException("Device missing name");
            }
            if (this.mManufacturer == null) {
                throw this.generateBuildException("Device missing manufacturer");
            }
            if (this.mSoftware.size() <= 0) {
                throw this.generateBuildException("Device software not configured");
            }
            if (this.mState.size() <= 0) {
                throw this.generateBuildException("Device states not configured");
            }
            if (this.mId == null) {
                this.mId = this.mName;
            }
            if (this.mMeta == null) {
                this.mMeta = new Meta();
            }
            for (State s2 : this.mState) {
                if (!s2.isDefaultState()) continue;
                this.mDefaultState = s2;
                break;
            }
            if (this.mDefaultState == null) {
                throw this.generateBuildException("Device missing default state");
            }
            return new Device(this);
        }

        private IllegalStateException generateBuildException(String err) {
            String device = "";
            if (this.mManufacturer != null) {
                device = this.mManufacturer + ' ';
            }
            device = this.mName != null ? device + this.mName : "Unknown " + device + "Device";
            return new IllegalStateException("Error building " + device + ": " + err);
        }
    }
}

