/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import java.util.Properties;

public class AndroidVersionHelper {
    public static AndroidVersion create(Properties properties2, int defaultApiLevel, String defaultCodeName) {
        if (properties2 == null) {
            return new AndroidVersion(defaultApiLevel, defaultCodeName);
        }
        int api = Integer.parseInt(properties2.getProperty("AndroidVersion.ApiLevel", Integer.toString(defaultApiLevel)));
        String codeName = properties2.getProperty("AndroidVersion.CodeName", defaultCodeName);
        return new AndroidVersion(api, codeName);
    }

    public static AndroidVersion create(Properties properties2) throws AndroidVersion.AndroidVersionException {
        NumberFormatException error = null;
        String apiLevel = properties2.getProperty("AndroidVersion.ApiLevel", null);
        if (apiLevel != null) {
            try {
                int api = Integer.parseInt(apiLevel);
                String codeName = properties2.getProperty("AndroidVersion.CodeName", null);
                return new AndroidVersion(api, codeName);
            }
            catch (NumberFormatException e) {
                error = e;
            }
        }
        throw new AndroidVersion.AndroidVersionException("AndroidVersion.ApiLevel not found!", error);
    }
}

